/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.discovery;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.ui.UninstallRequest;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.internal.discovery.PrepareInstallProfileJob;

public class PrepareUninstallProfileJob
extends PrepareInstallProfileJob {
    public PrepareUninstallProfileJob(List<ConnectorDescriptor> connectors, UninstallRequest request) {
        super(connectors);
    }

    @Override
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (this.installableConnectors.isEmpty()) {
            throw null;
        }
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.preparingUninstall, (int)100);
            try {
                final IInstallableUnit[] ius = this.computeInstallableUnits(monitor.newChild(50));
                this.checkCancelled((IProgressMonitor)monitor);
                final UninstallOperation uninstallOperation = this.resolveUninstall((IProgressMonitor)monitor.newChild(50), ius, this.repositoryLocations.toArray(new URI[0]));
                this.checkCancelled((IProgressMonitor)monitor);
                RemediationOperation[] rops = new RemediationOperation[]{null};
                if (uninstallOperation != null && uninstallOperation.getResolutionResult().getSeverity() == 4) {
                    rops[0] = new RemediationOperation(ProvisioningUI.getDefaultUI().getSession(), uninstallOperation.getProfileChangeRequest());
                    rops[0].resolveModal((IProgressMonitor)monitor.newChild(500));
                }
                this.checkCancelled((IProgressMonitor)monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PrepareUninstallProfileJob.this.provisioningUI.openUninstallWizard(Arrays.asList(ius), uninstallOperation, null);
                    }
                });
            }
            finally {
                monitor.done();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }
}

