/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.discovery;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.discovery.ChainedDiscoveryStrategy;
import org.jboss.tools.project.examples.internal.discovery.ExpressionBasedBundleDiscoveryStrategy;
import org.jboss.tools.project.examples.internal.discovery.ExpressionBasedRemoteBundleDiscoveryStrategy;

public class DiscoveryUtil {
    private DiscoveryUtil() {
    }

    public static ConnectorDiscovery createConnectorDiscovery() {
        String directoryUrl = ProjectExamplesActivator.getDefault().getConfigurator().getJBossDiscoveryDirectory();
        return DiscoveryUtil.createConnectorDiscovery(directoryUrl);
    }

    public static ConnectorDiscovery createConnectorDiscovery(String directoryUrl) {
        ConnectorDiscovery connectorDiscovery = new ConnectorDiscovery();
        ChainedDiscoveryStrategy chainedDiscoveryStrategy = new ChainedDiscoveryStrategy(new ChainedDiscoveryStrategy.DiscoveryConnectorCollector());
        if (directoryUrl != null) {
            ExpressionBasedRemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new ExpressionBasedRemoteBundleDiscoveryStrategy();
            remoteDiscoveryStrategy.setDirectoryUrl(directoryUrl);
            chainedDiscoveryStrategy.addStrategy(remoteDiscoveryStrategy);
        }
        chainedDiscoveryStrategy.addStrategy((AbstractDiscoveryStrategy)new ExpressionBasedBundleDiscoveryStrategy());
        connectorDiscovery.getDiscoveryStrategies().add(chainedDiscoveryStrategy);
        connectorDiscovery.setVerifyUpdateSiteAvailability(true);
        connectorDiscovery.setEnvironment(DiscoveryUtil.getEnvironment());
        return connectorDiscovery;
    }

    private static Dictionary<Object, Object> getEnvironment() {
        Hashtable<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());
        return environment;
    }
}

