/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.cheatsheets.state.DefaultStateManager;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.configurators.DefaultJBossCentralConfigurator;
import org.jboss.tools.project.examples.configurators.IJBossCentralConfigurator;
import org.jboss.tools.project.examples.dialog.MarkerDialog;
import org.jboss.tools.project.examples.fixes.PluginFix;
import org.jboss.tools.project.examples.fixes.ProjectExamplesFix;
import org.jboss.tools.project.examples.fixes.SeamRuntimeFix;
import org.jboss.tools.project.examples.fixes.WTPRuntimeFix;
import org.jboss.tools.project.examples.model.IImportProjectExample;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleUtil;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.wizard.ContributedPage;
import org.jboss.tools.project.examples.wizard.ImportDefaultProjectExample;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesJob;
import org.jboss.tools.project.examples.wizard.ProjectReadyWizard;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.osgi.framework.BundleContext;

public class ProjectExamplesActivator
extends AbstractUIPlugin {
    private static final String SEPARATOR = "/";
    private static final int DESCRIPTION_LENGTH = 100;
    public static final String PROPERTY_PROJECT_NAME = "projectName";
    public static final String PROPERTY_LOCATION_PATH = "locationPath";
    public static final String PROPERTY_ARTIFACT_ID = "artifactId";
    private static final String README_HTML = "/readme.html";
    private static final String CHEATSHEET_XML = "/cheatsheet.xml";
    private static final String PERIOD_CHEATSHEET_XML = "/.cheatsheet.xml";
    private static final String README_MD = "/readme.md";
    private static final String README_TXT = "/readme.txt";
    private static final String README_MDU = "/README.md";
    public static final String PLUGIN_ID = "org.jboss.tools.project.examples";
    public static final String ALL_SITES = Messages.ProjectExamplesActivator_All;
    public static final String ALL_RUNTIMES = Messages.ProjectExamplesActivator_All;
    public static final String SHOW_EXPERIMENTAL_SITES = "showExperimentalSites";
    public static final String SHOW_RUNTIME_SITES = "showRuntimeSites";
    public static final String USER_SITES = "userSites";
    public static final boolean SHOW_EXPERIMENTAL_SITES_VALUE = false;
    public static final boolean SHOW_RUNTIME_SITES_VALUE = false;
    public static final String SHOW_INVALID_SITES = "invalidSites";
    public static final boolean SHOW_INVALID_SITES_VALUE = true;
    public static final String MAVEN_ARCHETYPE = "mavenArchetype";
    public static final Object PROJECT_EXAMPLES_FAMILY = new Object();
    public static final String PROJECT_EXAMPLES_OUTPUT_DIRECTORY = "projectExamplesOutputDirectory";
    public static final String PROJECT_EXAMPLES_DEFAULT = "projectExamplesDefaultLocation";
    public static final boolean PROJECT_EXAMPLES_DEFAULT_VALUE = true;
    public static final String SHOW_PROJECT_READY_WIZARD = "showProjectRadyWizard";
    public static final boolean SHOW_PROJECT_READY_WIZARD_VALUE = true;
    public static final String SHOW_README = "showReadme";
    public static final boolean SHOW_README_VALUE = true;
    public static final String SHOW_QUICK_FIX = "showQuickFix";
    public static final boolean SHOW_QUICK_FIX_VALUE = true;
    public static final String PROJECT_EXAMPLES_OFFLINE_DIRECTORY = "projectExamplesOfflineDirectory";
    public static final String PROJECT_EXAMPLES_OFFLINE_DIRECTORY_VALUE = new File(System.getProperty("user.home"), ".jbosstools/cache").getAbsolutePath();
    public static final String PROJECT_EXAMPLES_OFFLINE_ENABLED = "projectExamplesOfflineEnabled";
    public static final boolean PROJECT_EXAMPLES_OFFLINE_ENABLED_VALUE = false;
    private static final String IMPORT_PROJECT_EXAMPLES_EXTENSION_ID = "org.jboss.tools.project.examples.importProjectExamples";
    private static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    public static final String CONFIGURATORS_EXTENSION_ID = "org.jboss.tools.project.examples.configurators";
    public static final String WIZARDPAGES_EXTENSION_ID = "org.jboss.tools.project.examples.wizardpages";
    private IJBossCentralConfigurator configurator;
    public static final String JBOSS_DISCOVERY_DIRECTORY = "jboss.discovery.directory.url";
    private static final Object CONFIGURATOR = "configurator";
    public static final String SHOW_CHEATSHEETS = "showCheatsheets";
    public static final String SHOW_CHEATSHEETS_PROMPT = "prompt";
    public static final String SHOW_CHEATSHEETS_NEVER = "never";
    public static final String SHOW_CHEATSHEETS_ALWAYS = "always";
    private static ProjectExamplesActivator plugin;
    private static BundleContext context;
    public static Job waitForBuildAndValidation;
    private Map<String, IImportProjectExample> importProjectExamplesMap;
    private ImportDefaultProjectExample defaultImportProjectExample;
    private Map<String, List<ContributedPage>> contributedPages;
    private static final String CENTRAL_COMPONENT_NAME = "central";
    private static final String EXAMPLES_COMPONENT_NAME = "examples";
    private static final String INSTALL_ACTION = "install";
    private static final String CREATE_FROM_EXAMPLE_ACTION = "create";
    private UsageEventType installSoftwareEventType;
    private UsageEventType createProjectFromExampleEventType;

    static {
        waitForBuildAndValidation = new Job(Messages.ProjectExamplesActivator_Waiting){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        ResourcesPlugin.getWorkspace().build(10, monitor);
                    }
                    catch (CoreException e) {
                        ProjectExamplesActivator.log(e);
                    }
                    Job.getJobManager().join(PROJECT_EXAMPLES_FAMILY, monitor);
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                    Job.getJobManager().join(ValidationBuilder.FAMILY_VALIDATION_JOB, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ProjectExamplesActivator.context = context;
        plugin = this;
        String version = UsageEventType.getVersion((Plugin)this);
        this.installSoftwareEventType = new UsageEventType(CENTRAL_COMPONENT_NAME, version, null, INSTALL_ACTION, Messages.UsageEventTypeInstallLabelDescription);
        UsageReporter.getInstance().registerEvent(this.installSoftwareEventType);
        this.createProjectFromExampleEventType = new UsageEventType(EXAMPLES_COMPONENT_NAME, version, null, CREATE_FROM_EXAMPLE_ACTION, Messages.ProjectExamplesActivator_UsageEventTypeCreateProjectFromExampleDescription);
        UsageReporter.getInstance().registerEvent(this.createProjectFromExampleEventType);
    }

    public UsageEventType getInstallSoftwareEventType() {
        return this.installSoftwareEventType;
    }

    public UsageEventType getCreateProjectFromExampleEventType() {
        return this.createProjectFromExampleEventType;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        context = null;
    }

    public static ProjectExamplesActivator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        ProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(2, PLUGIN_ID, message);
        ProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public static List<IMarker> getMarkers(List<? extends ProjectExample> projects) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        for (ProjectExample projectExample : projects) {
            try {
                if (projectExample.getIncludedProjects() == null) {
                    String projectName = projectExample.getName();
                    ProjectExamplesActivator.getMarkers(markers, projectName);
                    continue;
                }
                List<String> includedProjects = projectExample.getIncludedProjects();
                for (String projectName : includedProjects) {
                    ProjectExamplesActivator.getMarkers(markers, projectName);
                }
            }
            catch (CoreException e) {
                ProjectExamplesActivator.log(e);
            }
        }
        return markers;
    }

    private static List<IMarker> getMarkers(List<IMarker> markers, String projectName) throws CoreException {
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (eclipseProject.isAccessible()) {
            IMarker[] projectMarkers = eclipseProject.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int i = 0;
            while (i < projectMarkers.length) {
                if (projectMarkers[i].getAttribute("severity", 2) == 2) {
                    markers.add(projectMarkers[i]);
                }
                ++i;
            }
        } else {
            ProjectExamplesActivator.log(String.valueOf(projectName) + " is inaccessible");
        }
        return markers;
    }

    public static IProject[] getEclipseProject(ProjectExample project, ProjectFix fix) {
        String pName = fix.getProperties().get("eclipse-projects");
        if (pName == null) {
            List<String> projectNames = project.getIncludedProjects();
            ArrayList<IProject> projects = new ArrayList<IProject>();
            if (projectNames != null) {
                for (String projectName : projectNames) {
                    IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (eclipseProject == null || !eclipseProject.isOpen()) continue;
                    projects.add(eclipseProject);
                }
            }
            return projects.toArray(new IProject[0]);
        }
        pName = ProjectExamplesActivator.replace(pName, project);
        StringTokenizer tokenizer = new StringTokenizer(pName, ",");
        ArrayList<IProject> projects = new ArrayList<IProject>();
        while (tokenizer.hasMoreTokens()) {
            IProject eclipseProject;
            String projectName = tokenizer.nextToken().trim();
            if (projectName == null || projectName.length() <= 0 || (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) == null || !eclipseProject.isOpen()) continue;
            projects.add(eclipseProject);
        }
        return projects.toArray(new IProject[0]);
    }

    public static String replace(String name, ProjectExample project) {
        List<String> includedProjects = project.getIncludedProjects();
        if (includedProjects != null) {
            int i = 0;
            for (String includedProject : includedProjects) {
                String expression = "${project[" + i + "]}";
                name = name.replace(expression, includedProject);
                ++i;
            }
        }
        return name;
    }

    public IImportProjectExample getImportProjectExample(String importType) {
        this.initImportProjectExamples();
        if (importType == null || "zip".equals(importType)) {
            return this.defaultImportProjectExample;
        }
        return this.importProjectExamplesMap.get(importType);
    }

    private void initImportProjectExamples() {
        if (this.importProjectExamplesMap == null) {
            this.defaultImportProjectExample = new ImportDefaultProjectExample();
            this.importProjectExamplesMap = new HashMap<String, IImportProjectExample>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(IMPORT_PROJECT_EXAMPLES_EXTENSION_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    block5: {
                        IImportProjectExample importProjectExample;
                        IConfigurationElement configurationElement = configurationElements[j];
                        try {
                            importProjectExample = (IImportProjectExample)configurationElement.createExecutableExtension(CLASS);
                        }
                        catch (CoreException e) {
                            ProjectExamplesActivator.log(e);
                            break block5;
                        }
                        String name = configurationElement.getAttribute(NAME);
                        String type = configurationElement.getAttribute(TYPE);
                        importProjectExample.setName(name);
                        importProjectExample.setType(type);
                        this.importProjectExamplesMap.put(type, importProjectExample);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void fix(ProjectExample project, IProgressMonitor monitor) {
        List<ProjectFix> fixes = project.getFixes();
        for (ProjectFix fix : fixes) {
            ProjectExamplesFix projectExamplesFix = ProjectExamplesFixFactory.getProjectFix(fix);
            if (projectExamplesFix == null) continue;
            projectExamplesFix.fix(project, fix, monitor);
        }
    }

    public static boolean downloadProject(ProjectExample project, IProgressMonitor monitor) {
        if (project.isURLRequired()) {
            String urlString = project.getUrl();
            String name = project.getName();
            URL url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                ProjectExamplesActivator.log(e);
                return false;
            }
            File file = ProjectExampleUtil.getProjectExamplesFile(url, name, ".zip", monitor);
            if (file == null) {
                return false;
            }
            ProjectExampleUtil.setProjectExamplesFile(project, file);
        }
        return true;
    }

    public static void copyFile(File inputFile, File outputFile) throws FileNotFoundException, IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(inputFile);
            out = new FileOutputStream(outputFile);
            ProjectExamplesActivator.copy(in, out);
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void openWelcome(List<ProjectExampleWorkingCopy> projects) {
        if (projects == null) {
            return;
        }
        for (final ProjectExampleWorkingCopy project : projects) {
            ProjectExamplesActivator.fixWelcome(project);
            if (!project.isWelcome()) continue;
            String urlString = project.getWelcomeURL();
            urlString = ProjectExamplesActivator.replace(urlString, project);
            URL url = null;
            if (urlString.startsWith(SEPARATOR)) {
                Path path = new Path(urlString);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (resource instanceof IFile && resource.isAccessible()) {
                    try {
                        url = resource.getRawLocationURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        ProjectExamplesActivator.log(e);
                    }
                } else {
                    ProjectExamplesActivator.log(NLS.bind((String)Messages.NewProjectExamplesWizard_File_does_not_exist, (Object)urlString));
                }
            } else {
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException e) {
                    ProjectExamplesActivator.log(e);
                }
            }
            if (url == null) continue;
            final URL finalURL = url;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    block16: {
                        if ("cheatsheets".equals(project.getType())) {
                            CheatSheetView view = ViewUtilities.showCheatSheetView();
                            if (view == null) {
                                return;
                            }
                            Path filePath = new Path(finalURL.getPath());
                            String id = filePath.lastSegment();
                            if (id == null) {
                                id = "";
                            }
                            view.getCheatSheetViewer().setInput(id, id, finalURL, (ICheatSheetStateManager)new DefaultStateManager(), false);
                        } else {
                            try {
                                if (finalURL.toString().endsWith(".htm") || finalURL.toString().endsWith(".html")) {
                                    IWorkbenchBrowserSupport browserSupport = ProjectExamplesActivator.getDefault().getWorkbench().getBrowserSupport();
                                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                                    browser.openURL(finalURL);
                                    break block16;
                                }
                                boolean txtFile = finalURL.toString().endsWith(".md") || finalURL.toString().endsWith(".txt");
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                IFile[] files = null;
                                try {
                                    files = root.findFilesForLocationURI(finalURL.toURI());
                                }
                                catch (URISyntaxException e1) {
                                    ProjectExamplesActivator.log(e1);
                                    return;
                                }
                                if (files.length > 0) {
                                    try {
                                        if (txtFile) {
                                            FileEditorInput input = new FileEditorInput(files[0]);
                                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor");
                                            break block16;
                                        }
                                        IDE.openEditor((IWorkbenchPage)page, (IFile)files[0]);
                                    }
                                    catch (PartInitException e) {
                                        ProjectExamplesActivator.log(e);
                                    }
                                    break block16;
                                }
                                IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(finalURL.getPath()));
                                try {
                                    FileStoreEditorInput input = new FileStoreEditorInput(store);
                                    if (txtFile) {
                                        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor");
                                        break block16;
                                    }
                                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)ProjectExamplesActivator.getEditorId(store));
                                }
                                catch (PartInitException e) {
                                    ProjectExamplesActivator.log(e);
                                }
                            }
                            catch (PartInitException e) {
                                ProjectExamplesActivator.log(e);
                            }
                        }
                    }
                }
            });
        }
    }

    private static String getEditorId(IFileStore fileStore) throws PartInitException {
        String name = fileStore.fetchInfo().getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = null;
        try {
            InputStream is = null;
            try {
                is = fileStore.openInputStream(0, null);
                contentType = Platform.getContentTypeManager().findContentTypeFor(is, name);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        return ProjectExamplesActivator.getEditorDescriptor(name, editorReg, editorReg.getDefaultEditor(name, contentType)).getId();
    }

    private static IEditorDescriptor getEditorDescriptor(String name, IEditorRegistry editorReg, IEditorDescriptor defaultDescriptor) throws PartInitException {
        if (defaultDescriptor != null) {
            return defaultDescriptor;
        }
        IEditorDescriptor editorDesc = defaultDescriptor;
        if (editorReg.isSystemInPlaceEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDesc == null && editorReg.isSystemExternalEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDesc == null) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (editorDesc == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return editorDesc;
    }

    public static void fixWelcome(ProjectExampleWorkingCopy project) {
        if (project == null) {
            return;
        }
        if (!project.isWelcomeFixRequired()) {
            return;
        }
        ProjectExamplesActivator.checkCheatsheet(project);
    }

    protected static void checkCheatsheet(ProjectExampleWorkingCopy project) {
        List<String> includedProjects = project.getIncludedProjects();
        if (includedProjects == null || includedProjects.size() <= 0) {
            return;
        }
        for (String projectName : includedProjects) {
            IProject eclipseProject;
            if (projectName == null || projectName.isEmpty() || (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) == null || !eclipseProject.exists()) continue;
            if (ProjectExamplesActivator.checkCheatsheet(project, eclipseProject, PERIOD_CHEATSHEET_XML, "cheatsheets")) {
                return;
            }
            if (ProjectExamplesActivator.checkCheatsheet(project, eclipseProject, CHEATSHEET_XML, "cheatsheets")) {
                return;
            }
            if (ProjectExamplesActivator.checkCheatsheet(project, eclipseProject, README_HTML, "editor")) {
                return;
            }
            if (ProjectExamplesActivator.checkCheatsheet(project, eclipseProject, README_MD, "editor")) {
                return;
            }
            if (ProjectExamplesActivator.checkCheatsheet(project, eclipseProject, README_MDU, "editor")) {
                return;
            }
            if (!ProjectExamplesActivator.checkCheatsheet(project, eclipseProject, README_TXT, "editor")) continue;
            return;
        }
    }

    private static boolean checkCheatsheet(ProjectExampleWorkingCopy project, IProject eclipseProject, String path, String type) {
        IResource cheatsheet = eclipseProject.findMember(path);
        if (cheatsheet != null && cheatsheet.exists() && cheatsheet.getType() == 1) {
            project.setWelcome(true);
            project.setType(type);
            project.setWelcomeURL(cheatsheet.getFullPath().toString());
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static boolean extractZipFile(File file, File destination, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[16384];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    public static boolean canFix(ProjectExample project, ProjectFix fix) {
        String type = fix.getType();
        if ("plugin".equals(type)) {
            return new PluginFix().canFix(project, fix);
        }
        if ("wtpruntime".equals(type)) {
            return new WTPRuntimeFix().canFix(project, fix);
        }
        if ("seam".equals(type)) {
            return new SeamRuntimeFix().canFix(project, fix);
        }
        ProjectExamplesActivator.log(NLS.bind((String)Messages.NewProjectExamplesWizardPage_Invalid_fix, (Object)project.getName()));
        return true;
    }

    public static void updatePerspective(List<? extends ProjectExample> projects) {
        if (projects == null || projects.size() != 1) {
            return;
        }
        final String perspectiveId = projects.get(0).getPerspectiveId();
        if (perspectiveId == null || perspectiveId.length() <= 0) {
            return;
        }
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals(SHOW_CHEATSHEETS_PROMPT) && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        final IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(perspectiveId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            IDEWorkbenchPlugin.log((String)("Unable to find perspective " + perspectiveId + " in NewProjectExamplesWizard.updatePerspective"));
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ProjectExamplesActivator.switchPerspective(perspectiveId, finalPersp, win);
                }
            });
        } else {
            ProjectExamplesActivator.switchPerspective(perspectiveId, finalPersp, window);
        }
    }

    private static void switchPerspective(String perspectiveId, IPerspectiveDescriptor finalPersp, IWorkbenchWindow window) {
        IPerspectiveDescriptor currentPersp;
        IWorkbenchPage page;
        if (window != null && (page = window.getActivePage()) != null && (currentPersp = page.getPerspective()) != null && perspectiveId.equals(currentPersp.getId())) {
            return;
        }
        if (!ProjectExamplesActivator.confirmPerspectiveSwitch(window, finalPersp)) {
            return;
        }
        int workbenchPerspectiveSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE");
        if (workbenchPerspectiveSetting == 2) {
            ProjectExamplesActivator.openInNewWindow(finalPersp);
            return;
        }
        ProjectExamplesActivator.replaceCurrentPerspective(finalPersp);
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!SHOW_CHEATSHEETS_PROMPT.equals(pspm)) {
            return SHOW_CHEATSHEETS_ALWAYS.equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)ResourceMessages.NewProject_errorOpeningWindow, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public static void showReadyWizard(final List<ProjectExampleWorkingCopy> projects) {
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        boolean showProjectReadyWizard = store.getBoolean(SHOW_PROJECT_READY_WIZARD);
        if (!showProjectReadyWizard) {
            List<IMarker> markers;
            boolean showQuickFix;
            boolean openWelcome = store.getBoolean(SHOW_README);
            if (openWelcome) {
                ProjectExamplesActivator.openWelcome(projects);
            }
            if ((showQuickFix = store.getBoolean(SHOW_QUICK_FIX)) && (markers = ProjectExamplesActivator.getMarkers(projects)) != null && markers.size() > 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MarkerDialog dialog = new MarkerDialog(Display.getCurrent().getActiveShell(), projects);
                        dialog.open();
                    }
                });
            }
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ProjectReadyWizard wizard = new ProjectReadyWizard(projects);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
        });
    }

    public static void importProjectExamples(List<ProjectExampleWorkingCopy> selectedProjects, IWorkingSet[] workingSets, final Map<String, Object> propertiesMap) {
        final NewProjectExamplesJob workspaceJob = new NewProjectExamplesJob(Messages.NewProjectExamplesWizard_Downloading, selectedProjects, workingSets, propertiesMap);
        workspaceJob.setUser(true);
        workspaceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!workspaceJob.getResult().isOK()) {
                    this.resetCheatSheet(propertiesMap);
                    return;
                }
                List<ProjectExampleWorkingCopy> projects = workspaceJob.getProjects();
                try {
                    ProjectExamplesActivator.updatePerspective(projects);
                    waitForBuildAndValidation.schedule();
                    waitForBuildAndValidation.join();
                    this.resetCheatSheet(propertiesMap);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (projects != null && projects.size() > 0) {
                    ProjectExamplesActivator.showReadyWizard(projects);
                }
            }

            private void resetCheatSheet(Map<String, Object> propertiesMap2) {
                Object showCheatSheet = propertiesMap2.get(ProjectExamplesActivator.SHOW_CHEATSHEETS);
                if (showCheatSheet instanceof String) {
                    ProjectExamplesActivator.getDefault().getPreferenceStore().putValue(ProjectExamplesActivator.SHOW_CHEATSHEETS, (String)showCheatSheet);
                }
            }
        });
        workspaceJob.schedule();
    }

    public Image getImage(ImageDescriptor imageDescriptor) {
        String id;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(id = this.getImageId(imageDescriptor));
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put(id, image);
        }
        return image;
    }

    private String getImageId(ImageDescriptor imageDescriptor) {
        return "org.jboss.tools.project.examples/" + imageDescriptor.hashCode();
    }

    public Image getImage(String imagePath) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(imagePath);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = ProjectExamplesActivator.getImageDescriptor(imagePath);
        image = imageDescriptor.createImage();
        registry.put(imagePath, image);
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ProjectExamplesActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Map<String, List<ContributedPage>> getContributedPages() {
        if (this.contributedPages == null) {
            this.contributedPages = new HashMap<String, List<ContributedPage>>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(WIZARDPAGES_EXTENSION_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    IConfigurationElement configurationElement = configurationElements[j];
                    String clazz = configurationElement.getAttribute(CLASS);
                    String priorityString = configurationElement.getAttribute(PRIORITY);
                    int priority = 0;
                    if (priorityString != null) {
                        try {
                            priority = Integer.parseInt(priorityString);
                        }
                        catch (NumberFormatException e) {
                            ProjectExamplesActivator.log(e);
                        }
                    }
                    String type = configurationElement.getAttribute(TYPE);
                    String pageType = configurationElement.getAttribute("pageType");
                    ContributedPage contributedPage = new ContributedPage(configurationElement, type, pageType, priority, clazz);
                    List<ContributedPage> contributions = this.contributedPages.get(type);
                    if (contributions == null) {
                        contributions = new ArrayList<ContributedPage>();
                        this.contributedPages.put(type, contributions);
                    }
                    contributions.add(contributedPage);
                    Collections.sort(contributions);
                    ++j;
                }
                ++i;
            }
        }
        return this.contributedPages;
    }

    public IJBossCentralConfigurator getConfigurator() {
        if (this.configurator == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(CONFIGURATORS_EXTENSION_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions.length > 1) {
                int i = 1;
                while (i < extensions.length) {
                    this.logIgnoredExtensionPoint(extensions[i]);
                    ++i;
                }
            }
            if (extensions.length > 0) {
                IExtension extension = extensions[0];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    IConfigurationElement configurationElement = configurationElements[j];
                    if (CONFIGURATOR.equals(configurationElement.getName())) {
                        try {
                            this.configurator = (IJBossCentralConfigurator)configurationElement.createExecutableExtension(CLASS);
                            break;
                        }
                        catch (CoreException e) {
                            ProjectExamplesActivator.log(e);
                        }
                    }
                    ++j;
                }
            }
            if (this.configurator == null) {
                this.configurator = new DefaultJBossCentralConfigurator();
            }
        }
        return this.configurator;
    }

    private void logIgnoredExtensionPoint(IExtension extension) {
        String className = null;
        IConfigurationElement[] configurationElements = extension.getConfigurationElements();
        int j = 0;
        while (j < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[j];
            if (CONFIGURATOR.equals(configurationElement.getName())) {
                className = configurationElement.getAttribute(CLASS);
            }
            ++j;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("The configurators extension point is ignored: classname=");
        builder.append(className);
        if (extension.getContributor() != null && extension.getContributor().getName() != null) {
            builder.append(",pluginId=");
            builder.append(extension.getContributor().getName());
        }
        ProjectExamplesActivator.log(builder.toString());
    }

    public static String getShortDescription(String description) {
        if (description.length() <= 100) {
            return description;
        }
        char[] chars = StringEscapeUtils.unescapeHtml((String)description.trim()).toCharArray();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (i++ < 100) {
                buffer.append(c);
            } else {
                if (!(c == '_' || c >= 'a' && c <= 'z' || c >= 'a' && c <= 'Z') && (c < '0' || c > '9')) break;
                buffer.append(c);
            }
            ++n2;
        }
        if (buffer.length() > 0) {
            buffer.append("...");
        }
        return buffer.toString();
    }

    public String getShowCheatsheets() {
        return this.getPreferenceStore().getString(SHOW_CHEATSHEETS);
    }

    private static class ProjectExamplesFixFactory {
        private ProjectExamplesFixFactory() {
        }

        public static ProjectExamplesFix getProjectFix(ProjectFix fix) {
            if ("wtpruntime".equals(fix.getType())) {
                return new WTPRuntimeFix();
            }
            if ("seam".equals(fix.getType())) {
                return new SeamRuntimeFix();
            }
            return null;
        }
    }
}

