/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.jboss.tools.maven.apt.MavenJdtAptPlugin;
import org.jboss.tools.maven.apt.internal.utils.AnnotationServiceLocator;

public class ProjectUtils {
    private static final Pattern OPTION_PATTERN = Pattern.compile("-A([^ \\t\"']+)");

    public static Map<String, String> parseProcessorOptions(String compilerArgument) {
        if (compilerArgument == null || compilerArgument.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        Matcher matcher = OPTION_PATTERN.matcher(compilerArgument);
        int start = 0;
        while (matcher.find(start)) {
            String value;
            String key;
            String argument = matcher.group(1);
            int optionalEqualsIndex = argument.indexOf(61);
            if (optionalEqualsIndex != -1) {
                key = argument.substring(0, optionalEqualsIndex);
                value = argument.substring(optionalEqualsIndex + 1, argument.length());
            } else {
                key = argument;
                value = null;
            }
            ret.put(key, value);
            start = matcher.end();
        }
        return ret;
    }

    public static Map<String, String> parseProcessorOptions(List<String> compilerArgs) {
        if (compilerArgs == null || compilerArgs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (String arg : compilerArgs) {
            if (!arg.startsWith("-A")) continue;
            options.putAll(ProjectUtils.parseProcessorOptions(arg));
        }
        return options;
    }

    public static Map<String, String> extractProcessorOptions(Map<String, String> compilerArguments) {
        if (compilerArguments == null || compilerArguments.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> ret = new HashMap<String, String>(compilerArguments.size());
        for (Map.Entry<String, String> argument : compilerArguments.entrySet()) {
            String key = argument.getKey();
            if (!key.startsWith("A")) continue;
            String value = argument.getValue();
            if (value != null && value.length() > 0) {
                ret.put(key.substring(1), value);
                continue;
            }
            ret.put(key.substring(1), null);
        }
        return ret;
    }

    public static boolean isValidOptionName(String optionName) {
        if (optionName == null) {
            return false;
        }
        boolean startExpected = true;
        int i = 0;
        while (i < optionName.length()) {
            int codePoint = optionName.codePointAt(i);
            if (startExpected) {
                if (!Character.isJavaIdentifierStart(codePoint)) {
                    return false;
                }
                startExpected = false;
            } else if (codePoint == 46) {
                startExpected = true;
            } else if (!Character.isJavaIdentifierPart(codePoint)) {
                return false;
            }
            i += Character.charCount(codePoint);
        }
        return !startExpected;
    }

    public static File convertToProjectRelativePath(IProject project, File fileToConvert) {
        File absoluteFile = fileToConvert.getAbsoluteFile();
        String absoluteFilePath = absoluteFile.getAbsolutePath();
        File projectBasedirFile = project.getLocation().toFile().getAbsoluteFile();
        String projectBasedirFilePath = projectBasedirFile.getAbsolutePath();
        if (absoluteFile.equals(projectBasedirFile)) {
            return new File(".");
        }
        if (absoluteFilePath.startsWith(projectBasedirFilePath)) {
            String projectRelativePath = absoluteFilePath.substring(projectBasedirFilePath.length() + 1);
            return new File(projectRelativePath);
        }
        return absoluteFile;
    }

    public static List<Artifact> getProjectArtifacts(IMavenProjectFacade mavenProjectFacade) {
        Set unorderedArtifacts = mavenProjectFacade.getMavenProject().getArtifacts();
        ArrayList<Artifact> orderedArtifacts = new ArrayList<Artifact>(unorderedArtifacts.size());
        for (Artifact artifact : unorderedArtifacts) {
            orderedArtifacts.add(artifact);
        }
        return orderedArtifacts;
    }

    public static List<File> filterToResolvedJars(List<Artifact> artifacts) {
        ArrayList<File> resolvedJarArtifacts = new ArrayList<File>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("compile+runtime");
        for (Artifact artifact : artifacts) {
            File artifactJarFile;
            if (!artifact.isResolved() || artifact.getArtifactHandler() == null || !"jar".equalsIgnoreCase(artifact.getArtifactHandler().getExtension()) || !filter.include(artifact) || !(artifactJarFile = artifact.getFile()).isFile()) continue;
            resolvedJarArtifacts.add(artifactJarFile);
        }
        return resolvedJarArtifacts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsAptProcessors(Collection<File> resolvedJarArtifacts) {
        try {
            File resolvedJarArtifact;
            Set<AnnotationServiceLocator.ServiceEntry> aptServiceEntries;
            Iterator<File> iterator = resolvedJarArtifacts.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((aptServiceEntries = AnnotationServiceLocator.getAptServiceEntries(resolvedJarArtifact = iterator.next())).isEmpty());
            return true;
        }
        catch (IOException e) {
            MavenJdtAptPlugin.createErrorStatus(e, "Error while reading artifact JARs.");
        }
        return false;
    }

    public static void disableApt(IProject project) {
        if (project == null) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && AptConfig.isEnabled((IJavaProject)javaProject)) {
            AptConfig.setEnabled((IJavaProject)javaProject, (boolean)false);
        }
    }
}

