/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.jboss.tools.maven.apt.MavenJdtAptPlugin;
import org.jboss.tools.maven.apt.internal.AptConfiguratorDelegate;
import org.jboss.tools.maven.apt.preferences.AnnotationProcessingMode;
import org.jboss.tools.maven.apt.preferences.IPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAptProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AbstractAptProjectConfigurator.class);

    protected abstract AptConfiguratorDelegate getDelegate(AnnotationProcessingMode var1);

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (request == null || monitor == null) {
            return;
        }
        IMavenProjectFacade mavenProjectFacade = request.getMavenProjectFacade();
        AnnotationProcessingMode mode = this.getAnnotationProcessorMode(mavenProjectFacade);
        MavenSession mavenSession = request.getMavenSession();
        AptConfiguratorDelegate configuratorDelegate = this.getDelegate(mode);
        configuratorDelegate.setSession(mavenSession);
        configuratorDelegate.setFacade(mavenProjectFacade);
        if (!configuratorDelegate.isIgnored(monitor)) {
            configuratorDelegate.configureProject(monitor);
        }
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) {
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        IProject eclipseProject = request.getProject();
        if (!eclipseProject.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        AptConfiguratorDelegate delegate = this.getDelegate(request.getMavenProjectFacade());
        delegate.setFacade(request.getMavenProjectFacade());
        delegate.setSession(request.getMavenSession());
        if (!delegate.isIgnored(monitor)) {
            delegate.configureClasspath(classpath, monitor);
        }
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        try {
            AptConfiguratorDelegate configuratorDelegate = this.getDelegate(projectFacade);
            return configuratorDelegate.getMojoExecutionBuildParticipant(execution);
        }
        catch (CoreException ex) {
            log.error("Unable to get the build participant for annotation processing", (Throwable)ex);
            return null;
        }
    }

    private AptConfiguratorDelegate getDelegate(IMavenProjectFacade facade) throws CoreException {
        AnnotationProcessingMode mode = this.getAnnotationProcessorMode(facade);
        return this.getDelegate(mode);
    }

    protected AnnotationProcessingMode getAnnotationProcessorMode(IMavenProjectFacade facade) throws CoreException {
        IPreferencesManager preferencesManager = MavenJdtAptPlugin.getDefault().getPreferencesManager();
        AnnotationProcessingMode mode = preferencesManager.getAnnotationProcessorMode(facade.getProject());
        return mode;
    }
}

