/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.FetchMode;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.jboss.tools.hibernate.proxy.ColumnProxy;
import org.jboss.tools.hibernate.proxy.PersistentClassProxy;
import org.jboss.tools.hibernate.proxy.PropertyProxy;
import org.jboss.tools.hibernate.proxy.TableProxy;
import org.jboss.tools.hibernate.proxy.TypeProxy;
import org.jboss.tools.hibernate.spi.IColumn;
import org.jboss.tools.hibernate.spi.IPersistentClass;
import org.jboss.tools.hibernate.spi.IProperty;
import org.jboss.tools.hibernate.spi.ITable;
import org.jboss.tools.hibernate.spi.IType;
import org.jboss.tools.hibernate.spi.IValue;
import org.jboss.tools.hibernate.spi.IValueVisitor;

public class ValueProxy
implements IValue {
    private Value target = null;
    private IValue collectionElement = null;
    private ITable collectionTable = null;
    private ITable table = null;
    private IValue key = null;
    private IValue index = null;
    private IType type = null;
    private HashSet<IColumn> columns = null;
    private IPersistentClass owner = null;
    private HashSet<IProperty> properties = null;

    public ValueProxy(Value value) {
        this.target = value;
    }

    public boolean isSimpleValue() {
        return this.target.isSimpleValue();
    }

    public boolean isCollection() {
        return this.target instanceof Collection;
    }

    public Value getTarget() {
        return this.target;
    }

    public IValue getCollectionElement() {
        Value element;
        if (this.isCollection() && this.collectionElement == null && (element = ((Collection)this.target).getElement()) != null) {
            this.collectionElement = new ValueProxy(element);
        }
        return this.collectionElement;
    }

    public boolean isOneToMany() {
        return this.target instanceof OneToMany;
    }

    public boolean isManyToOne() {
        return this.target instanceof ManyToOne;
    }

    public boolean isOneToOne() {
        return this.target instanceof OneToOne;
    }

    public boolean isMap() {
        return this.target instanceof Map;
    }

    public boolean isComponent() {
        return this.target instanceof Component;
    }

    public Boolean isEmbedded() {
        Boolean result = null;
        if (this.isComponent()) {
            result = ((Component)this.target).isEmbedded();
        } else if (this.isToOne()) {
            result = ((ToOne)this.target).isEmbedded();
        }
        return result;
    }

    public boolean isToOne() {
        return this.target instanceof ToOne;
    }

    public Object accept(IValueVisitor valueVisitor) {
        return valueVisitor.accept((IValue)this);
    }

    public ITable getTable() {
        if (this.target.getTable() != null && this.table == null) {
            this.table = new TableProxy(this.target.getTable());
        }
        return this.table;
    }

    public IType getType() {
        if (this.target.getType() != null && this.type == null) {
            this.type = new TypeProxy(this.target.getType());
        }
        return this.type;
    }

    public void setElement(IValue element) {
        assert (element instanceof ValueProxy);
        if (this.isCollection()) {
            ((Collection)this.target).setElement(((ValueProxy)element).getTarget());
        }
    }

    public void setCollectionTable(ITable table) {
        assert (table instanceof TableProxy);
        if (this.isCollection()) {
            this.collectionTable = table;
            ((Collection)this.target).setCollectionTable(((TableProxy)table).getTarget());
        }
    }

    public void setTable(ITable table) {
        assert (table instanceof TableProxy);
        if (this.isSimpleValue()) {
            ((SimpleValue)this.target).setTable(((TableProxy)table).getTarget());
        }
    }

    public boolean isList() {
        return this.target instanceof List;
    }

    public void setIndex(IValue value) {
        assert (value instanceof ValueProxy);
        ((IndexedCollection)this.target).setIndex(((ValueProxy)value).getTarget());
    }

    public void setTypeName(String name) {
        if (this.isSimpleValue()) {
            ((SimpleValue)this.target).setTypeName(name);
        }
    }

    public String getComponentClassName() {
        return this.isComponent() ? ((Component)this.target).getComponentClassName() : null;
    }

    public Iterator<IColumn> getColumnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    private void initializeColumns() {
        this.columns = new HashSet();
        Iterator iterator = this.target.getColumnIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Column)) continue;
            this.columns.add(new ColumnProxy((Column)object));
        }
    }

    public Boolean isTypeSpecified() {
        return this.isSimpleValue() ? Boolean.valueOf(((SimpleValue)this.target).isTypeSpecified()) : null;
    }

    public String toString() {
        return this.target.toString();
    }

    public ITable getCollectionTable() {
        Table ct;
        if (this.isCollection() && this.collectionTable == null && (ct = ((Collection)this.target).getCollectionTable()) != null) {
            this.collectionTable = new TableProxy(ct);
        }
        return this.collectionTable;
    }

    public IValue getKey() {
        Collection collection;
        if (this.key == null && this.isCollection() && (collection = (Collection)this.target).getKey() != null) {
            this.key = new ValueProxy((Value)collection.getKey());
        }
        return this.key;
    }

    public boolean isDependantValue() {
        return this.target instanceof DependantValue;
    }

    public boolean isAny() {
        return this.target instanceof Any;
    }

    public boolean isSet() {
        return this.target instanceof Set;
    }

    public IValue getIndex() {
        List list;
        if (this.index == null && this.isList() && (list = (List)this.target).getIndex() != null) {
            this.index = new ValueProxy(list.getIndex());
        }
        return this.index;
    }

    public boolean isArray() {
        return this.target instanceof Array;
    }

    public String getElementClassName() {
        String result = null;
        if (this.isArray()) {
            result = ((Array)this.target).getElementClassName();
        }
        return result;
    }

    public boolean isPrimitiveArray() {
        return this.target instanceof PrimitiveArray;
    }

    public String getTypeName() {
        String result = null;
        if (this.isSimpleValue()) {
            result = ((SimpleValue)this.target).getTypeName();
        }
        return result;
    }

    public boolean isIdentifierBag() {
        return this.target instanceof IdentifierBag;
    }

    public boolean isBag() {
        return this.target instanceof Bag;
    }

    public String getReferencedEntityName() {
        String result = null;
        if (this.target instanceof OneToMany) {
            result = ((OneToMany)this.target).getReferencedEntityName();
        } else if (this.target instanceof ToOne) {
            result = ((ToOne)this.target).getReferencedEntityName();
        }
        return result;
    }

    public String getEntityName() {
        String result = null;
        if (this.target instanceof OneToOne) {
            result = ((OneToOne)this.target).getEntityName();
        }
        return result;
    }

    public Iterator<IProperty> getPropertyIterator() {
        if (this.properties == null) {
            this.initializeProperties();
        }
        return this.properties.iterator();
    }

    private void initializeProperties() {
        this.properties = new HashSet();
        Iterator origin = ((Component)this.target).getPropertyIterator();
        while (origin.hasNext()) {
            this.properties.add(new PropertyProxy((Property)origin.next()));
        }
    }

    public void addColumn(IColumn column) {
        assert (column instanceof ColumnProxy);
        assert (this.target instanceof SimpleValue);
        ((SimpleValue)this.target).addColumn(((ColumnProxy)column).getTarget());
    }

    public void setTypeParameters(Properties typeParameters) {
        assert (this.target instanceof SimpleValue);
        ((SimpleValue)this.target).setTypeParameters(typeParameters);
    }

    public String getForeignKeyName() {
        assert (this.target instanceof SimpleValue);
        return ((SimpleValue)this.target).getForeignKeyName();
    }

    public IPersistentClass getOwner() {
        assert (this.target instanceof Component);
        if (this.owner == null && ((Component)this.target).getOwner() != null) {
            this.owner = new PersistentClassProxy(((Component)this.target).getOwner());
        }
        return this.owner;
    }

    public IValue getElement() {
        assert (this.target instanceof Collection);
        ValueProxy result = null;
        if (((Collection)this.target).getElement() != null) {
            result = new ValueProxy(((Collection)this.target).getElement());
        }
        return result;
    }

    public String getParentProperty() {
        return ((Component)this.target).getParentProperty();
    }

    public void setElementClassName(String name) {
        assert (this.target instanceof Array);
        ((Array)this.target).setElementClassName(name);
    }

    public void setKey(IValue keyValue) {
        assert (keyValue instanceof ValueProxy);
        assert (this.target instanceof Collection);
        assert (((ValueProxy)keyValue).getTarget() instanceof KeyValue);
        ((Collection)this.target).setKey((KeyValue)((ValueProxy)keyValue).getTarget());
    }

    public void setFetchModeJoin() {
        assert (this.target instanceof Collection || this.target instanceof ToOne);
        if (this.target instanceof Collection) {
            ((Collection)this.target).setFetchMode(FetchMode.JOIN);
        } else if (this.target instanceof ToOne) {
            ((ToOne)this.target).setFetchMode(FetchMode.JOIN);
        }
    }

    public boolean isInverse() {
        assert (this.target instanceof Collection);
        return ((Collection)this.target).isInverse();
    }

    public IPersistentClass getAssociatedClass() {
        assert (this.target instanceof OneToMany);
        return ((OneToMany)this.target).getAssociatedClass() != null ? new PersistentClassProxy(((OneToMany)this.target).getAssociatedClass()) : null;
    }

    public void setLazy(boolean b) {
        assert (this.target instanceof Collection);
        ((Collection)this.target).setLazy(b);
    }

    public void setRole(String role) {
        assert (this.target instanceof Collection);
        ((Collection)this.target).setRole(role);
    }

    public void setReferencedEntityName(String name) {
        assert (this.target instanceof ToOne || this.target instanceof ManyToOne);
        if (this.isToOne()) {
            ((ToOne)this.target).setReferencedEntityName(name);
        } else if (this.isOneToMany()) {
            ((OneToMany)this.target).setReferencedEntityName(name);
        }
    }

    public void setAssociatedClass(IPersistentClass persistentClass) {
        assert (this.target instanceof OneToMany);
        assert (persistentClass instanceof PersistentClassProxy);
        ((OneToMany)this.target).setAssociatedClass(((PersistentClassProxy)persistentClass).getTarget());
    }
}

