/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.connection.DriverManagerConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.HibernateMappingGlobalSettings;
import org.hibernate.tool.ide.completion.HQLCodeAssist;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.jboss.tools.hibernate.proxy.ArtifactCollectorProxy;
import org.jboss.tools.hibernate.proxy.Cfg2HbmToolProxy;
import org.jboss.tools.hibernate.proxy.ColumnProxy;
import org.jboss.tools.hibernate.proxy.ConfigurationProxy;
import org.jboss.tools.hibernate.proxy.DatabaseCollectorProxy;
import org.jboss.tools.hibernate.proxy.DialectProxy;
import org.jboss.tools.hibernate.proxy.EnvironmentProxy;
import org.jboss.tools.hibernate.proxy.ExporterProxy;
import org.jboss.tools.hibernate.proxy.HQLCodeAssistProxy;
import org.jboss.tools.hibernate.proxy.HQLQueryPlanProxy;
import org.jboss.tools.hibernate.proxy.HibernateMappingExporterProxy;
import org.jboss.tools.hibernate.proxy.HibernateMappingGlobalSettingsProxy;
import org.jboss.tools.hibernate.proxy.JDBCReaderProxy;
import org.jboss.tools.hibernate.proxy.MetaDataDialectProxy;
import org.jboss.tools.hibernate.proxy.NamingStrategyProxy;
import org.jboss.tools.hibernate.proxy.OverrideRepositoryProxy;
import org.jboss.tools.hibernate.proxy.PersistentClassProxy;
import org.jboss.tools.hibernate.proxy.PrimaryKeyProxy;
import org.jboss.tools.hibernate.proxy.PropertyProxy;
import org.jboss.tools.hibernate.proxy.ReverseEngineeringSettingsProxy;
import org.jboss.tools.hibernate.proxy.ReverseEngineeringStrategyProxy;
import org.jboss.tools.hibernate.proxy.SchemaExportProxy;
import org.jboss.tools.hibernate.proxy.SettingsProxy;
import org.jboss.tools.hibernate.proxy.SpecialRootClassProxy;
import org.jboss.tools.hibernate.proxy.TableFilterProxy;
import org.jboss.tools.hibernate.proxy.TableIdentifierProxy;
import org.jboss.tools.hibernate.proxy.TableProxy;
import org.jboss.tools.hibernate.proxy.TypeFactoryProxy;
import org.jboss.tools.hibernate.proxy.ValueProxy;
import org.jboss.tools.hibernate.spi.HibernateException;
import org.jboss.tools.hibernate.spi.IArtifactCollector;
import org.jboss.tools.hibernate.spi.ICfg2HbmTool;
import org.jboss.tools.hibernate.spi.IColumn;
import org.jboss.tools.hibernate.spi.IConfiguration;
import org.jboss.tools.hibernate.spi.IDatabaseCollector;
import org.jboss.tools.hibernate.spi.IDialect;
import org.jboss.tools.hibernate.spi.IEnvironment;
import org.jboss.tools.hibernate.spi.IExporter;
import org.jboss.tools.hibernate.spi.IHQLCodeAssist;
import org.jboss.tools.hibernate.spi.IHQLQueryPlan;
import org.jboss.tools.hibernate.spi.IHibernateMappingExporter;
import org.jboss.tools.hibernate.spi.IHibernateMappingGlobalSettings;
import org.jboss.tools.hibernate.spi.IJDBCReader;
import org.jboss.tools.hibernate.spi.IMetaDataDialect;
import org.jboss.tools.hibernate.spi.INamingStrategy;
import org.jboss.tools.hibernate.spi.IOverrideRepository;
import org.jboss.tools.hibernate.spi.IPersistentClass;
import org.jboss.tools.hibernate.spi.IPrimaryKey;
import org.jboss.tools.hibernate.spi.IProperty;
import org.jboss.tools.hibernate.spi.IReverseEngineeringSettings;
import org.jboss.tools.hibernate.spi.IReverseEngineeringStrategy;
import org.jboss.tools.hibernate.spi.ISchemaExport;
import org.jboss.tools.hibernate.spi.IService;
import org.jboss.tools.hibernate.spi.ISessionFactory;
import org.jboss.tools.hibernate.spi.ISettings;
import org.jboss.tools.hibernate.spi.ITable;
import org.jboss.tools.hibernate.spi.ITableFilter;
import org.jboss.tools.hibernate.spi.ITableIdentifier;
import org.jboss.tools.hibernate.spi.ITypeFactory;
import org.jboss.tools.hibernate.spi.IValue;
import org.jboss.tools.hibernate.util.OpenMappingUtilsEjb3;
import org.xml.sax.EntityResolver;

public class ServiceProxy
implements IService {
    public IConfiguration newAnnotationConfiguration() {
        AnnotationConfiguration configuration = new AnnotationConfiguration();
        return new ConfigurationProxy((Configuration)configuration);
    }

    public IConfiguration newJpaConfiguration(String entityResolver, String persistenceUnit, java.util.Map<Object, Object> overrides) {
        Ejb3Configuration ejb3Configuration = new Ejb3Configuration();
        if (StringHelper.isNotEmpty((String)entityResolver)) {
            try {
                Class resolver = ReflectHelper.classForName((String)entityResolver, this.getClass());
                Object object = resolver.newInstance();
                ejb3Configuration.setEntityResolver((EntityResolver)object);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new HibernateException((Throwable)e);
            }
        }
        ejb3Configuration.configure(persistenceUnit, overrides);
        AnnotationConfiguration configuration = ejb3Configuration.getHibernateConfiguration();
        return new ConfigurationProxy((Configuration)configuration);
    }

    public IConfiguration newDefaultConfiguration() {
        return new ConfigurationProxy(new Configuration());
    }

    public void setExporterConfiguration(IExporter exporter, IConfiguration hcfg) {
        exporter.setConfiguration(hcfg);
    }

    public IHibernateMappingExporter newHibernateMappingExporter(IConfiguration hcfg, File file) {
        return new HibernateMappingExporterProxy(hcfg, file);
    }

    public ISchemaExport newSchemaExport(IConfiguration hcfg) {
        SchemaExportProxy result = null;
        if (hcfg instanceof ConfigurationProxy) {
            SchemaExport schemaExport = new SchemaExport(((ConfigurationProxy)hcfg).getConfiguration());
            result = new SchemaExportProxy(schemaExport);
        }
        return result;
    }

    public IHQLCodeAssist newHQLCodeAssist(IConfiguration hcfg) {
        HQLCodeAssistProxy result = null;
        if (hcfg instanceof ConfigurationProxy) {
            result = new HQLCodeAssistProxy(new HQLCodeAssist(((ConfigurationProxy)hcfg).getConfiguration()));
        }
        return result;
    }

    public IConfiguration newJDBCMetaDataConfiguration() {
        JDBCMetaDataConfiguration configuration = new JDBCMetaDataConfiguration();
        return new ConfigurationProxy((Configuration)configuration);
    }

    public IExporter createExporter(String exporterClassName) {
        return new ExporterProxy(exporterClassName);
    }

    public IArtifactCollector newArtifactCollector() {
        return new ArtifactCollectorProxy();
    }

    public IHQLQueryPlan newHQLQueryPlan(String query, boolean shallow, ISessionFactory sessionFactory) {
        return new HQLQueryPlanProxy(query, shallow, sessionFactory);
    }

    public ITypeFactory newTypeFactory() {
        return new TypeFactoryProxy();
    }

    public INamingStrategy newNamingStrategy(String strategyClassName) {
        try {
            NamingStrategy ns = (NamingStrategy)ReflectHelper.classForName((String)strategyClassName).newInstance();
            return new NamingStrategyProxy(ns);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            return null;
        }
    }

    public IOverrideRepository newOverrideRepository() {
        return new OverrideRepositoryProxy(new OverrideRepository());
    }

    public ITableFilter newTableFilter() {
        return new TableFilterProxy(new TableFilter());
    }

    public IReverseEngineeringSettings newReverseEngineeringSettings(IReverseEngineeringStrategy res) {
        assert (res instanceof ReverseEngineeringStrategyProxy);
        return new ReverseEngineeringSettingsProxy(new ReverseEngineeringSettings(((ReverseEngineeringStrategyProxy)res).getTarget()));
    }

    public IReverseEngineeringStrategy newDefaultReverseEngineeringStrategy() {
        return new ReverseEngineeringStrategyProxy((ReverseEngineeringStrategy)new DefaultReverseEngineeringStrategy());
    }

    public IJDBCReader newJDBCReader(IConfiguration configuration, ISettings settings, IReverseEngineeringStrategy strategy) {
        assert (strategy instanceof ReverseEngineeringStrategyProxy);
        assert (settings instanceof SettingsProxy);
        JDBCReader target = JDBCReaderFactory.newJDBCReader((Properties)configuration.getProperties(), (Settings)((SettingsProxy)settings).getTarget(), (ReverseEngineeringStrategy)((ReverseEngineeringStrategyProxy)strategy).getTarget());
        return new JDBCReaderProxy(target);
    }

    public IReverseEngineeringStrategy newReverseEngineeringStrategy(String strategyName, IReverseEngineeringStrategy delegate) {
        assert (delegate instanceof ReverseEngineeringStrategyProxy);
        ReverseEngineeringStrategy target = this.newReverseEngineeringStrategy(strategyName, ((ReverseEngineeringStrategyProxy)delegate).getTarget());
        return new ReverseEngineeringStrategyProxy(target);
    }

    private ReverseEngineeringStrategy newReverseEngineeringStrategy(String className, ReverseEngineeringStrategy delegate) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Constructor constructor = clazz.getConstructor(ReverseEngineeringStrategy.class);
            return (ReverseEngineeringStrategy)constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Class clazz = ReflectHelper.classForName((String)className);
                ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                return rev;
            }
            catch (Exception eq) {
                throw new HibernateException((Throwable)eq);
            }
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    public String getReverseEngineeringStrategyClassName() {
        return ReverseEngineeringStrategy.class.getName();
    }

    public IDatabaseCollector newDatabaseCollector(IMetaDataDialect metaDataDialect) {
        assert (metaDataDialect instanceof MetaDataDialectProxy);
        return new DatabaseCollectorProxy(new DefaultDatabaseCollector(((MetaDataDialectProxy)metaDataDialect).getTarget()));
    }

    public ICfg2HbmTool newCfg2HbmTool() {
        return new Cfg2HbmToolProxy(new Cfg2HbmTool());
    }

    public IProperty newProperty() {
        return new PropertyProxy(new Property());
    }

    public ITable newTable(String name) {
        return new TableProxy(new Table(name));
    }

    public IColumn newColumn(String string) {
        return new ColumnProxy(new Column(string));
    }

    public IDialect newDialect(Properties properties, Connection connection) {
        Dialect dialect = null;
        dialect = connection == null ? DialectFactory.buildDialect((Properties)properties) : DialectFactory.buildDialect((Properties)properties, (Connection)connection);
        return dialect != null ? new DialectProxy(dialect) : null;
    }

    public Class<?> getDriverManagerConnectionProviderClass() {
        return DriverManagerConnectionProvider.class;
    }

    public IEnvironment getEnvironment() {
        return new EnvironmentProxy();
    }

    public IValue newSimpleValue() {
        return new ValueProxy((Value)new SimpleValue());
    }

    public IValue newPrimitiveArray(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new PrimitiveArray(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IValue newArray(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new Array(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IValue newBag(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new Bag(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IValue newList(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new List(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IValue newMap(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new Map(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IValue newSet(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new Set(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IValue newManyToOne(ITable table) {
        assert (table instanceof TableProxy);
        return new ValueProxy((Value)new ManyToOne(((TableProxy)table).getTarget()));
    }

    public IValue newOneToMany(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new OneToMany(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IValue newOneToOne(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new ValueProxy((Value)new OneToOne(((PersistentClassProxy)persistentClass).getTarget().getTable(), ((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IPersistentClass newSingleTableSubclass(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new PersistentClassProxy((PersistentClass)new SingleTableSubclass(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IPersistentClass newJoinedSubclass(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        return new PersistentClassProxy((PersistentClass)new JoinedSubclass(((PersistentClassProxy)persistentClass).getTarget()));
    }

    public IPersistentClass newSpecialRootClass(IProperty ormElement) {
        return new SpecialRootClassProxy(ormElement);
    }

    public IPersistentClass newRootClass() {
        return new PersistentClassProxy((PersistentClass)new RootClass());
    }

    public IPrimaryKey newPrimaryKey() {
        return new PrimaryKeyProxy(new PrimaryKey());
    }

    public IHibernateMappingGlobalSettings newHibernateMappingGlobalSettings() {
        return new HibernateMappingGlobalSettingsProxy(new HibernateMappingGlobalSettings());
    }

    public ITableIdentifier createTableIdentifier(ITable table) {
        assert (table instanceof TableProxy);
        return new TableIdentifierProxy(TableIdentifier.create((Table)((TableProxy)table).getTarget()));
    }

    public ITableIdentifier newTableIdentifier(String catalog, String schema, String name) {
        return new TableIdentifierProxy(new TableIdentifier(catalog, schema, name));
    }

    public boolean isInitialized(Object object) {
        return Hibernate.isInitialized((Object)object);
    }

    public java.util.List<String> getJPAMappingFilePaths(String persistenceUnitName, EntityResolver entityResolver) {
        return OpenMappingUtilsEjb3.enumDocuments(persistenceUnitName, entityResolver);
    }

    public Class<?> getClassWithoutInitializingProxy(Object reflectedObject) {
        return HibernateProxyHelper.getClassWithoutInitializingProxy((Object)reflectedObject);
    }

    public ClassLoader getClassLoader() {
        return ServiceProxy.class.getClassLoader();
    }
}

