/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.proxy.TypeProxy;
import org.jboss.tools.hibernate.spi.IQuery;
import org.jboss.tools.hibernate.spi.IType;

public class QueryProxy
implements IQuery {
    private Query target = null;
    private IType[] returnTypes = null;

    public QueryProxy(Query query) {
        this.target = query;
    }

    public List<Object> list() {
        return this.target.list();
    }

    public void setMaxResults(int value) {
        this.target.setMaxResults(value);
    }

    public void setParameter(int pos, Object value, IType type) {
        if (type instanceof TypeProxy) {
            this.target.setParameter(pos, value, ((TypeProxy)type).getTarget());
        }
    }

    public void setParameterList(String name, List<Object> list, IType type) {
        if (type instanceof TypeProxy) {
            this.target.setParameterList(name, list, ((TypeProxy)type).getTarget());
        }
    }

    public void setParameter(String name, Object value, IType type) {
        if (type instanceof TypeProxy) {
            this.target.setParameter(name, value, ((TypeProxy)type).getTarget());
        }
    }

    public String[] getReturnAliases() {
        return this.target.getReturnAliases();
    }

    public IType[] getReturnTypes() {
        if (this.returnTypes == null) {
            this.initializeReturnTypes();
        }
        return this.returnTypes;
    }

    private void initializeReturnTypes() {
        Type[] origin = this.target.getReturnTypes();
        ArrayList<TypeProxy> destination = new ArrayList<TypeProxy>(origin.length);
        Type[] typeArray = origin;
        int n = origin.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            destination.add(new TypeProxy(type));
            ++n2;
        }
        this.returnTypes = destination.toArray(new IType[destination.size()]);
    }
}

