/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import org.hibernate.mapping.Property;
import org.jboss.tools.hibernate.proxy.PersistentClassProxy;
import org.jboss.tools.hibernate.proxy.TypeProxy;
import org.jboss.tools.hibernate.proxy.ValueProxy;
import org.jboss.tools.hibernate.spi.IPersistentClass;
import org.jboss.tools.hibernate.spi.IProperty;
import org.jboss.tools.hibernate.spi.IType;
import org.jboss.tools.hibernate.spi.IValue;

public class PropertyProxy
implements IProperty {
    private Property target = null;
    private IValue value = null;
    private IType type = null;
    private IPersistentClass persistentClass = null;

    public PropertyProxy(Property property) {
        this.target = property;
    }

    Property getTarget() {
        return this.target;
    }

    public IValue getValue() {
        if (this.value == null && this.target.getValue() != null) {
            this.value = new ValueProxy(this.target.getValue());
        }
        return this.value;
    }

    public void setName(String name) {
        this.target.setName(name);
    }

    public void setPersistentClass(IPersistentClass persistentClass) {
        assert (persistentClass instanceof PersistentClassProxy);
        this.target.setPersistentClass(((PersistentClassProxy)persistentClass).getTarget());
    }

    public IPersistentClass getPersistentClass() {
        if (this.persistentClass == null && this.target.getPersistentClass() != null) {
            this.persistentClass = new PersistentClassProxy(this.target.getPersistentClass());
        }
        return this.persistentClass;
    }

    public boolean isComposite() {
        return this.target.isComposite();
    }

    public String getPropertyAccessorName() {
        return this.target.getPropertyAccessorName();
    }

    public String getName() {
        return this.target.getName();
    }

    public boolean classIsPropertyClass() {
        return this.target.getClass() == Property.class;
    }

    public String getNodeName() {
        return this.target.getNodeName();
    }

    public IType getType() {
        if (this.type == null && this.target.getType() != null) {
            this.type = new TypeProxy(this.target.getType());
        }
        return this.type;
    }

    public void setValue(IValue value) {
        assert (value instanceof ValueProxy);
        this.target.setValue(((ValueProxy)value).getTarget());
        this.value = value;
    }

    public void setPropertyAccessorName(String string) {
        this.target.setPropertyAccessorName(string);
    }

    public void setCascade(String string) {
        this.target.setCascade(string);
    }

    public boolean isBackRef() {
        return this.target.isBackRef();
    }

    public boolean isSelectable() {
        return this.target.isSelectable();
    }

    public boolean isInsertable() {
        return this.target.isInsertable();
    }

    public boolean isUpdateable() {
        return this.target.isUpdateable();
    }

    public String getCascade() {
        return this.target.getCascade();
    }

    public boolean isLazy() {
        return this.target.isLazy();
    }

    public boolean isOptional() {
        return this.target.isOptional();
    }

    public boolean isNaturalIdentifier() {
        return this.target.isNaturalIdentifier();
    }

    public boolean isOptimisticLocked() {
        return this.target.isOptimisticLocked();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PropertyProxy)) {
            return false;
        }
        return this.getTarget().equals(((PropertyProxy)o).getTarget());
    }
}

