/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.jdt.ui.internal.jpa.collect.AllEntitiesInfoCollector;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.wizards.ProcessEntityInfo;
import org.hibernate.eclipse.nature.HibernateNature;
import org.hibernate.util.xpl.StringHelper;
import org.jboss.tools.hibernate.spi.IConfiguration;
import org.jboss.tools.hibernate.spi.IMappings;
import org.jboss.tools.hibernate.spi.IPersistentClass;
import org.jboss.tools.hibernate.spi.IProperty;
import org.jboss.tools.hibernate.spi.IService;
import org.jboss.tools.hibernate.spi.IValue;
import org.jboss.tools.hibernate.spi.ServiceLookup;

public class ConfigurationActor {
    protected Set<ICompilationUnit> selectionCU;

    public ConfigurationActor(Set<ICompilationUnit> selectionCU) {
        this.selectionCU = selectionCU;
    }

    public Map<IJavaProject, IConfiguration> createConfigurations(int processDepth) {
        HashMap<IJavaProject, IConfiguration> configs = new HashMap<IJavaProject, IConfiguration>();
        if (this.selectionCU.size() == 0) {
            return configs;
        }
        AllEntitiesInfoCollector collector = new AllEntitiesInfoCollector();
        Iterator<ICompilationUnit> it = this.selectionCU.iterator();
        HashMap<IJavaProject, HashSet<ICompilationUnit>> mapJP_CUSet = new HashMap<IJavaProject, HashSet<ICompilationUnit>>();
        while (it.hasNext()) {
            ICompilationUnit cu = it.next();
            HashSet<ICompilationUnit> set = (HashSet<ICompilationUnit>)mapJP_CUSet.get(cu.getJavaProject());
            if (set == null) {
                set = new HashSet<ICompilationUnit>();
                mapJP_CUSet.put(cu.getJavaProject(), set);
            }
            set.add(cu);
        }
        for (Map.Entry entry : mapJP_CUSet.entrySet()) {
            IJavaProject javaProject = (IJavaProject)entry.getKey();
            Iterator setIt = ((Set)entry.getValue()).iterator();
            collector.initCollector();
            while (setIt.hasNext()) {
                ICompilationUnit icu = (ICompilationUnit)setIt.next();
                collector.collect(icu, processDepth);
            }
            collector.resolveRelations();
            configs.put(javaProject, this.createConfiguration(javaProject, collector.getMapCUs_Info()));
        }
        return configs;
    }

    private IService getService(IJavaProject project) {
        HibernateNature hibnat = HibernateNature.getHibernateNature((IJavaProject)project);
        if (hibnat != null) {
            ConsoleConfiguration cc = hibnat.getDefaultConsoleConfiguration();
            return cc.getHibernateExtension().getHibernateService();
        }
        return ServiceLookup.findService((String)"3.5");
    }

    protected IConfiguration createConfiguration(IJavaProject project, Map<String, EntityInfo> entities) {
        IService service = this.getService(project);
        IConfiguration config = service.newDefaultConfiguration();
        ProcessEntityInfo processor = new ProcessEntityInfo(service);
        processor.setEntities(entities);
        for (Map.Entry<String, EntityInfo> entry : entities.entrySet()) {
            String fullyQualifiedName = entry.getValue().getFullyQualifiedName();
            ICompilationUnit icu = Utils.findCompilationUnit(project, fullyQualifiedName);
            if (icu == null) continue;
            CompilationUnit cu = Utils.getCompilationUnit(icu, true);
            processor.setEntityInfo(entry.getValue());
            cu.accept((ASTVisitor)processor);
        }
        IMappings mappings = config.createMappings();
        Collection<IPersistentClass> classesCollection = this.createHierarhyStructure(project, processor.getRootClasses());
        for (IPersistentClass persistentClass : classesCollection) {
            mappings.addClass(persistentClass);
        }
        return config;
    }

    private Collection<IPersistentClass> createHierarhyStructure(IJavaProject project, Map<String, IPersistentClass> rootClasses) {
        IService service = this.getService(project);
        HashMap<String, IPersistentClass> pcCopy = new HashMap<String, IPersistentClass>();
        for (Map.Entry<String, IPersistentClass> entry : rootClasses.entrySet()) {
            pcCopy.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : pcCopy.entrySet()) {
            IPersistentClass pc = null;
            try {
                pc = this.getMappedSuperclass(project, pcCopy, (IPersistentClass)entry.getValue());
                IPersistentClass subclass = null;
                if (pc != null) {
                    if (pc.isAbstract().booleanValue()) {
                        subclass = service.newSingleTableSubclass(pc);
                        if (pc.isInstanceOfRootClass() && pc.getDiscriminator() == null) {
                            IValue discr = service.newSimpleValue();
                            discr.setTypeName("string");
                            discr.addColumn(service.newColumn("DISCR_COL"));
                            pc.setDiscriminator(discr);
                        }
                    } else {
                        subclass = service.newJoinedSubclass(pc);
                    }
                } else {
                    pc = this.getMappedImplementedInterface(project, pcCopy, (IPersistentClass)entry.getValue());
                    if (pc != null) {
                        subclass = service.newSingleTableSubclass(pc);
                    }
                }
                if (subclass == null) continue;
                IPersistentClass pastClass = (IPersistentClass)pcCopy.get(entry.getKey());
                subclass.setClassName(pastClass.getClassName());
                subclass.setEntityName(pastClass.getEntityName());
                subclass.setDiscriminatorValue(StringHelper.unqualify((String)pastClass.getClassName()));
                subclass.setAbstract(pastClass.isAbstract().booleanValue());
                if (subclass.isInstanceOfJoinedSubclass()) {
                    subclass.setTable(service.newTable(StringHelper.unqualify((String)pastClass.getClassName()).toUpperCase()));
                    subclass.setKey(pc.getIdentifierProperty().getValue());
                }
                if (pastClass.getIdentifierProperty() != null) {
                    subclass.addProperty(pastClass.getIdentifierProperty());
                }
                Iterator it = pastClass.getPropertyIterator();
                while (it.hasNext()) {
                    subclass.addProperty((IProperty)it.next());
                }
                entry.setValue(subclass);
            }
            catch (JavaModelException e) {
                HibernateConsolePlugin.getDefault().log((Throwable)e);
            }
        }
        return pcCopy.values();
    }

    private IPersistentClass getMappedSuperclass(IJavaProject project, Map<String, IPersistentClass> persistentClasses, IPersistentClass rootClass) throws JavaModelException {
        String[][] supertypes;
        IType type = Utils.findType(project, rootClass.getClassName());
        if (type.getSuperclassName() != null && (supertypes = type.resolveType(type.getSuperclassName())) != null) {
            String supertype = supertypes[0][0].length() > 0 ? String.valueOf(supertypes[0][0]) + '.' + supertypes[0][1] : supertypes[0][1];
            return persistentClasses.get(supertype);
        }
        return null;
    }

    private IPersistentClass getMappedImplementedInterface(IJavaProject project, Map<String, IPersistentClass> persistentClasses, IPersistentClass rootClass) throws JavaModelException {
        String[] interfaces;
        IType type = Utils.findType(project, rootClass.getClassName());
        String[] stringArray = interfaces = type.getSuperInterfaceNames();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] fullInterfaces;
            String interfaze = stringArray[n2];
            String[][] stringArray2 = fullInterfaces = type.resolveType(interfaze);
            int n3 = fullInterfaces.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] fullInterface = stringArray2[n4];
                String inrefaceName = String.valueOf(fullInterface[0]) + '.' + fullInterface[1];
                if (persistentClasses.get(inrefaceName) != null) {
                    return persistentClasses.get(inrefaceName);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

