/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.core.JavaProject;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.OwnerType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;

public class Utils {
    public static CompilationUnit getCompilationUnit(ICompilationUnit source, boolean bindings) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        parser.setResolveBindings(bindings);
        CompilationUnit result = (CompilationUnit)parser.createAST(null);
        return result;
    }

    public static ICompilationUnit findCompilationUnit(IJavaProject javaProject, String fullyQualifiedName) {
        IType lwType = Utils.findType(javaProject, fullyQualifiedName);
        if (lwType != null) {
            return lwType.getCompilationUnit();
        }
        return null;
    }

    public static IType findType(IJavaProject javaProject, String fullyQualifiedName) {
        IType lwType = null;
        if (javaProject != null && javaProject instanceof JavaProject) {
            try {
                lwType = javaProject.findType(fullyQualifiedName, null);
            }
            catch (JavaModelException javaModelException) {}
        }
        return lwType;
    }

    public static ICompilationUnit findCompilationUnit(String fullyQualifiedName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ICompilationUnit resCompilationUnit = null;
        int i = 0;
        while (i < projects.length) {
            IJavaProject javaProject;
            if (projects[i].exists() && (resCompilationUnit = Utils.findCompilationUnit(javaProject = JavaCore.create((IProject)projects[i]), fullyQualifiedName)) != null) break;
            ++i;
        }
        return resCompilationUnit;
    }

    public static IProject findProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        IProject res = null;
        int i = 0;
        while (i < projects.length && res == null) {
            if (projects[i].exists() && projects[i].getName().compareTo(projectName) == 0) {
                res = projects[i];
            }
            ++i;
        }
        return res;
    }

    public static IJavaProject findJavaProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        IJavaProject res = null;
        int i = 0;
        while (i < projects.length && res == null) {
            if (projects[i].exists() && projects[i].getName().compareTo(projectName) == 0) {
                IJavaProject javaProject;
                res = javaProject = JavaCore.create((IProject)projects[i]);
            }
            ++i;
        }
        return res;
    }

    public static ICompilationUnit[] findCompilationUnits(IJavaProject javaProject, IPath path) {
        IJavaElement javaElement = null;
        try {
            javaElement = javaProject.findElement(path.makeRelative());
        }
        catch (JavaModelException javaModelException) {}
        ICompilationUnit[] res = null;
        if (javaElement != null) {
            if (javaElement instanceof ICompilationUnit) {
                res = new ICompilationUnit[]{(ICompilationUnit)javaElement};
            } else if (javaElement instanceof IPackageFragment) {
                try {
                    res = ((IPackageFragment)javaElement).getCompilationUnits();
                }
                catch (JavaModelException javaModelException) {}
            } else {
                boolean cfr_ignored_0 = javaElement instanceof IClassFile;
            }
        }
        return res;
    }

    public static String refTypeToStr(RefType rt) {
        if (rt == RefType.ONE2ONE) {
            return "1-to-1";
        }
        if (rt == RefType.ONE2MANY) {
            return "1-to-n";
        }
        if (rt == RefType.MANY2ONE) {
            return "n-to-1";
        }
        if (rt == RefType.MANY2MANY) {
            return "n-to-n";
        }
        return "undef";
    }

    public static RefType strToRefType(String str) {
        if ("1-to-1".equals(str)) {
            return RefType.ONE2ONE;
        }
        if ("1-to-n".equals(str)) {
            return RefType.ONE2MANY;
        }
        if ("n-to-1".equals(str)) {
            return RefType.MANY2ONE;
        }
        if ("n-to-n".equals(str)) {
            return RefType.MANY2MANY;
        }
        return RefType.UNDEF;
    }

    public static String ownerTypeToStr(OwnerType ot) {
        if (ot == OwnerType.YES) {
            return "yes";
        }
        if (ot == OwnerType.NO) {
            return "no";
        }
        return "undef";
    }

    public static OwnerType strToOwnerType(String str) {
        if ("yes".equals(str = str.toLowerCase())) {
            return OwnerType.YES;
        }
        if ("no".equals(str)) {
            return OwnerType.NO;
        }
        return OwnerType.UNDEF;
    }

    public static boolean isImplementInterface(ITypeBinding[] interfaces, String parentInterface) {
        int i = 0;
        while (i < interfaces.length) {
            ITypeBinding typeBinding = interfaces[i];
            if (typeBinding != null) {
                if (parentInterface.equals(typeBinding.getBinaryName())) {
                    return true;
                }
                if (Utils.isImplementInterface(typeBinding.getInterfaces(), parentInterface)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static ITypeBinding[] getAllInterfaces(ITypeBinding tb) {
        ITypeBinding[] interfaces = tb.getInterfaces();
        if (tb.isInterface()) {
            ITypeBinding[] allInterfaces = new ITypeBinding[interfaces.length + 1];
            System.arraycopy(interfaces, 0, allInterfaces, 0, interfaces.length);
            allInterfaces[interfaces.length] = tb;
            interfaces = allInterfaces;
        }
        return interfaces;
    }

    public static String getFieldNameByGetter(MethodDeclaration node) {
        if (node.parameters().size() != 0) {
            return null;
        }
        String methodName = node.getName().getIdentifier();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            methodName = methodName.substring(3);
            return String.valueOf(Character.toLowerCase(methodName.charAt(0))) + methodName.substring(1);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            methodName = methodName.substring(2);
            return String.valueOf(Character.toLowerCase(methodName.charAt(0))) + methodName.substring(1);
        }
        return null;
    }
}

