/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.collect;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.SourceType;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.JPAConst;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;

public class CollectEntityInfo
extends ASTVisitor {
    protected EntityInfo entityInfo = new EntityInfo();
    protected String fullyQualifiedName = null;

    public CollectEntityInfo(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        this.entityInfo.setFullyQualifiedName(fullyQualifiedName);
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public boolean visit(CompilationUnit node) {
        if (node.getProblems().length > 0) {
            this.entityInfo.setCompilerProblemsFlag(true);
        }
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        return this.processAnnotation((Annotation)node, null);
    }

    public boolean visit(NormalAnnotation node) {
        String mappedBy = null;
        for (MemberValuePair mvp : node.values()) {
            if (!"mappedBy".equals(mvp.getName().toString())) continue;
            mappedBy = mvp.getValue().toString().replaceAll("\"", "");
            break;
        }
        return this.processAnnotation((Annotation)node, mappedBy);
    }

    public CompilationUnit getCUFromFieldMethod(ASTNode node) {
        CompilationUnit cu = null;
        ASTNode astNode = node.getParent();
        if ((astNode instanceof FieldDeclaration || astNode instanceof MethodDeclaration) && (astNode = astNode.getParent()) instanceof TypeDeclaration && (astNode = astNode.getParent()) instanceof CompilationUnit) {
            cu = (CompilationUnit)astNode;
        }
        return cu;
    }

    public CompilationUnit getCUFromTypeDeclaration(ASTNode node) {
        CompilationUnit cu = null;
        ASTNode astNode = node.getParent();
        if (astNode instanceof TypeDeclaration && (astNode = astNode.getParent()) instanceof CompilationUnit) {
            cu = (CompilationUnit)astNode;
        }
        return cu;
    }

    public boolean processAnnotation(Annotation node, String mappedBy) {
        String fullyQualifiedName = node.getTypeName().getFullyQualifiedName();
        if (JPAConst.isAnnotationEntity(fullyQualifiedName)) {
            ITypeBinding tb = node.resolveTypeBinding();
            CompilationUnit cu = this.getCUFromTypeDeclaration((ASTNode)node);
            if (cu != null) {
                if (tb == null) {
                    this.entityInfo.addRequiredImport("javax.persistence.Entity");
                }
                this.entityInfo.setAddEntityFlag(false);
            }
        } else if (JPAConst.isAnnotationId(fullyQualifiedName)) {
            ITypeBinding tb = node.resolveTypeBinding();
            CompilationUnit cu = this.getCUFromFieldMethod((ASTNode)node);
            if (cu != null) {
                if (tb == null) {
                    this.entityInfo.addRequiredImport("javax.persistence.Id");
                }
                this.entityInfo.setAddPrimaryIdFlag(false);
            }
        } else if (JPAConst.isAnnotationGeneratedValue(fullyQualifiedName)) {
            ITypeBinding tb = node.resolveTypeBinding();
            CompilationUnit cu = this.getCUFromFieldMethod((ASTNode)node);
            if (cu != null) {
                if (tb == null) {
                    this.entityInfo.addRequiredImport("javax.persistence.GeneratedValue");
                }
                this.entityInfo.setAddGeneratedValueFlag(false);
            }
        } else if (JPAConst.isAnnotationOne2One(fullyQualifiedName)) {
            this.updateAnnotationRelInfo(node, mappedBy, fullyQualifiedName, RefType.ONE2ONE, "OneToOne", "javax.persistence.OneToOne");
        } else if (JPAConst.isAnnotationOne2Many(fullyQualifiedName)) {
            this.updateAnnotationRelInfo(node, mappedBy, fullyQualifiedName, RefType.ONE2MANY, "OneToMany", "javax.persistence.OneToMany");
        } else if (JPAConst.isAnnotationMany2One(fullyQualifiedName)) {
            this.updateAnnotationRelInfo(node, mappedBy, fullyQualifiedName, RefType.MANY2ONE, "ManyToOne", "javax.persistence.ManyToOne");
        } else if (JPAConst.isAnnotationMany2Many(fullyQualifiedName)) {
            this.updateAnnotationRelInfo(node, mappedBy, fullyQualifiedName, RefType.MANY2MANY, "ManyToMany", "javax.persistence.ManyToMany");
        } else if (JPAConst.isAnnotationEnumerated(fullyQualifiedName)) {
            this.updateAnnotationRelInfo(node, mappedBy, fullyQualifiedName, RefType.ENUMERATED, "Enumerated", "javax.persistence.Enumerated");
        } else if (JPAConst.isAnnotationMappedSuperclass(fullyQualifiedName)) {
            ITypeBinding tb = node.resolveTypeBinding();
            CompilationUnit cu = this.getCUFromTypeDeclaration((ASTNode)node);
            if (cu != null) {
                if (tb == null) {
                    this.entityInfo.addRequiredImport("javax.persistence.MappedSuperclass");
                }
                this.entityInfo.setAddEntityFlag(false);
                this.entityInfo.setAddMappedSuperclassFlag(false);
                this.entityInfo.setHasMappedSuperclassAnnotation(true);
            }
        } else if (JPAConst.isAnnotationVersion(fullyQualifiedName)) {
            ITypeBinding tb = node.resolveTypeBinding();
            CompilationUnit cu = this.getCUFromFieldMethod((ASTNode)node);
            if (cu != null) {
                if (tb == null) {
                    this.entityInfo.addRequiredImport("javax.persistence.Version");
                }
                this.entityInfo.setHasVersionAnnotation(true);
            }
        } else if (JPAConst.isAnnotationColumn(fullyQualifiedName) && node instanceof NormalAnnotation) {
            this.updateAnnotationColumn((NormalAnnotation)node, mappedBy, fullyQualifiedName);
        }
        return true;
    }

    public void updateAnnotationColumn(NormalAnnotation node, String mappedBy, String fullyQualifiedName) {
        MethodDeclaration md;
        ITypeBinding tb = node.resolveTypeBinding();
        CompilationUnit cu = null;
        ASTNode astNode = node.getParent();
        if (astNode instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)astNode;
            for (VariableDeclarationFragment var : fd.fragments()) {
                String name = var.getName().getIdentifier();
                this.entityInfo.updateAnnotationColumn(name, node, true);
            }
            cu = this.getCUFromTypeDeclaration((ASTNode)node);
        } else if (astNode instanceof MethodDeclaration && (md = (MethodDeclaration)astNode).getName().getIdentifier().startsWith("get")) {
            String name = CollectEntityInfo.getReturnIdentifier(md);
            this.entityInfo.updateAnnotationColumn(name, node, true);
            cu = this.getCUFromFieldMethod((ASTNode)node);
        }
        if (cu != null && tb == null) {
            this.entityInfo.addRequiredImport("javax.persistence.Column");
        }
    }

    public void updateAnnotationRelInfo(Annotation node, String mappedBy, String fullyQualifiedName, RefType type, String annNameShort, String annNameFull) {
        MethodDeclaration md;
        ITypeBinding tb = node.resolveTypeBinding();
        CompilationUnit cu = null;
        ASTNode astNode = node.getParent();
        if (astNode instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)astNode;
            for (VariableDeclarationFragment var : fd.fragments()) {
                String name = var.getName().getIdentifier();
                this.entityInfo.updateReference(name, true, type, mappedBy, annNameShort.compareTo(fullyQualifiedName) != 0, true);
            }
            cu = this.getCUFromTypeDeclaration((ASTNode)node);
        } else if (astNode instanceof MethodDeclaration && (md = (MethodDeclaration)astNode).getName().getIdentifier().startsWith("get")) {
            String name = CollectEntityInfo.getReturnIdentifier(md);
            this.entityInfo.updateReference(name, true, type, mappedBy, annNameShort.compareTo(fullyQualifiedName) != 0, false);
            cu = this.getCUFromTypeDeclaration((ASTNode)node);
        }
        if (cu != null && tb == null) {
            this.entityInfo.addRequiredImport(annNameFull);
        }
    }

    public boolean visit(ImportDeclaration node) {
        String name = node.getName().getFullyQualifiedName();
        int i = 0;
        while (i < JPAConst.ALL_IMPORTS.size()) {
            String tmp = JPAConst.ALL_IMPORTS.get(i);
            if (tmp.compareTo(name) == 0) {
                this.entityInfo.addExistingImport(name);
                break;
            }
            ++i;
        }
        return true;
    }

    public boolean visit(Modifier node) {
        if (node.isAbstract()) {
            this.entityInfo.setAbstractFlag(true);
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding tb;
        String nodeName;
        ITypeBinding typeBinding = node.resolveBinding();
        String string = nodeName = typeBinding == null ? null : typeBinding.getBinaryName();
        if (this.fullyQualifiedName == null || !this.fullyQualifiedName.equalsIgnoreCase(nodeName)) {
            return false;
        }
        boolean isAbstruct = this.entityInfo.isAbstractFlag() || Modifier.isAbstract((int)node.getModifiers()) || node.isInterface();
        this.entityInfo.setAbstractFlag(isAbstruct);
        if (isAbstruct) {
            this.entityInfo.setAddEntityFlag(false);
            this.entityInfo.setAddMappedSuperclassFlag(true);
        }
        this.entityInfo.setInterfaceFlag(node.isInterface());
        Type superType = node.getSuperclassType();
        if (superType != null && (tb = superType.resolveBinding()) != null) {
            String entityFullyQualifiedName = "";
            if (tb.getJavaElement() instanceof SourceType) {
                SourceType sourceT = (SourceType)tb.getJavaElement();
                try {
                    entityFullyQualifiedName = sourceT.getFullyQualifiedParameterizedName();
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("JavaModelException: ", (Throwable)e);
                }
            }
            this.entityInfo.addDependency(entityFullyQualifiedName);
            this.entityInfo.setFullyQualifiedParentName(entityFullyQualifiedName);
        }
        List superInterfaces = node.superInterfaceTypes();
        for (Object obj : superInterfaces) {
            if (!(obj instanceof SimpleType)) continue;
            SimpleType st = (SimpleType)obj;
            String fullyQualifiedName = st.getName().getFullyQualifiedName();
            if ("java.io.Serializable".compareTo(fullyQualifiedName) == 0) {
                this.entityInfo.setAddSerializableInterfaceFlag(false);
                continue;
            }
            if ("Serializable".compareTo(fullyQualifiedName) != 0) continue;
            this.entityInfo.setAddSerializableInterfaceFlag(false);
            this.entityInfo.addRequiredImport("java.io.Serializable");
        }
        node.resolveBinding();
        return true;
    }

    public static String getReturnIdentifier(MethodDeclaration node) {
        String res = null;
        if (node.getBody() == null) {
            return res;
        }
        List bodyStatemants = node.getBody().statements();
        for (Object obj : bodyStatemants) {
            if (!(obj instanceof ReturnStatement)) continue;
            ReturnStatement ret_statement = (ReturnStatement)obj;
            if ((obj = ret_statement.getExpression()) instanceof SimpleName) {
                SimpleName sn = (SimpleName)obj;
                res = sn.getIdentifier();
                break;
            }
            if (!(obj instanceof FieldAccess)) break;
            FieldAccess fa = (FieldAccess)obj;
            SimpleName sn = fa.getName();
            res = sn.getIdentifier();
            break;
        }
        return res;
    }

    public boolean visit(MethodDeclaration node) {
        if (node.getName().getFullyQualifiedName().compareTo(this.entityInfo.getName()) == 0 || node.isConstructor()) {
            this.entityInfo.setImplicitConstructorFlag(false);
            if (node.parameters().size() == 0) {
                this.entityInfo.setDefaultConstructorFlag(true);
            }
            return true;
        }
        if (node.getName().getIdentifier().startsWith("set") && node.parameters().size() == 1) {
            return true;
        }
        if (!node.getName().getIdentifier().startsWith("get") && !node.getName().getIdentifier().startsWith("is") || node.parameters().size() > 0) {
            return true;
        }
        Type type = node.getReturnType2();
        String returnIdentifier = CollectEntityInfo.getReturnIdentifier(node);
        ArrayList<String> list = new ArrayList<String>();
        if (returnIdentifier != null) {
            list.add(returnIdentifier);
        } else if (this.entityInfo.isInterfaceFlag()) {
            String probablyFieldName = Utils.getFieldNameByGetter(node);
            list.add(probablyFieldName);
        }
        boolean res = this.processFieldOrGetter(type, list, false);
        return res;
    }

    public boolean visit(FieldDeclaration node) {
        if ((node.getModifiers() & 0x18) != 0) {
            return false;
        }
        Type type = node.getType();
        ArrayList<String> list = new ArrayList<String>();
        for (VariableDeclarationFragment var : node.fragments()) {
            String name = var.getName().getIdentifier();
            list.add(name);
        }
        boolean res = this.processFieldOrGetter(type, list, true);
        return res;
    }

    public EntityInfo.FieldGetterType updateFieldGetter(EntityInfo.FieldGetterType fieldGetter, boolean fieldFlag) {
        if (fieldGetter == EntityInfo.FieldGetterType.FIELD) {
            if (!fieldFlag) {
                fieldGetter = EntityInfo.FieldGetterType.FIELD_GETTER;
            }
        } else if (fieldGetter == EntityInfo.FieldGetterType.GETTER) {
            if (fieldFlag) {
                fieldGetter = EntityInfo.FieldGetterType.FIELD_GETTER;
            }
        } else if (fieldGetter == EntityInfo.FieldGetterType.UNDEF) {
            fieldGetter = fieldFlag ? EntityInfo.FieldGetterType.FIELD : EntityInfo.FieldGetterType.GETTER;
        }
        return fieldGetter;
    }

    public boolean processFieldOrGetter(Type type, List<String> list, boolean fieldFlag) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitiveType()) {
            PrimitiveType pt = (PrimitiveType)type;
            if (!pt.getPrimitiveTypeCode().equals(PrimitiveType.BOOLEAN)) {
                for (String name : list) {
                    if ("version".equalsIgnoreCase(name)) {
                        EntityInfo.FieldGetterType versionFieldGetter = this.updateFieldGetter(this.entityInfo.getVersionFieldGetter(), fieldFlag);
                        this.entityInfo.setVersionFieldGetter(versionFieldGetter);
                        continue;
                    }
                    this.entityInfo.addPrimaryIdCandidate(name);
                }
            }
        } else if (type.isSimpleType()) {
            SimpleType st = (SimpleType)type;
            ITypeBinding tb = st.resolveBinding();
            if (tb != null) {
                String entityFullyQualifiedName = "";
                if (tb.getJavaElement() instanceof SourceType) {
                    SourceType sourceT = (SourceType)tb.getJavaElement();
                    entityFullyQualifiedName = sourceT.getFullyQualifiedName();
                    this.entityInfo.addDependency(entityFullyQualifiedName);
                    RefType refType2Use = tb.isEnum() ? RefType.ENUMERATED : RefType.MANY2ONE;
                    for (String name : list) {
                        this.entityInfo.addReference(name, entityFullyQualifiedName, refType2Use);
                    }
                } else if (tb.getJavaElement() instanceof BinaryType) {
                    ITypeBinding tbParent = tb.getTypeDeclaration().getSuperclass();
                    if (tbParent != null) {
                        EntityInfo.FieldGetterType versionFieldGetter;
                        if ("java.lang.Number".equals(tbParent.getBinaryName())) {
                            for (String name : list) {
                                if ("version".equalsIgnoreCase(name)) {
                                    versionFieldGetter = this.updateFieldGetter(this.entityInfo.getVersionFieldGetter(), fieldFlag);
                                    this.entityInfo.setVersionFieldGetter(versionFieldGetter);
                                    continue;
                                }
                                this.entityInfo.addPrimaryIdCandidate(name);
                            }
                        } else if ("java.util.Date".equals(tbParent.getBinaryName())) {
                            for (String name : list) {
                                if (!"version".equalsIgnoreCase(name)) continue;
                                versionFieldGetter = this.updateFieldGetter(this.entityInfo.getVersionFieldGetter(), fieldFlag);
                                this.entityInfo.setVersionFieldGetter(versionFieldGetter);
                            }
                        }
                    }
                    if ("java.lang.String".equals(tb.getBinaryName())) {
                        for (String name : list) {
                            this.entityInfo.updateAnnotationColumn(name, null, false);
                            this.entityInfo.addPrimaryIdCandidate(name);
                        }
                    }
                }
            }
        } else if (type.isArrayType()) {
            ArrayType at;
            ArrayType componentType = at = (ArrayType)type;
            while (componentType.isArrayType()) {
                componentType = componentType.getComponentType();
            }
            ITypeBinding tb = componentType.resolveBinding();
            if (tb != null && tb.getJavaElement() instanceof SourceType) {
                String entityFullyQualifiedName = "";
                SourceType sourceT = (SourceType)tb.getJavaElement();
                try {
                    entityFullyQualifiedName = sourceT.getFullyQualifiedParameterizedName();
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("JavaModelException: ", (Throwable)e);
                }
                this.entityInfo.addDependency(entityFullyQualifiedName);
                for (String name : list) {
                    this.entityInfo.addReference(name, entityFullyQualifiedName, RefType.ONE2MANY);
                }
            }
        } else if (type.isParameterizedType()) {
            ParameterizedType pt = (ParameterizedType)type;
            Type typeP2 = pt.getType();
            ITypeBinding tb = typeP2.resolveBinding();
            if (tb != null) {
                ITypeBinding[] interfaces = Utils.getAllInterfaces(tb);
                String fullyQualifiedNameTypeName = "";
                if (Utils.isImplementInterface(interfaces, "java.util.Collection")) {
                    fullyQualifiedNameTypeName = "java.util.Collection";
                }
                if (Utils.isImplementInterface(interfaces, "java.util.Map")) {
                    fullyQualifiedNameTypeName = "java.util.Map";
                }
                if (fullyQualifiedNameTypeName.length() > 0) {
                    for (Type typeP2 : pt.typeArguments()) {
                        tb = typeP2.resolveBinding();
                        String entityFullyQualifiedName = "";
                        if (!(tb.getJavaElement() instanceof SourceType)) continue;
                        SourceType sourceT = (SourceType)tb.getJavaElement();
                        try {
                            entityFullyQualifiedName = sourceT.getFullyQualifiedParameterizedName();
                        }
                        catch (JavaModelException e) {
                            HibernateConsolePlugin.getDefault().logErrorMessage("JavaModelException: ", (Throwable)e);
                        }
                        this.entityInfo.addDependency(entityFullyQualifiedName);
                        for (String name : list) {
                            this.entityInfo.addReference(name, entityFullyQualifiedName, RefType.ONE2MANY);
                        }
                    }
                }
            }
        } else if (type.isQualifiedType()) {
            QualifiedType qt = (QualifiedType)type;
            qt.resolveBinding();
        } else if (type.isWildcardType()) {
            WildcardType wt = (WildcardType)type;
            wt.resolveBinding();
        }
        return true;
    }
}

