/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.openshift.express.internal.core.security.SecurePasswordStore;

public class OpenShiftPasswordStorageKey
implements SecurePasswordStore.IStorageKey {
    private static final char SEPARATOR = '/';
    private static final Pattern SCHEME_PATTERN = Pattern.compile(".+://(.*)");
    private static final String PREFERNCES_BASEKEY = "org.jboss.tools.openshift.express.ui";
    private String platform;
    private String userName;

    public OpenShiftPasswordStorageKey(String platform, String userName) {
        this.platform = this.stripScheme(platform);
        this.userName = userName;
    }

    @Override
    public String getKey() {
        return PREFERNCES_BASEKEY + '/' + this.platform + '/' + this.userName;
    }

    private String stripScheme(String value) {
        Matcher matcher = SCHEME_PATTERN.matcher(value);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return value;
    }

    @Override
    public boolean equals(SecurePasswordStore.IStorageKey key) {
        if (!key.getClass().isAssignableFrom(OpenShiftPasswordStorageKey.class)) {
            return false;
        }
        OpenShiftPasswordStorageKey openshiftKey = (OpenShiftPasswordStorageKey)key;
        return this.userName != null && openshiftKey.userName != null && this.userName.equals(openshiftKey.userName) && this.platform != null && openshiftKey.platform != null && this.platform.equals(openshiftKey.platform);
    }
}

