/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractPreferenceValue<TYPE> {
    private String pluginId;
    private String prefsKey;

    public AbstractPreferenceValue(String prefsKey, String pluginId) {
        this.pluginId = pluginId;
        this.prefsKey = prefsKey;
    }

    public abstract TYPE get();

    protected String doGet() {
        Preferences prefs = this.getPreferences(this.pluginId);
        return prefs.get(this.prefsKey, "");
    }

    public void clear() throws BackingStoreException {
        String prefsValue = this.doGet();
        if (prefsValue == null || prefsValue == null) {
            return;
        }
        this.getPreferences(this.pluginId).clear();
    }

    public void set(TYPE value) {
        this.doStore(String.valueOf(value));
    }

    protected void doStore(String value) {
        Preferences prefs = this.getPreferences(this.pluginId);
        String prefsValue = prefs.get(this.prefsKey, "");
        if (prefsValue == null || prefsValue.equals("") || !prefsValue.equals(value)) {
            prefs.put(this.prefsKey, value);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    protected Preferences getPreferences(String pluginId) {
        return InstanceScope.INSTANCE.getNode(pluginId);
    }
}

