/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IUser;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import org.eclipse.core.runtime.IAdapterFactory;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;

public class ConnectionAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IEmbeddedCartridge embeddedCartridge;
        IApplication application;
        if (adapterType != Connection.class) {
            return null;
        }
        Connection connection = null;
        if (adaptableObject instanceof Connection) {
            connection = (Connection)adaptableObject;
        } else if (adaptableObject instanceof IDomain) {
            IDomain domain = (IDomain)adaptableObject;
            connection = ConnectionsModelSingleton.getInstance().getConnectionByResource(domain.getUser());
        } else if (adaptableObject instanceof IUser) {
            IUser user = (IUser)adaptableObject;
            connection = ConnectionsModelSingleton.getInstance().getConnectionByResource(user);
        } else if (adaptableObject instanceof IApplication) {
            IApplication application2 = (IApplication)adaptableObject;
            connection = this.getConnection(application2);
        } else if (adaptableObject instanceof IEmbeddedCartridge && (application = (embeddedCartridge = (IEmbeddedCartridge)adaptableObject).getApplication()) != null) {
            connection = this.getConnection(application);
        }
        return connection;
    }

    private Connection getConnection(IApplication application) {
        IDomain domain = application.getDomain();
        if (domain == null) {
            return null;
        }
        return ConnectionsModelSingleton.getInstance().getConnectionByResource(domain.getUser());
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{Connection.class};
    }
}

