/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.jboss.tools.maven.core.ProjectUtil;
import org.jboss.tools.maven.project.examples.AbstractImportMavenProjectDelegate;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;

public class ImportMavenArchetypeProjectExampleDelegate
extends AbstractImportMavenProjectDelegate {
    @Override
    public boolean importProject(ProjectExampleWorkingCopy projectDescription, File file, Map<String, Object> propertiesMap, IProgressMonitor monitor) throws Exception {
        ArrayList<String> includedProjects = new ArrayList<String>();
        projectDescription.setIncludedProjects(includedProjects);
        projectDescription.setWelcomeURL(null);
        projectDescription.setWelcome(false);
        String projectName = (String)propertiesMap.get("projectName");
        includedProjects.add(projectName);
        String artifactId = (String)propertiesMap.get("artifactId");
        IPath location = (IPath)propertiesMap.get("locationPath");
        String projectFolder = location.append(artifactId).toFile().getAbsolutePath();
        MavenModelManager mavenModelManager = MavenPlugin.getMavenModelManager();
        LocalProjectScanner scanner = new LocalProjectScanner(location.toFile(), projectFolder, true, mavenModelManager);
        try {
            scanner.run(monitor);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        Set<MavenProjectInfo> projectSet = this.collectProjects(scanner.getProjects());
        ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration();
        for (MavenProjectInfo info : projectSet) {
            try {
                projectName = MavenProjectExamplesActivator.getProjectName(info, importConfiguration);
                if (includedProjects.contains(projectName)) continue;
                includedProjects.add(projectName);
            }
            catch (CoreException e) {
                MavenProjectExamplesActivator.log(e);
                return false;
            }
        }
        List iprojects = ProjectUtil.toIProjects(includedProjects);
        ProjectUtil.updateOutOfDateMavenProjects((List)iprojects, (IProgressMonitor)monitor);
        return true;
    }

    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }
}

