/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.ISourceField;
import org.eclipse.jdt.internal.core.JavaElement;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.common.util.StringUtil;

public class ValueResolver {
    private IJavaElement element;
    private Object constant = null;
    private ReferenceResolver referenceResolver = null;
    static Set<String> PRIMITIVE_TYPES = new HashSet<String>();

    static {
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("char");
    }

    public ValueResolver(IJavaElement element) {
        this.element = element;
    }

    public Object getConstant() {
        return this.constant;
    }

    public void dispose() {
        if (this.referenceResolver != null) {
            this.referenceResolver.dispose();
            this.referenceResolver = null;
        }
    }

    public Object resolvePair(IMemberValuePair pair) {
        this.constant = null;
        Object value = pair.getValue();
        int k = pair.getValueKind();
        if (k == 12 || k == 13 || value instanceof Object[] && k == 14) {
            if (this.element != null && this.element.getAncestor(5) instanceof ICompilationUnit) {
                value = this.resolve(value);
            }
        } else if (k == 14 && value == null && this.element instanceof ISourceReference) {
            try {
                Object c;
                String source = this.getExpressionForName(pair.getMemberName());
                if (source != null && (c = this.resolveExpression(source)) != null) {
                    value = source;
                    this.constant = c;
                }
            }
            catch (CoreException e) {
                CommonCorePlugin.getDefault().logError(e);
            }
        }
        return value;
    }

    private String getExpressionForName(String name) throws CoreException {
        String source;
        if (name == null) {
            name = "value";
        }
        if ((source = this.getExpression()) != null) {
            if (source.indexOf(61) < 0) {
                if ("value".equals(name)) {
                    return source;
                }
                return null;
            }
            StringTokenizer st = new StringTokenizer(source, ",");
            while (st.hasMoreTokens()) {
                String t = st.nextToken().trim();
                int i = t.indexOf(61);
                if (i < 0 || !t.substring(0, i).trim().equals(name)) continue;
                return t.substring(i + 1).trim();
            }
        }
        return null;
    }

    private Object resolve(Object value) {
        if (value instanceof Object[]) {
            Object[] vs = (Object[])value;
            int i = 0;
            while (i < vs.length) {
                vs[i] = this.resolve(vs[i]);
                ++i;
            }
            this.constant = null;
        } else if (value != null && ValueResolver.isNameToken(value.toString())) {
            try {
                if (this.connect()) {
                    value = this.referenceResolver.resolveReference(value);
                }
            }
            catch (CoreException e) {
                CommonCorePlugin.getDefault().logError(e);
            }
        }
        return value;
    }

    private String getExpression() throws CoreException {
        String source = ((ISourceReference)this.element).getSource();
        if (source != null) {
            int b = source.indexOf(40);
            int e = source.lastIndexOf(41);
            if (b > 0 && e > b) {
                return source.substring(b + 1, e).trim();
            }
        }
        return null;
    }

    private void setFieldInitialValueToConstant(IField f) throws JavaModelException {
        Object c = ValueResolver.getFieldInitialValue(f);
        if (c != null) {
            this.constant = c instanceof String ? StringUtil.trimQuotes(c.toString()) : (c instanceof Number || c instanceof Boolean ? c : c.toString());
        }
    }

    public static Object getFieldInitialValue(IField f) throws JavaModelException {
        char[] cs;
        Object c = f.getConstant();
        if (c == null && ((JavaElement)f).getElementInfo() instanceof ISourceField && (cs = ((ISourceField)((JavaElement)f).getElementInfo()).getInitializationSource()) != null) {
            ValueResolver r = new ValueResolver((IJavaElement)f);
            c = r.resolveExpression(new String(cs));
            r.dispose();
        }
        return c;
    }

    public Object resolveExpression(String expression) {
        Expression expr = new Expression(expression, 0, expression.length());
        try {
            return expr.compute();
        }
        catch (WrongExpressionException wrongExpressionException) {
            return null;
        }
    }

    private boolean connect() throws CoreException {
        if (this.referenceResolver == null) {
            this.referenceResolver = new ReferenceResolver();
        }
        return this.referenceResolver.connect();
    }

    private static int findMatchingBrace(String expression, int from, int to) {
        int k = 0;
        int i = from;
        while (i < to) {
            char c = expression.charAt(i);
            if (c == '(') {
                ++k;
            } else if (c == ')' && --k == 0) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private static int findMatchingQuote(String expression, int from, int to) {
        char q = expression.charAt(from);
        int i = from + 1;
        while (i < to) {
            char c = expression.charAt(i);
            if (c == q) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private static Object add(Object left, int operation, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String || right instanceof String) {
            if (operation == 0) {
                return String.valueOf(left.toString()) + right;
            }
        } else {
            if (left instanceof Character) {
                return ValueResolver.add(new Integer(((Character)left).charValue()), operation, right);
            }
            if (right instanceof Character) {
                return ValueResolver.add(left, operation, new Integer(((Character)right).charValue()));
            }
            if (left instanceof Number && right instanceof Number) {
                if (operation == 0) {
                    return ValueResolver.add((Number)left, (Number)right);
                }
                if (operation == 1) {
                    return ValueResolver.subtract((Number)left, (Number)right);
                }
            }
        }
        return null;
    }

    private static Object add(Number left, Number right) {
        if (left instanceof Double || right instanceof Double) {
            return new Double(left.doubleValue() + right.doubleValue());
        }
        if (left instanceof Float || right instanceof Float) {
            return new Float(left.floatValue() + right.floatValue());
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() + right.longValue());
        }
        return new Integer(left.intValue() + right.intValue());
    }

    private static Object subtract(Number left, Number right) {
        if (left instanceof Double || right instanceof Double) {
            return new Double(left.doubleValue() - right.doubleValue());
        }
        if (left instanceof Float || right instanceof Float) {
            return new Float(left.floatValue() - right.floatValue());
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() - right.longValue());
        }
        return new Integer(left.intValue() - right.intValue());
    }

    private static Object multiply(Object left, Object right) {
        if (left == null || right == null) {
            return right;
        }
        if (left instanceof Number && right instanceof Number) {
            return ValueResolver.multiply((Number)left, (Number)right);
        }
        return null;
    }

    private static Object multiply(Number left, Number right) {
        if (left instanceof Double || right instanceof Double) {
            return new Double(left.doubleValue() * right.doubleValue());
        }
        if (left instanceof Float || right instanceof Float) {
            return new Float(left.floatValue() * right.floatValue());
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() * right.longValue());
        }
        return new Integer(left.intValue() * right.intValue());
    }

    private static Object divide(Object left, Object right) throws WrongExpressionException {
        if (left == null || right == null) {
            return right;
        }
        if (left instanceof Number && right instanceof Number) {
            return ValueResolver.divide((Number)left, (Number)right);
        }
        return null;
    }

    private static Object divide(Number left, Number right) throws WrongExpressionException {
        if (ValueResolver.isZero(right)) {
            throw new WrongExpressionException("Division by zero " + right);
        }
        if (left instanceof Double || right instanceof Double) {
            return new Double(left.doubleValue() / right.doubleValue());
        }
        if (left instanceof Float || right instanceof Float) {
            return new Float(left.floatValue() / right.floatValue());
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() / right.longValue());
        }
        return new Integer(left.intValue() / right.intValue());
    }

    private static boolean isZero(Number n) {
        if (n instanceof Double) {
            return Math.abs(n.doubleValue()) < 1.0E-14;
        }
        if (n instanceof Float) {
            return (double)Math.abs(n.floatValue()) < 1.0E-7;
        }
        return n.intValue() == 0;
    }

    private static boolean isNameToken(String t) {
        if (t.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(t.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < t.length()) {
            char ch = t.charAt(i);
            if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getFullName(IType type, IImportDeclaration[] is, String name) throws CoreException {
        IImportDeclaration[] iImportDeclarationArray = is;
        int n = is.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration d = iImportDeclarationArray[n2];
            String n3 = d.getElementName();
            if (n3.equals(name) || n3.endsWith("." + name)) {
                return n3;
            }
            if (Flags.isStatic((int)d.getFlags()) && n3.endsWith(".*")) {
                IField f;
                String typename = n3.substring(0, n3.length() - 2);
                IType t = EclipseJavaUtil.findType(type.getJavaProject(), typename);
                if (t != null && t.exists() && (f = EclipseJavaUtil.findField(t, name)) != null) {
                    return String.valueOf(f.getDeclaringType().getFullyQualifiedName()) + "." + name;
                }
            }
            ++n2;
        }
        return null;
    }

    private static IField findField(IJavaProject jp, String typeName, String fieldName) throws CoreException {
        IField f;
        IType t = EclipseJavaUtil.findType(jp, typeName);
        if (t == null && typeName.lastIndexOf(46) > 0) {
            int i = typeName.lastIndexOf(46);
            String innerType = String.valueOf(typeName.substring(0, i)) + "$" + typeName.substring(i + 1);
            t = EclipseJavaUtil.findType(jp, innerType);
        }
        if (t != null && (f = t.getField(fieldName)) != null && f.exists()) {
            return f;
        }
        return null;
    }

    class Expression {
        String expression;
        int from;
        int to;
        int index;
        Object result = null;

        public Expression(String expression, int from, int to) {
            this.expression = expression;
            this.from = from;
            this.to = to;
            this.index = from;
            this.skipSpaces();
        }

        void skipSpaces() {
            while (this.index < this.to && Character.isWhitespace(this.expression.charAt(this.index))) {
                ++this.index;
            }
        }

        int getOperandTokenEnd() {
            if (this.index == this.to) {
                return this.index;
            }
            int i = this.index;
            while (i < this.to) {
                char ch = this.expression.charAt(i);
                if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                    return i;
                }
                ++i;
            }
            return this.to;
        }

        public Object compute() throws WrongExpressionException {
            Object left = this.computeOperand();
            this.skipSpaces();
            if (this.index == this.to) {
                this.result = left;
            } else {
                Object right;
                char ch = this.expression.charAt(this.index);
                while (ch == '*' || ch == '/') {
                    ++this.index;
                    right = this.computeOperand();
                    this.skipSpaces();
                    if (ch == '*') {
                        left = ValueResolver.multiply(left, right);
                    } else if (ch == '/') {
                        left = ValueResolver.divide(left, right);
                    }
                    if (this.index == this.to) {
                        this.result = left;
                        return this.result;
                    }
                    ch = this.expression.charAt(this.index);
                }
                if (ch == '+') {
                    ++this.index;
                    right = this.compute();
                    return ValueResolver.add(left, 0, right);
                }
                if (ch == '-') {
                    right = this.compute();
                    return ValueResolver.add(left, 0, right);
                }
            }
            return this.result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object computeOperand() throws WrongExpressionException {
            this.skipSpaces();
            if (this.index == this.to) {
                throw new WrongExpressionException("Operand expected");
            }
            char ch = this.expression.charAt(this.index);
            if (ch == '\"') {
                int m = ValueResolver.findMatchingQuote(this.expression, this.index, this.to);
                if (m < 0) {
                    throw new WrongExpressionException("Quote does not match.");
                }
                int b = this.index + 1;
                this.index = m;
                return this.expression.substring(b, m - 1);
            }
            if (ch == '\'') {
                int m = ValueResolver.findMatchingQuote(this.expression, this.index, this.to);
                if (m < 0) {
                    throw new WrongExpressionException("Quote does not match.");
                }
                int b = this.index + 1;
                this.index = m;
                String v = this.expression.substring(b, m - 1);
                if (v.length() == 1) {
                    return new Character(this.expression.charAt(b));
                }
                if (!v.startsWith("\\")) throw new WrongExpressionException("Not supported character " + v);
                if (v.equals("\\n")) {
                    return new Character('\n');
                }
                if (v.equals("\\r")) {
                    return new Character('\r');
                }
                if (v.equals("\\t")) {
                    return new Character('\t');
                }
                if (v.equals("\\b")) {
                    return new Character('\b');
                }
                if (v.equals("\\f")) {
                    return new Character('\f');
                }
                if (v.equals("\\'")) {
                    return new Character('\'');
                }
                if (v.equals("\\\"")) {
                    return new Character('\"');
                }
                if (v.equals("\\\\")) {
                    return new Character('\\');
                }
                if (!v.startsWith("\\u") || v.length() != 6) throw new WrongExpressionException("Not supported character " + v);
                try {
                    return new Character((char)Integer.parseInt(v.substring(2), 16));
                }
                catch (NumberFormatException numberFormatException) {}
                throw new WrongExpressionException("Not supported character " + v);
            }
            if (ch == '(') {
                int m = ValueResolver.findMatchingBrace(this.expression, this.index, this.to);
                if (m < 0) {
                    throw new WrongExpressionException("Braces does not match.");
                }
                String sub = this.expression.substring(this.index + 1, m - 1).trim();
                if (sub.length() == 0) {
                    throw new WrongExpressionException("Expression expected at " + (this.index + 1));
                }
                if (PRIMITIVE_TYPES.contains(sub)) {
                    this.index = m;
                    Object o = this.computeOperand();
                    if (o instanceof Character) {
                        if ("char".equals(sub)) return o;
                        o = new Integer(((Character)o).charValue());
                    }
                    if (!(o instanceof Number)) throw new WrongExpressionException("Cannot convert to " + sub + ".");
                    if ("int".equals(sub)) {
                        return new Integer(((Number)o).intValue());
                    }
                    if ("short".equals(sub)) {
                        return new Short(((Number)o).shortValue());
                    }
                    if ("byte".equals(sub)) {
                        return new Byte(((Number)o).byteValue());
                    }
                    if ("long".equals(sub)) {
                        return new Long(((Number)o).longValue());
                    }
                    if ("float".equals(sub)) {
                        return new Float(((Number)o).floatValue());
                    }
                    if ("double".equals(sub)) {
                        return new Double(((Number)o).doubleValue());
                    }
                    if (!"char".equals(sub)) return null;
                    return new Character((char)((Number)o).intValue());
                }
                Expression subExpression = new Expression(this.expression, this.index + 1, m - 1);
                Object o = subExpression.compute();
                this.index = m;
                this.skipSpaces();
                return o;
            }
            if (ch == '+') {
                ++this.index;
                return this.computeOperand();
            }
            if (ch == '-') {
                ++this.index;
                Object o = this.computeOperand();
                if (o instanceof Number) {
                    Number n = (Number)o;
                    if (n instanceof Long) {
                        return new Long(-n.longValue());
                    }
                    if (n instanceof Float) {
                        return new Float(-n.floatValue());
                    }
                    if (!(n instanceof Double)) return new Integer(-n.intValue());
                    return new Double(-n.doubleValue());
                }
                if (!(o instanceof Character)) throw new WrongExpressionException("Cannot compute negative of non-number");
                if (!(o instanceof Character)) return null;
                return new Integer(-((Character)o).charValue());
            }
            int e = this.getOperandTokenEnd();
            if (e == this.index) {
                throw new WrongExpressionException("Operand expected at " + this.index);
            }
            String t = this.expression.substring(this.index, e);
            this.index = e;
            if (ValueResolver.isNameToken(t)) {
                try {
                    Object o;
                    ValueResolver.this.constant = null;
                    Object object = o = ValueResolver.this.connect() ? ValueResolver.this.referenceResolver.resolveReference(t) : null;
                    if (ValueResolver.this.constant != null) {
                        return ValueResolver.this.constant;
                    }
                    if (o == null) throw new WrongExpressionException("Cannut resolve name " + t);
                    return o;
                }
                catch (CoreException exc) {
                    CommonCorePlugin.getDefault().logError(exc);
                    throw new WrongExpressionException("Cannut resolve value " + t);
                }
            } else {
                try {
                    return Integer.parseInt(t);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        if (!t.toLowerCase().endsWith("l")) return Long.parseLong(t);
                        t = t.substring(0, t.length() - 1);
                        return Long.parseLong(t);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            if (!t.toLowerCase().endsWith("d") && !t.toLowerCase().endsWith("f")) return Double.parseDouble(t);
                            t = t.substring(0, t.length() - 1);
                            return Double.parseDouble(t);
                        }
                        catch (NumberFormatException numberFormatException3) {}
                    }
                }
            }
            throw new WrongExpressionException("Cannut resolve value " + t);
        }
    }

    class ReferenceResolver {
        private boolean isConnected = false;
        private ICompilationUnit u = null;
        private ICompilationUnit u2 = null;
        private IType type = null;

        ReferenceResolver() {
        }

        private boolean connect() throws CoreException {
            if (this.isConnected) {
                return this.type != null;
            }
            this.isConnected = true;
            if (ValueResolver.this.element == null) {
                return false;
            }
            this.u = (ICompilationUnit)ValueResolver.this.element.getAncestor(5);
            if (this.u == null) {
                return false;
            }
            this.u2 = null;
            this.type = (IType)ValueResolver.this.element.getAncestor(7);
            if (this.type == null && this.u != null && ValueResolver.this.element.getParent() instanceof IPackageDeclaration) {
                IType[] ts = this.u.getTypes();
                if (ts != null && ts.length > 0) {
                    this.type = ts[0];
                } else {
                    this.u2 = this.u.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                    this.type = this.u2.createType("class A {}", null, false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            return this.type != null;
        }

        public void dispose() {
            if (this.u2 != null) {
                try {
                    this.u2.discardWorkingCopy();
                }
                catch (JavaModelException javaModelException) {}
                this.u2 = null;
            }
            this.u = null;
            this.type = null;
        }

        Object resolveReference(Object value) throws CoreException {
            IImportDeclaration[] is = this.u.getImports();
            String stringValue = value.toString();
            int lastDot = stringValue.lastIndexOf(46);
            String lastToken = stringValue.substring(lastDot + 1);
            if (lastDot < 0) {
                IField f;
                IField iField = f = ValueResolver.this.element.getParent() == this.type ? this.type.getField(lastToken) : EclipseJavaUtil.findField(this.type, lastToken);
                if (f != null && f.exists()) {
                    value = String.valueOf(f.getDeclaringType().getFullyQualifiedName()) + "." + lastToken;
                    ValueResolver.this.setFieldInitialValueToConstant(f);
                } else {
                    String v = ValueResolver.getFullName(this.type, is, lastToken);
                    if (v != null) {
                        value = v;
                        String typeName = v.substring(0, v.length() - lastToken.length() - 1);
                        f = ValueResolver.findField(this.type.getJavaProject(), typeName, lastToken);
                        if (f != null) {
                            ValueResolver.this.setFieldInitialValueToConstant(f);
                        }
                    }
                }
                return value;
            }
            String prefix = stringValue.substring(0, lastDot);
            String t = EclipseJavaUtil.resolveType(this.type, prefix);
            if (t != null) {
                IType q = EclipseJavaUtil.findType(this.type.getJavaProject(), t);
                if (q != null && q.getField(lastToken).exists()) {
                    value = String.valueOf(t) + "." + lastToken;
                    IField f = q.getField(lastToken);
                    ValueResolver.this.setFieldInitialValueToConstant(f);
                } else {
                    String v = ValueResolver.getFullName(this.type, is, lastToken);
                    if (v != null && v.endsWith(stringValue)) {
                        value = v;
                        String typeName = v.substring(0, v.length() - lastToken.length() - 1);
                        IField f = ValueResolver.findField(this.type.getJavaProject(), typeName, lastToken);
                        if (f != null) {
                            ValueResolver.this.setFieldInitialValueToConstant(f);
                        }
                    }
                }
            }
            return value;
        }
    }

    static class WrongExpressionException
    extends Exception {
        public WrongExpressionException(String message) {
            super(message);
        }
    }
}

