/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.NoRegionContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.jboss.ide.eclipse.as.ui.mbeans.Activator;
import org.jboss.ide.eclipse.as.ui.mbeans.Messages;
import org.jboss.ide.eclipse.as.ui.util.BaseXMLHyperlinkUtil;
import org.jboss.ide.eclipse.as.ui.util.PackageTypeSearcher;
import org.jboss.ide.eclipse.as.ui.util.ServiceXMLEditorUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ServiceXMLEditorConfiguration
extends StructuredTextViewerConfigurationXML {
    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (partitionType == "org.eclipse.wst.sse.ST_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_DEFAULT") {
            processors = new IContentAssistProcessor[]{new ServiceXMLContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE") {
            processors = new IContentAssistProcessor[]{new NoRegionContentAssistProcessor()};
        }
        return processors;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || this.hyperLinksEnabled()) {
            return null;
        }
        IHyperlinkDetector[] baseDetectors = super.getHyperlinkDetectors(sourceViewer);
        ServiceXMLHyperLinkDetector hyperlinkDetector = new ServiceXMLHyperLinkDetector();
        if (baseDetectors == null || baseDetectors.length == 0) {
            return new IHyperlinkDetector[]{hyperlinkDetector};
        }
        IHyperlinkDetector[] result = new IHyperlinkDetector[baseDetectors.length + 1];
        result[0] = hyperlinkDetector;
        int i = 0;
        while (i < baseDetectors.length) {
            result[i + 1] = baseDetectors[i];
            ++i;
        }
        return result;
    }

    private boolean hyperLinksEnabled() {
        return !this.fPreferenceStore.getBoolean("hyperlinksEnabled");
    }

    public class ServiceXMLContentAssistProcessor
    extends XMLContentAssistProcessor {
        private HashMap<String, List<ChildOccurances>> children = new HashMap();
        private HashMap<String, List> attributes = new HashMap();

        public ServiceXMLContentAssistProcessor() {
            this.fillChildren();
            this.fillAttributes();
        }

        private void fillChildren() {
            ArrayList<ChildOccurances> list = new ArrayList<ChildOccurances>();
            list.add(new ChildOccurances("loader-repository", "_ZERO_OR_ONE_"));
            list.add(new ChildOccurances("local-directory", "_ZERO_TO_INFINITY_"));
            list.add(new ChildOccurances("classpath", "_ZERO_TO_INFINITY_"));
            list.add(new ChildOccurances("mbean", "_ZERO_TO_INFINITY_"));
            this.children.put("server", list);
            list = new ArrayList();
            list.add(new ChildOccurances("loader-repository-config", "_ZERO_TO_INFINITY_"));
            this.children.put("loader-repository", list);
            this.children.put("loader-repository-config", new ArrayList());
            this.children.put("local-directory", new ArrayList());
            this.children.put("classpath", new ArrayList());
            list = new ArrayList();
            list.add(new ChildOccurances("constructor", "_ZERO_OR_ONE_"));
            list.add(new ChildOccurances("xmbean", "_ZERO_OR_ONE_"));
            list.add(new ChildOccurances("attribute", "_ZERO_TO_INFINITY_"));
            list.add(new ChildOccurances("depends", "_ZERO_TO_INFINITY_"));
            list.add(new ChildOccurances("depends-list", "_ZERO_TO_INFINITY_"));
            this.children.put("mbean", list);
            this.children.put("xmbean", new ArrayList());
            list = new ArrayList();
            list.add(new ChildOccurances("arg", "_ZERO_TO_INFINITY_"));
            this.children.put("constructor", list);
            this.children.put("arg", new ArrayList());
            this.children.put("attribute", new ArrayList());
            this.children.put("property", new ArrayList());
            list = new ArrayList();
            list.add(new ChildOccurances("mbean", "_ZERO_TO_INFINITY_"));
            this.children.put("depends", list);
            list = new ArrayList();
            list.add(new ChildOccurances("depends-list-element", "_ONE_TO_INFINITY_"));
            this.children.put("depends-list", list);
            list = new ArrayList();
            list.add(new ChildOccurances("mbean", "_ZERO_TO_INFINITY_"));
            this.children.put("depends-list-element", list);
        }

        private void fillAttributes() {
            this.attributes.put("server", new ArrayList());
            this.attributes.put("loader-repository", Arrays.asList(new DTDAttributes("loaderRepositoryClass", 1, 2)));
            this.attributes.put("loader-repository-config", Arrays.asList(new DTDAttributes("configParserClass", 1, 2)));
            this.attributes.put("local-directory", Arrays.asList(new DTDAttributes("path", 1, 2)));
            this.attributes.put("classpath", Arrays.asList(new DTDAttributes("codebase", 1, 1), new DTDAttributes("archives", 1, 2)));
            this.attributes.put("mbean", Arrays.asList(new DTDAttributes("code", 1, 1), new DTDAttributes("name", 1, 1), new DTDAttributes("interface", 1, 2), new DTDAttributes("xmbean-dd", 1, 2), new DTDAttributes("xmbean-code", 1, 2)));
            this.attributes.put("arg", Arrays.asList(new DTDAttributes("type", 1, 2), new DTDAttributes("value", 1, 1)));
            this.attributes.put("attribute", Arrays.asList(new DTDAttributes("name", 1, 1), new DTDAttributes("replace", 2, 2, "true", new String[]{"true", "false"}), new DTDAttributes("trim", 2, 2, "true", new String[]{"true", "false"}), new DTDAttributes("attributeClass", 1, 2), new DTDAttributes("serialDataType", 2, 2, "text", new String[]{"text", "javaBean", "jbxb"})));
            this.attributes.put("property", Arrays.asList(new DTDAttributes("name", 1, 1)));
            this.attributes.put("depends", Arrays.asList(new DTDAttributes("optional-attribute-name", 1, 2), new DTDAttributes("proxy-type", 1, 2)));
            this.attributes.put("depends-list", Arrays.asList(new DTDAttributes("type", 1, 2)));
        }

        protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest) {
            super.addEmptyDocumentProposals(contentAssistRequest);
            int beginPosition = contentAssistRequest.getReplacementBeginPosition();
            String text = "<server>";
            int cursorPos = text.length();
            contentAssistRequest.addProposal((ICompletionProposal)new CompletionProposal(text, beginPosition, 0, cursorPos, null, text, null, null));
            text = String.valueOf(text) + "\n\t\n</server>";
            contentAssistRequest.addProposal((ICompletionProposal)new CompletionProposal(text, beginPosition, 0, cursorPos + 2, null, text.replaceAll("\n", "").replaceAll("\t", ""), null, null));
        }

        protected void addStartDocumentProposals(ContentAssistRequest contentAssistRequest) {
            super.addStartDocumentProposals(contentAssistRequest);
        }

        protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
            List<ChildOccurances> possibleNodes;
            String parentElement = contentAssistRequest.getParent().getNodeName();
            String thisNode = contentAssistRequest.getNode().getNodeName();
            if (thisNode.equals("#text")) {
                thisNode = "";
            }
            if ((possibleNodes = this.children.get(parentElement)) != null) {
                int i = 0;
                while (i < possibleNodes.size()) {
                    ChildOccurances occ = possibleNodes.get(i);
                    if (occ.name.startsWith(thisNode)) {
                        this.createAndAddTagCompletionProposals(contentAssistRequest.getNode(), occ, contentAssistRequest.getParent(), contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest, true);
                    }
                    ++i;
                }
            }
        }

        protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
            super.addTagInsertionProposals(contentAssistRequest, childPosition);
            List superProps = contentAssistRequest.getProposals();
            ICompletionProposal[] proposals = superProps.toArray(new ICompletionProposal[superProps.size()]);
            ArrayList<String> alreadyAddedStrings = new ArrayList<String>();
            int i = 0;
            while (i < proposals.length) {
                alreadyAddedStrings.add(proposals[i].getDisplayString());
                ++i;
            }
            String parentElement = contentAssistRequest.getParent().getNodeName();
            List<ChildOccurances> possibleNodes = this.children.get(parentElement);
            if (possibleNodes != null) {
                int i2 = 0;
                while (i2 < possibleNodes.size()) {
                    ChildOccurances occ = possibleNodes.get(i2);
                    this.createAndAddTagCompletionProposals(contentAssistRequest.getNode(), occ, contentAssistRequest.getParent(), contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest, false);
                    ++i2;
                }
            }
        }

        private void createAndAddTagCompletionProposals(Node thisNode, ChildOccurances occ, Node parentNode, int beginPosition, ContentAssistRequest contentAssistRequest, boolean isTagOpened) {
            if (!this.confirmsOccuranceRequirements(thisNode, parentNode, occ)) {
                return;
            }
            Image propImage = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
            String nName = thisNode.getNodeName().equals("#text") ? "" : thisNode.getNodeName();
            String emptyCompletionText = String.valueOf(occ.name) + ">";
            int cursorLoc = emptyCompletionText.length();
            emptyCompletionText = String.valueOf(emptyCompletionText) + "</" + occ.name + ">";
            String descriptionText = "";
            if (!isTagOpened) {
                emptyCompletionText = "<" + emptyCompletionText;
                ++cursorLoc;
            }
            descriptionText = occ.name;
            contentAssistRequest.addProposal((ICompletionProposal)new CompletionProposal(emptyCompletionText, beginPosition, nName.length(), cursorLoc, propImage, descriptionText, null, null));
            if (this.attributes.containsKey(occ.name)) {
                List l = this.attributes.get(occ.name);
                Iterator i = l.iterator();
                cursorLoc = -1;
                String attributes = "";
                while (i.hasNext()) {
                    DTDAttributes attribute = (DTDAttributes)i.next();
                    if (attribute.mandatory != 1) continue;
                    attributes = String.valueOf(attributes) + " " + attribute.name + "=\"" + attribute.defaultValue + "\"";
                    if (cursorLoc != -1 || !attribute.defaultValue.equals("")) continue;
                    cursorLoc = occ.name.length() + attributes.length() - 1;
                }
                String requiredCompletionText = String.valueOf(occ.name) + attributes + "></" + occ.name + ">";
                if (!isTagOpened) {
                    requiredCompletionText = "<" + requiredCompletionText;
                    ++cursorLoc;
                }
                descriptionText = MessageFormat.format(Messages.ServiceXMLEditorConfiguration_OccurrenceNameWithAttributes, occ.name);
                if (!attributes.equals("")) {
                    contentAssistRequest.addProposal((ICompletionProposal)new CompletionProposal(requiredCompletionText, beginPosition, nName.length(), cursorLoc != -1 ? cursorLoc : requiredCompletionText.length(), propImage, descriptionText, null, null));
                }
            }
        }

        private boolean confirmsOccuranceRequirements(Node thisNode, Node parentNode, ChildOccurances occ) {
            return true;
        }

        protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
            super.addAttributeNameProposals(contentAssistRequest);
            List superProps = contentAssistRequest.getProposals();
            ICompletionProposal[] proposals = superProps.toArray(new ICompletionProposal[superProps.size()]);
            ArrayList<String> alreadyAddedStrings = new ArrayList<String>();
            int i = 0;
            while (i < proposals.length) {
                alreadyAddedStrings.add(proposals[i].getDisplayString());
                ++i;
            }
            Image attImage = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
            ArrayList<String> activeAttributes = new ArrayList<String>();
            NamedNodeMap nnl = contentAssistRequest.getNode().getAttributes();
            int i2 = 0;
            while (i2 < nnl.getLength()) {
                activeAttributes.add(nnl.item(i2).getNodeName());
                ++i2;
            }
            String elementName = contentAssistRequest.getNode().getNodeName();
            String match = contentAssistRequest.getMatchString();
            ArrayList list = this.attributes.get(elementName) == null ? new ArrayList() : this.attributes.get(elementName);
            for (DTDAttributes att : list) {
                if (!att.name.startsWith(match) || activeAttributes.contains(att.name) || alreadyAddedStrings.contains(att.name)) continue;
                String txt = String.valueOf(att.name) + "=\"" + att.defaultValue + "\"";
                contentAssistRequest.addProposal((ICompletionProposal)new CompletionProposal(txt, contentAssistRequest.getReplacementBeginPosition(), match.length(), txt.length() - 1, attImage, att.name, null, null));
            }
        }

        protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
            String elementName = contentAssistRequest.getNode().getNodeName();
            contentAssistRequest.getMatchString();
            contentAssistRequest.getText();
            int beginPos = contentAssistRequest.getReplacementBeginPosition();
            NamedNodeMap map = contentAssistRequest.getNode().getAttributes();
            boolean found = false;
            AttrImpl attribute = null;
            int i = 0;
            while (i < map.getLength() && !found) {
                Node tmp = map.item(i);
                if (tmp instanceof AttrImpl) {
                    int start = ((AttrImpl)tmp).getStartOffset();
                    int end = ((AttrImpl)tmp).getEndOffset();
                    if (beginPos > start && beginPos < end) {
                        found = true;
                        attribute = (AttrImpl)tmp;
                    }
                }
                ++i;
            }
            if (found) {
                if (elementName.equals("mbean") && attribute.getName().equals("code")) {
                    this.handleCodeClassNameCompletion(contentAssistRequest);
                }
                if (elementName.equals("attribute") && attribute.getName().equals("name")) {
                    this.handleAttributeNamesCompletion(contentAssistRequest);
                }
            }
        }

        protected void handleCodeClassNameCompletion(ContentAssistRequest contentAssistRequest) {
            String match = contentAssistRequest.getMatchString();
            String attributeCurrentValue = match.startsWith("\"") ? match.substring(1) : match;
            PackageTypeSearcher.ResultFilter filter = new PackageTypeSearcher.ResultFilter(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean accept(Object found) {
                    try {
                        if (found instanceof IPackageFragment) {
                            return ((IPackageFragment)found).containsJavaResources();
                        }
                        if (!(found instanceof IType)) return false;
                        IType type = (IType)found;
                        String[] interfaces = type.getSuperInterfaceNames();
                        int i = 0;
                        while (true) {
                            if (i >= interfaces.length) {
                                return false;
                            }
                            if (interfaces[i].equals(String.valueOf(type.getElementName()) + "MBean")) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return false;
                }
            };
            PackageTypeSearcher searcher = new PackageTypeSearcher(attributeCurrentValue, filter);
            ICompletionProposal[] props = searcher.generateProposals(contentAssistRequest.getReplacementBeginPosition() + 1);
            int i = 0;
            while (i < props.length) {
                contentAssistRequest.addProposal(props[i]);
                ++i;
            }
        }

        protected void handleAttributeNamesCompletion(ContentAssistRequest contentAssistRequest) {
            String match = contentAssistRequest.getMatchString();
            String attributeCurrentValue = match.startsWith("\"") ? match.substring(1) : match;
            Node node = contentAssistRequest.getNode();
            Node mbeanNode = node.getParentNode();
            NamedNodeMap mbeanAttributes = mbeanNode.getAttributes();
            Node att = mbeanAttributes.getNamedItem("code");
            String codeClass = att.getNodeValue();
            IType type = ServiceXMLEditorUtil.findType(codeClass);
            if (type != null) {
                IMethod[] methods = ServiceXMLEditorUtil.getAllMethods(type);
                String[] attributeNames = ServiceXMLEditorUtil.findAttributesFromMethods(methods, attributeCurrentValue);
                int beginReplacement = contentAssistRequest.getReplacementBeginPosition() + 1;
                int i = 0;
                while (i < attributeNames.length) {
                    CompletionProposal cp = new CompletionProposal(attributeNames[i], beginReplacement, attributeCurrentValue.length(), beginReplacement + attributeNames[i].length());
                    contentAssistRequest.addProposal((ICompletionProposal)cp);
                    ++i;
                }
            }
        }

        private class ChildOccurances {
            public static final String ZERO_OR_ONE = "_ZERO_OR_ONE_";
            public static final String ONE = "_ONE_";
            public static final String ZERO_TO_INFINITY = "_ZERO_TO_INFINITY_";
            public static final String ONE_TO_INFINITY = "_ONE_TO_INFINITY_";
            public String name;
            public String numOccurances;

            public ChildOccurances(String name, String numOcc) {
                this.name = name;
                this.numOccurances = numOcc;
            }
        }

        private class DTDAttributes {
            public static final int REQUIRED = 1;
            public static final int IMPLIED = 2;
            public static final int FIXED = 3;
            public static final int CDATA_TYPE = 1;
            public static final int ENUM_TYPE = 2;
            public String name;
            public int mandatory;
            public int dataType;
            public String[] enumOptions;
            public String defaultValue;

            public DTDAttributes(String name, int dataType, int mandatory) {
                this(name, mandatory, dataType, null);
            }

            public DTDAttributes(String name, int dataType, int mandatory, String defaultValue) {
                this(name, mandatory, dataType, defaultValue, new String[0]);
            }

            public DTDAttributes(String name, int dataType, int mandatory, String defaultValue, String[] enumOptions) {
                this.name = name;
                this.enumOptions = enumOptions;
                this.mandatory = mandatory;
                this.dataType = dataType;
                this.defaultValue = defaultValue == null ? "" : defaultValue;
            }
        }
    }

    public class ServiceXMLHyperLinkDetector
    extends BaseXMLHyperlinkUtil
    implements IHyperlinkDetector {
        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            if (region == null || textViewer == null) {
                return null;
            }
            IDocument document = textViewer.getDocument();
            Node currentNode = this.getCurrentNode(document, region.getOffset());
            Attr attr = this.getCurrentAttrNode(currentNode, region.getOffset());
            if (currentNode.getNodeName().equals("mbean") && attr != null && attr.getName().equals("code")) {
                IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
                SearchPattern codePattern = SearchPattern.createPattern((String)attr.getValue(), (int)5, (int)0, (int)0);
                SearchEngine searchEngine = new SearchEngine();
                LocalSearchRequestor requestor = new LocalSearchRequestor();
                try {
                    searchEngine.search(codePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                    Object[] results = requestor.getResults();
                    if (results.length == 1 && results[0] instanceof IJavaElement) {
                        return new IHyperlink[]{new ServiceXMLHyperlink((IJavaElement)results[0], this.getHyperlinkRegion(attr))};
                    }
                }
                catch (Exception exception) {}
            }
            return null;
        }

        protected class LocalSearchRequestor
        extends SearchRequestor {
            private ArrayList<Object> list = new ArrayList();

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                this.list.add(match.getElement());
            }

            public Object[] getResults() {
                return this.list.toArray();
            }
        }

        protected class ServiceXMLHyperlink
        implements IHyperlink {
            private IJavaElement element;
            private IRegion region;

            public ServiceXMLHyperlink(IJavaElement element, IRegion region) {
                this.element = element;
                this.region = region;
            }

            public IRegion getHyperlinkRegion() {
                return this.region;
            }

            public String getHyperlinkText() {
                return null;
            }

            public String getTypeLabel() {
                return null;
            }

            public void open() {
                try {
                    IEditorPart part = EditorUtility.openInEditor((Object)this.element, (boolean)true);
                    if (part != null) {
                        EditorUtility.revealInEditor((IEditorPart)part, (IJavaElement)this.element);
                    }
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.jboss.ide.eclipse.as.ui.mbeans", Messages.ServiceXMLEditorConfiguration_UnableToDisplayInEditor, (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        }
    }
}

