/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans;

import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.ide.eclipse.as.ui.mbeans.Activator;
import org.osgi.framework.Bundle;

public class SharedImages {
    public static final String IMG_MBEAN = "mbean16";
    public static final String IMG_SAR_16 = "sar16";
    public static final String IMG_SAR_64 = "sar64";
    private static SharedImages instance;
    private Hashtable<String, Object> images;
    private Hashtable<String, Object> descriptors;

    private SharedImages() {
        instance = this;
        this.images = new Hashtable();
        this.descriptors = new Hashtable();
        Bundle pluginBundle = Activator.getDefault().getBundle();
        this.descriptors.put(IMG_MBEAN, this.createImageDescriptor(pluginBundle, "icons/mbean16.gif"));
        this.descriptors.put(IMG_SAR_16, this.createImageDescriptor(pluginBundle, "icons/sar16.gif"));
        this.descriptors.put(IMG_SAR_64, this.createImageDescriptor(pluginBundle, "icons/sar64.gif"));
        for (String key : this.descriptors.keySet()) {
            ImageDescriptor descriptor = this.descriptor(key);
            this.images.put(key, descriptor.createImage());
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle pluginBundle, String relativePath) {
        return ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(relativePath));
    }

    private static SharedImages instance() {
        if (instance == null) {
            return new SharedImages();
        }
        return instance;
    }

    public static Image getImage(String key) {
        return SharedImages.instance().image(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return SharedImages.instance().descriptor(key);
    }

    public Image image(String key) {
        return (Image)this.images.get(key);
    }

    public ImageDescriptor descriptor(String key) {
        return (ImageDescriptor)this.descriptors.get(key);
    }

    protected void finalize() throws Throwable {
        Iterator<String> iter = this.images.keySet().iterator();
        while (iter.hasNext()) {
            Image image = (Image)this.images.get(iter.next());
            image.dispose();
        }
        super.finalize();
    }
}

