/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.gef.edit.xpl;

import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.DropRequest;

public class FeedBackUtils {
    private FeedBackUtils() {
    }

    public static void showLayoutTargetFeedBack(Request request, FlowLayoutEditPolicy policy, Polyline fb, int feedbackIndex, boolean isHorizontal) {
        Rectangle parentBox;
        EditPart editPart;
        if (policy.getHost().getChildren().size() == 0) {
            return;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(!isHorizontal);
        boolean before = true;
        Rectangle r = null;
        if (feedbackIndex == -1) {
            before = false;
            feedbackIndex = policy.getHost().getChildren().size() - 1;
            editPart = (EditPart)policy.getHost().getChildren().get(feedbackIndex);
            r = transposer.t(FeedBackUtils.getAbsoluteBounds((GraphicalEditPart)editPart));
        } else {
            editPart = (EditPart)policy.getHost().getChildren().get(feedbackIndex);
            r = transposer.t(FeedBackUtils.getAbsoluteBounds((GraphicalEditPart)editPart));
            Point p = transposer.t(((DropRequest)request).getLocation());
            if (p.x <= r.x + r.width / 2) {
                before = true;
            } else {
                before = false;
                editPart = (EditPart)policy.getHost().getChildren().get(--feedbackIndex);
                r = transposer.t(FeedBackUtils.getAbsoluteBounds((GraphicalEditPart)editPart));
            }
        }
        int x = Integer.MIN_VALUE;
        if (before) {
            if (feedbackIndex > 0) {
                Rectangle boxPrev = transposer.t(FeedBackUtils.getAbsoluteBounds((GraphicalEditPart)policy.getHost().getChildren().get(feedbackIndex - 1)));
                int prevRight = boxPrev.right();
                if (prevRight < r.x) {
                    x = prevRight + (r.x - prevRight) / 2;
                } else if (prevRight == r.x) {
                    x = prevRight + 1;
                }
            }
            if (x == Integer.MIN_VALUE) {
                parentBox = transposer.t(FeedBackUtils.getAbsoluteBounds((GraphicalEditPart)policy.getHost()));
                x = r.x - 5;
                if (x < parentBox.x) {
                    x = parentBox.x + (r.x - parentBox.x) / 2;
                }
            }
        } else {
            parentBox = transposer.t(FeedBackUtils.getAbsoluteBounds((GraphicalEditPart)policy.getHost()));
            int rRight = r.x + r.width;
            x = rRight + 5;
            int pRight = parentBox.x + parentBox.width;
            if (x > pRight) {
                x = rRight + (pRight - rRight) / 2;
            }
        }
        Point p1 = new Point(x, r.y - 4);
        p1 = transposer.t(p1);
        fb.translateToRelative((Translatable)p1);
        Point p2 = new Point(x, r.y + r.height + 4);
        p2 = transposer.t(p2);
        fb.translateToRelative((Translatable)p2);
        fb.setPoint(p1, 0);
        fb.setPoint(p2, 1);
    }

    public static Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }
}

