/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.parser;

import org.eclipse.jface.text.rules.IToken;

public class LexicalToken
implements IToken {
    private LexicalToken previous;
    private LexicalToken next;
    private int start;
    private int length;
    private CharSequence chars;
    private int type;

    public LexicalToken(int start, int length, CharSequence chars, int type) {
        this.start = start;
        this.length = length;
        this.chars = chars;
        this.type = type;
    }

    public String toString() {
        return "ELToken(" + this.start + ", " + this.length + ", " + this.type + ") [" + (this.chars == null ? "<Empty>" : this.chars.toString()) + "]";
    }

    public Object getData() {
        return this.getText();
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEOF() {
        return this.start == -1 && this.length == -1 && this.chars == null;
    }

    public boolean isOther() {
        return false;
    }

    public boolean isUndefined() {
        return false;
    }

    public boolean isWhitespace() {
        return false;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getText() {
        return this.chars.toString();
    }

    public LexicalToken getPreviousToken() {
        return this.previous;
    }

    public LexicalToken getNextToken() {
        return this.next;
    }

    public void setNextToken(LexicalToken n) {
        if (n != null) {
            n.previous = this;
        }
        this.next = n;
    }

    void makeItFirst() {
        this.previous = null;
    }

    public LexicalToken findTokenBackword(int type) {
        if (this.previous == null) {
            return null;
        }
        if (this.previous.type == type) {
            return this.previous;
        }
        return this.previous.findTokenBackword(type);
    }

    public LexicalToken findTokenForward(int type) {
        if (this.next == null) {
            return null;
        }
        if (this.next.type == type) {
            return this.next;
        }
        return this.next.findTokenForward(type);
    }

    public void shift(int delta) {
        this.start += delta;
        if (this.next != null) {
            this.next.shift(delta);
        }
    }

    public LexicalToken getCombinedToken(LexicalToken last) {
        StringBuffer sb = new StringBuffer();
        LexicalToken t = this;
        while (t != null && t != last) {
            sb.append(t.getText());
            t = t.getNextToken();
        }
        if (t != null) {
            sb.append(t.getText());
        }
        LexicalToken token = new LexicalToken(this.start, last.getStart() + last.getLength() - this.start, sb.toString(), this.type);
        token.previous = this.previous;
        token.next = last.next;
        return token;
    }
}

