/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PreferDefaultValue;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.ValueSnapshot;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class PreferDefaultValueFactsService
extends FactsService {
    @Text(value="Recommended value is {0}")
    private static LocalizableText fact;

    static {
        LocalizableText.init(PreferDefaultValueFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        Value value = this.context(Value.class);
        String def = value.getDefaultText();
        if (def != null) {
            facts.add(fact.format(new ValueSnapshot(value.definition(), def)));
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                return property.hasAnnotation(PreferDefaultValue.class);
            }
            return false;
        }
    }
}

