/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.jdt.integration.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveType;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveFileSetImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveImpl;
import org.jboss.ide.eclipse.archives.core.model.types.AbstractArchiveType;

public class WorkspaceJARArchiveType
extends AbstractArchiveType {
    public static final String TYPE_ID = "jar";

    public IArchive createDefaultConfiguration(String projectName, IProgressMonitor monitor) {
        IPath outputPath;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        Assert.isNotNull((Object)project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Assert.isNotNull((Object)javaProject);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(ArchivesCore.bind((String)ArchivesCoreMessages.CreatingDefaultJarConfig, (String)project.getName()), 2);
        try {
            outputPath = javaProject.getOutputLocation();
        }
        catch (JavaModelException e) {
            ArchivesCore.getInstance().getLogger().log(2, e.getMessage(), (Throwable)e);
            return null;
        }
        outputPath = outputPath.removeFirstSegments(1);
        IFolder outputContainer = project.getFolder(outputPath);
        ArchiveImpl jar = new ArchiveImpl();
        jar.setDestinationPath(project.getLocation());
        jar.setInWorkspace(true);
        jar.setExploded(false);
        jar.setName(String.valueOf(project.getName()) + ".jar");
        jar.setArchiveType((IArchiveType)this);
        ArchiveFileSetImpl classes = new ArchiveFileSetImpl();
        classes.setIncludesPattern("**/*");
        classes.setRawSourcePath(outputContainer.getFullPath().toString());
        classes.setInWorkspace(true);
        try {
            jar.addChild((IArchiveNode)classes);
        }
        catch (ArchivesModelException archivesModelException) {}
        monitor.worked(1);
        monitor.done();
        return jar;
    }

    public IArchive fillDefaultConfiguration(String projectName, IArchive topLevel, IProgressMonitor monitor) {
        return null;
    }
}

