/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.jboss.tools.common.quickfix.MarkerAnnotationInfo;

public class BaseQuickAssistProcessor
implements IQuickAssistProcessor {
    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return annotation instanceof SimpleMarkerAnnotation || annotation instanceof TemporaryAnnotation;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList all = new ArrayList();
        ArrayList<MarkerAnnotationInfo.AnnotationInfo> high = new ArrayList<MarkerAnnotationInfo.AnnotationInfo>();
        ArrayList<MarkerAnnotationInfo.AnnotationInfo> low = new ArrayList<MarkerAnnotationInfo.AnnotationInfo>();
        IAnnotationModel model = invocationContext.getSourceViewer().getAnnotationModel();
        if (model != null) {
            Iterator iterator = model.getAnnotationIterator();
            while (iterator.hasNext()) {
                Position position;
                Annotation annotation = (Annotation)iterator.next();
                if (!this.canFix(annotation) || !(position = model.getPosition(annotation)).overlapsWith(invocationContext.getOffset(), 1)) continue;
                MarkerAnnotationInfo.AnnotationInfo info = new MarkerAnnotationInfo.AnnotationInfo(annotation, position);
                if (info.isTop()) {
                    high.add(info);
                    continue;
                }
                low.add(info);
            }
            all.addAll(high);
            all.addAll(low);
        }
        MarkerAnnotationInfo mai = new MarkerAnnotationInfo(all, invocationContext.getSourceViewer());
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (MarkerAnnotationInfo.AnnotationInfo info : all) {
            List maiProposals = mai.getCompletionProposals(info);
            for (ICompletionProposal proposal : maiProposals) {
                if (proposals.contains(proposal)) continue;
                proposals.add(proposal);
            }
        }
        return proposals.toArray(new ICompletionProposal[0]);
    }
}

