/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.v7.AbstractJBoss7ModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public class JBoss7ModuleStateVerifier
extends AbstractJBoss7ModuleStateVerifier
implements IModuleStateController,
IServerModuleStateVerifier {
    @Override
    protected int getRootModuleState(IServer server, IModule root, String deploymentName, IProgressMonitor monitor) throws Exception {
        IJBoss7ManagerService service = JBoss7ManagerUtil.getService((IServer)server);
        AS7ManagementDetails details = new AS7ManagementDetails(server);
        int ret = 0;
        if (service.isRunning((IAS7ManagementDetails)details)) {
            JBoss7DeploymentState state = service.getDeploymentState((IAS7ManagementDetails)details, deploymentName);
            if (state == JBoss7DeploymentState.STARTED) {
                return 2;
            }
            if (state == JBoss7DeploymentState.STOPPED) {
                return 4;
            }
        }
        return ret;
    }

    @Override
    public int changeModuleStateTo(IModule[] module, int state, IProgressMonitor monitor) throws CoreException {
        AS7ManagementDetails details = new AS7ManagementDetails(this.getServer());
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.getServer());
        IModuleDeployPathController controller = (IModuleDeployPathController)beh.getController("moduleDeployPath");
        String deploymentName = controller.getOutputName(module);
        try {
            IJBoss7ManagerService service = JBoss7ManagerUtil.getService((IServer)this.getServer());
            if (service == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Management service for server not found."));
            }
            if (state == 2) {
                service.deploySync((IAS7ManagementDetails)details, deploymentName, null, false, monitor);
            } else if (state == 4) {
                service.undeploySync((IAS7ManagementDetails)details, deploymentName, false, monitor);
            } else {
                throw new IllegalArgumentException("Only states IServer.STATE_STARTED and IServer.STATE_STOPPED are supported");
            }
            return state;
        }
        catch (JBoss7ManangerException j7me) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", j7me.getMessage(), (Throwable)j7me));
        }
    }
}

