/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.ui.buildpath.dialog;

import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.jdt.core.buildpath.ClasspathContainersHelper;
import org.jboss.tools.common.jdt.ui.Messages;
import org.jboss.tools.common.jdt.ui.buildpath.dialog.IMaterializeLibraryWarningFactory;

public class MaterializeLibraryWarningFactory
implements IMaterializeLibraryWarningFactory {
    @Override
    public String getWarning(IClasspathContainer classpathLibrary) {
        if (this.isMavenLibrary(classpathLibrary)) {
            return Messages.Maven_Configuration_Warning;
        }
        if (this.isJreLibrary(classpathLibrary)) {
            return NLS.bind((String)Messages.Jre_Warning, (Object)classpathLibrary.getDescription());
        }
        if (this.isGradleLibrary(classpathLibrary)) {
            return Messages.Gradle_Configuration_Warning;
        }
        return null;
    }

    @Override
    public String getDialogWarning(IClasspathContainer classpathLibrary) {
        if (this.isMavenLibrary(classpathLibrary)) {
            return Messages.Maven_Configuration_Dialog_Warning;
        }
        if (this.isJreLibrary(classpathLibrary)) {
            return NLS.bind((String)Messages.Jre_Dialog_Warning, (Object)classpathLibrary.getDescription());
        }
        if (this.isGradleLibrary(classpathLibrary)) {
            return Messages.Gradle_Configuration_Dialog_Warning;
        }
        return null;
    }

    private boolean isJreLibrary(IClasspathContainer classpathLibrary) {
        return ClasspathContainersHelper.applies((IClasspathContainer)classpathLibrary, (String)"org.eclipse.jdt.launching.JRE_CONTAINER");
    }

    private boolean isMavenLibrary(IClasspathContainer classpathLibrary) {
        return ClasspathContainersHelper.applies((IClasspathContainer)classpathLibrary, (String)"org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER");
    }

    private boolean isGradleLibrary(IClasspathContainer classpathLibrary) {
        return ClasspathContainersHelper.applies((IClasspathContainer)classpathLibrary, (String)"com.springsource.sts.gradle.classpathcontainer");
    }
}

