/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.expressions;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.foundation.core.expressions.ExpressionResolutionException;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;

public class ExpressionResolver {
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int ARGUMENT = 4;
    private IVariableResolver resolver;

    public ExpressionResolver() {
        this(new SystemPropertiesVariableResolver());
    }

    public ExpressionResolver(Map<String, ? extends Object> map) {
        this(new MapVariableResolver(map));
    }

    public ExpressionResolver(Properties props) {
        this(new PropertiesVariableResolver(props));
    }

    public ExpressionResolver(IVariableResolver resolver) {
        this.resolver = resolver;
    }

    public String resolveIgnoreErrors(String value) {
        try {
            return this.resolve(value);
        }
        catch (ExpressionResolutionException expressionResolutionException) {
            return value;
        }
    }

    public String resolve(String value) throws ExpressionResolutionException {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = value.length();
        int state = 0;
        int start = -1;
        int nest = 0;
        int nameStart = -1;
        int nameEnd = -1;
        String resolvedValue = null;
        int i = 0;
        while (i < len) {
            int ch = value.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 36: {
                            builder.appendCodePoint(ch);
                            state = 0;
                            break block0;
                        }
                        case 123: {
                            nameStart = start = i + 1;
                            nameEnd = start;
                            state = 2;
                            break block0;
                        }
                    }
                    builder.append('$').appendCodePoint(ch);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 123: {
                            ++nest;
                            break;
                        }
                        case 44: 
                        case 58: 
                        case 125: {
                            String val2;
                            if (nest > 0) {
                                if (ch != 125) break block0;
                                --nest;
                                break;
                            }
                            if (ch == 44) {
                                val2 = this.resolveVariable(value.substring(nameStart, i).trim(), null);
                                if (val2 != null) {
                                    builder.append(val2);
                                    resolvedValue = val2;
                                    state = ch == 125 ? 0 : 3;
                                    break;
                                }
                                nameStart = i + 1;
                                break;
                            }
                            if (ch == 58) {
                                nameEnd = i;
                                start = i + 1;
                                state = 4;
                                break;
                            }
                            val2 = this.resolveVariable(value.substring(nameStart, i).trim(), null);
                            if (val2 != null) {
                                builder.append(val2);
                                resolvedValue = val2;
                                state = ch == 125 ? 0 : 3;
                                break;
                            }
                            throw new ExpressionResolutionException("Failed to resolve expression: " + value.substring(start - 2, i + 1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (ch == 123) {
                        ++nest;
                        break;
                    }
                    if (ch != 125) break;
                    if (nest > 0) {
                        --nest;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 4: {
                    if (ch == 123) {
                        ++nest;
                        break;
                    }
                    if (ch != 125) break;
                    if (nest > 0) {
                        --nest;
                        break;
                    }
                    state = 0;
                    String s1 = value.substring(nameStart, nameEnd);
                    String s2 = value.substring(start, i);
                    String val2 = this.resolveVariable(s1.trim(), s2);
                    if (val2 != null) {
                        builder.append(val2);
                        resolvedValue = val2;
                        state = ch == 125 ? 0 : 3;
                        break;
                    }
                    throw new ExpressionResolutionException("Failed to resolve expression: " + s1 + " with argument: " + s2);
                }
                default: {
                    throw new ExpressionResolutionException("Unexpected char seen: " + ch);
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        switch (state) {
            case 1: {
                builder.append('$');
                break;
            }
            case 4: {
                builder.append(value.substring(start - 2));
                break;
            }
            case 2: {
                if (resolvedValue != null) break;
                throw new ExpressionResolutionException("Incomplete expression: " + builder.toString());
            }
        }
        return builder.toString();
    }

    private String resolveVariable(String name, String argument) {
        return this.resolver.resolve(name, argument);
    }

    public static class MapVariableResolver
    implements IVariableResolver {
        private Map<String, ? extends Object> map;

        public MapVariableResolver(Map<String, ? extends Object> map) {
            this.map = map;
        }

        @Override
        public String resolve(String variable, String argument) {
            Object ret = this.map.get(variable);
            return ret == null ? argument : ret.toString();
        }
    }

    public static class PropertiesVariableResolver
    implements IVariableResolver {
        private Properties props;

        public PropertiesVariableResolver(Properties props) {
            this.props = props;
        }

        @Override
        public String resolve(String variable, String argument) {
            String ret = this.props.getProperty(variable);
            return ret == null ? argument : ret;
        }
    }

    public static class SystemPropertiesVariableResolver
    implements IVariableResolver {
        @Override
        public String resolve(String variable, String argument) {
            String ret = this.resolvePart(variable);
            return ret == null ? argument : ret;
        }

        private String resolvePart(String name) {
            if ("/".equals(name)) {
                return File.separator;
            }
            if (":".equals(name)) {
                return File.pathSeparator;
            }
            String val = System.getProperty(name);
            if (val == null && name.startsWith("env.")) {
                val = System.getenv(name.substring(4));
            }
            return val;
        }
    }
}

