/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.IValidator;

public class ValidatorFactory {
    public static final String DEFAULT_SOURCE_LEVEL = "1.5";
    public static final String DEFAULT_COMPLIANCE_LEVEL = "1.5";
    public static Map<String, IValidator> validators = new HashMap<String, IValidator>();
    public static final Map<String, IStatus> NO_ERRORS = Collections.unmodifiableMap(new HashMap());
    public static IValidator NO_ERRORS_VALIDATOR = new IValidator(){

        @Override
        public Map<String, IStatus> validate(Object value, Object context) {
            return NO_ERRORS;
        }
    };
    public static final IValidator FILE_SYSTEM_FOLDER_EXISTS = new IValidator(){

        @Override
        public Map<String, IStatus> validate(Object value, Object context) {
            if (value == null) {
                throw new IllegalArgumentException(CommonUIMessages.VALIDATOR_FACTORY_PATH_TO_A_FOLDER_CANNOT_BE_NULL);
            }
            String folderPath = value.toString();
            File folder = new File(folderPath);
            if (!folder.exists()) {
                return ValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.common.ui", NLS.bind((String)CommonUIMessages.VALIDATOR_FACTORY_FOLDER_DOES_NOT_EXIST, (Object)folderPath)));
            }
            if (!folder.isDirectory()) {
                return ValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.common.ui", NLS.bind((String)CommonUIMessages.VALIDATOR_FACTORY_PATH_POINTS_TO_FILE, (Object)folderPath)));
            }
            return NO_ERRORS;
        }
    };

    public static IValidator getValidator(String id) {
        IValidator validator = validators.get(id);
        return validator == null ? NO_ERRORS_VALIDATOR : validator;
    }

    public static Map<String, IStatus> createErrorMap() {
        return new HashMap<String, IStatus>();
    }

    public static Map<String, IStatus> createErrormessage(IStatus message) {
        Map<String, IStatus> map = ValidatorFactory.createErrorMap();
        map.put("default.error", message);
        return map;
    }

    public static Map<String, IStatus> createErrormessage(String propertyName, IStatus message) {
        Map<String, IStatus> map = ValidatorFactory.createErrorMap();
        map.put(propertyName, message);
        return map;
    }

    public static String getCompilerSourceLevel(IJavaProject jProject) {
        if (jProject == null) {
            return "1.5";
        }
        String sourceLevel = jProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        return sourceLevel != null ? sourceLevel : "1.5";
    }

    public static String getCompilerComplianceLevel(IJavaProject jProject) {
        if (jProject == null) {
            return "1.5";
        }
        String compliance = jProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return compliance != null ? compliance : "1.5";
    }
}

