/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.runtime.core.model.RuntimePath;

public class RuntimeDefinition {
    private String name;
    private String version;
    private String type;
    private File location;
    private String description;
    private boolean enabled = true;
    private RuntimePath runtimePath;
    private List<RuntimeDefinition> includedRuntimeDefinitions = new ArrayList<RuntimeDefinition>();
    private RuntimeDefinition parent;

    public RuntimeDefinition(String name, String version, String type, File location) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.location = location;
        this.description = "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeDefinition other = (RuntimeDefinition)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "RuntimeDefinition [name=" + this.name + ", version=" + this.version + ", type=" + this.type + ", location=" + this.location + "]";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RuntimePath getRuntimePath() {
        return this.runtimePath;
    }

    public void setRuntimePath(RuntimePath runtimePath) {
        this.runtimePath = runtimePath;
    }

    public List<RuntimeDefinition> getIncludedRuntimeDefinitions() {
        return this.includedRuntimeDefinitions;
    }

    public RuntimeDefinition getParent() {
        return this.parent;
    }

    public void setParent(RuntimeDefinition parent) {
        this.parent = parent;
    }
}

