/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.jboss.tools.arquillian.editor.internal.model.Container;
import org.jboss.tools.arquillian.editor.internal.refactoring.AddProfilesRefactoring;
import org.jboss.tools.arquillian.editor.internal.refactoring.AddProfilesWizard;
import org.jboss.tools.arquillian.editor.internal.services.ContainerProfilesService;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.markers.RefactoringUtil;

public final class AddProfilesActionContributor
extends PropertyEditorAssistContributor {
    public void contribute(PropertyEditorAssistContext context) {
        String id;
        IProject project;
        Element element = context.getPart().getLocalModelElement();
        if (element instanceof Container && !ContainerProfilesService.testProfile(project = (IProject)element.adapt(IProject.class), id = ((Container)element).getQualifier().text())) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">Add required profiles...</a></p>");
            contribution.link("action", new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> profiles = new ArrayList<String>();
                    profiles.add(id);
                    AddProfilesRefactoring refactoring = new AddProfilesRefactoring(project, profiles);
                    AddProfilesWizard wizard = new AddProfilesWizard(refactoring);
                    RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                    try {
                        operation.run(RefactoringUtil.getShell(), "");
                    }
                    catch (InterruptedException e) {
                        ArquillianUIActivator.log(e);
                    }
                }
            });
            PropertyEditorAssistSection section = context.getSection("problems");
            section.addContribution(contribution.create());
        }
    }
}

