/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.profiles.core.internal.MavenProfilesCoreActivator;
import org.eclipse.m2e.profiles.core.internal.ProfileData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.maven.core.IArtifactResolutionService;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArquillianUtility {
    public static final String ARQUILLIAN_VERSION = "version.arquillian_core";
    public static final String ARQUILLIAN_CORE_GROUP_ID = "org.jboss.arquillian.core";
    public static final String ARQUILLIAN_CORE_API_ARTIFACT_ID = "arquillian-core-api";
    public static final String ARQUILLIAN_GROUP_ID = "org.jboss.arquillian";
    public static final String ARQUILLIAN_BOM_ARTIFACT_ID = "arquillian-bom";
    public static final String ARQUILLIAN_JUNIT_POM_URL = "platform:/plugin/org.jboss.tools.arquillian.core/poms/arquillian-pom-junit.xml";
    public static final String ARQUILLIAN_TESTNG_POM_URL = "platform:/plugin/org.jboss.tools.arquillian.core/poms/arquillian-pom-testng.xml";
    public static final String ARQUILLIAN_PROFILE_POM_URL = "platform:/plugin/org.jboss.tools.arquillian.core/poms/arquillian-pom-profiles.xml";
    public static final String MAVEN_COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
    public static final String MAVEN_GROUP_ID = "org.apache.maven.plugins";
    public static final String MAVEN_COMPILER_VERSION = "2.5.1";
    public static final String MAVEN_COMPILER_SOURCE_NODE = "source";
    public static final String MAVEN_COMPILER_TARGET_NODE = "target";
    public static final String MAVEN_COMPILER_SOURCE_LEVEL = "1.6";
    public static final String MAVEN_COMPILER_TARGET_LEVEL = "1.6";
    public static final String ORG_JBOSS_ARQUILLIAN_CONTAINER_TEST_API_DEPLOYMENT = "org.jboss.arquillian.container.test.api.Deployment";
    public static final String SIMPLE_TEST_INTERFACE_NAME = "Test";
    public static final String TEST_INTERFACE_NAME = "junit.framework.Test";
    public static final String ORG_JBOSS_SHRINKWRAP_API_SPEC_WEB_ARCHIVE = "org.jboss.shrinkwrap.api.spec.WebArchive";
    public static final String ORG_JBOSS_SHRINKWRAP_API_SPEC_JAVA_ARCHIVE = "org.jboss.shrinkwrap.api.spec.JavaArchive";
    public static final String ORG_JBOSS_SHRINKWRAP_API_SPEC_ENTERPRISE_ARCHIVE = "org.jboss.shrinkwrap.api.spec.EnterpriseArchive";
    public static final String ORG_JBOSS_SHRINKWRAP_API_SPEC_RESOURCEADAPTER_ARCHIVE = "org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive";
    public static final String ARQUILLIAN_BUILDER_ID = "org.jboss.tools.arquillian.core.arquillianBuilder";
    public static final String ARQUILLIAN_BOM_COORDS = "org.jboss.arquillian:arquillian-bom:[0,)";

    public static String getDependencyVersion(MavenProject mavenProject, String gid, String aid) {
        List<Artifact> artifacts = ArquillianUtility.getArtifacts(mavenProject);
        for (Artifact artifact : artifacts) {
            String artifactId;
            String groupId = artifact.getGroupId();
            if (groupId == null || !groupId.equals(gid) || (artifactId = artifact.getArtifactId()) == null || !artifactId.equals(aid)) continue;
            return artifact.getVersion();
        }
        return null;
    }

    private static List<Artifact> getArtifacts(MavenProject mavenProject) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("test");
        for (Artifact artifact : mavenProject.getArtifacts()) {
            if (!filter.include(artifact)) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public static URL getArquillianPomFile(boolean isJUnit) {
        try {
            URL url = isJUnit ? new URL(ARQUILLIAN_JUNIT_POM_URL) : new URL(ARQUILLIAN_TESTNG_POM_URL);
            return FileLocator.resolve((URL)url);
        }
        catch (MalformedURLException e) {
            ArquillianCoreActivator.log(e);
            return null;
        }
        catch (IOException e) {
            ArquillianCoreActivator.log(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model getArquilianModel(boolean isJunit) throws CoreException {
        Model model;
        URL url = ArquillianUtility.getArquillianPomFile(true);
        InputStream in = null;
        try {
            in = url.openStream();
            model = MavenPlugin.getMaven().readModel(in);
            if (in == null) return model;
        }
        catch (IOException e) {
            try {
                ArquillianCoreActivator.log(e);
                Status status = new Status(4, "org.jboss.tools.arquillian.core", e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return model;
        }
        catch (IOException iOException) {}
        return model;
    }

    public static boolean managedDependencyExists(Dependency dependency, List<Dependency> allDependencies) {
        String gid = dependency.getGroupId();
        String aid = dependency.getArtifactId();
        for (Dependency dep : allDependencies) {
            String groupId = dep.getGroupId();
            if ((gid != null || groupId != null) && (groupId == null || !groupId.equals(gid))) continue;
            String artifactId = dep.getArtifactId();
            if ((aid != null || artifactId != null) && (artifactId == null || !artifactId.equals(aid))) continue;
            return true;
        }
        return false;
    }

    public static void addManagedDependencies(List<Dependency> allDependencies, String groupId, String artifactId, String version) throws CoreException {
        Parent parent;
        Model model = ArquillianUtility.getModel(groupId, artifactId, version);
        if (model == null) {
            return;
        }
        DependencyManagement dependencyMgmt = model.getDependencyManagement();
        if (dependencyMgmt == null) {
            return;
        }
        List dependencies = dependencyMgmt.getDependencies();
        if (dependencies != null) {
            allDependencies.addAll(dependencies);
        }
        if ((parent = model.getParent()) != null) {
            ArquillianUtility.addManagedDependencies(allDependencies, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }
    }

    private static Element getOrCreateElement(Element parent, String name) {
        return ArquillianUtility.getOrCreateElement(parent, name, false);
    }

    private static Element getOrCreateElement(Element parent, String name, boolean format) {
        Element element = PomEdits.findChild((Element)parent, (String)name);
        if (element == null) {
            element = PomEdits.createElement((Element)parent, (String)name);
            if (format) {
                PomEdits.format((Node)element);
            }
        }
        return element;
    }

    public static boolean pluginExists(IDOMModel model, Plugin plugin) throws CoreException {
        if (model == null) {
            return false;
        }
        Element pluginEl = ArquillianUtility.getPomPlugin(model, plugin.getGroupId(), plugin.getArtifactId());
        return pluginEl != null;
    }

    private static boolean pluginExists(Model model, Plugin plugin) throws CoreException {
        if (model == null) {
            return false;
        }
        Build build = model.getBuild();
        if (build != null) {
            List plugins = build.getPlugins();
            String gid = plugin.getGroupId();
            if (gid == null) {
                gid = MAVEN_GROUP_ID;
            }
            String aid = plugin.getArtifactId();
            for (Plugin p : plugins) {
                String agid = p.getGroupId();
                if (agid == null) {
                    agid = MAVEN_GROUP_ID;
                }
                if (!agid.equals(gid) || aid == null || !aid.equals(p.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static IStatus addProfiles(IFile pomFile, List<Container> selectedContainers, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getProfiles(Model projectModel) throws CoreException {
        ArrayList<String> allProfiles = new ArrayList<String>();
        Settings settings = MavenPlugin.getMaven().getSettings();
        List settingsProfiles = settings.getProfiles();
        for (Profile profile : settingsProfiles) {
            allProfiles.add(profile.getId());
        }
        List projectProfiles = projectModel.getProfiles();
        for (org.apache.maven.model.Profile profile : projectProfiles) {
            allProfiles.add(profile.getId());
        }
        Parent parent = projectModel.getParent();
        if (parent != null) {
            ArquillianUtility.addProfiles(allProfiles, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }
        return allProfiles;
    }

    private static void addProfiles(List<String> allProfiles, String groupId, String artifactId, String version) throws CoreException {
        Model model = ArquillianUtility.getModel(groupId, artifactId, version);
        if (model == null) {
            return;
        }
        List profiles = model.getProfiles();
        for (org.apache.maven.model.Profile profile : profiles) {
            allProfiles.add(profile.getId());
        }
        Parent parent = model.getParent();
        if (parent != null) {
            ArquillianUtility.addProfiles(allProfiles, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }
    }

    private static Model getModel(String groupId, String artifactId, String version) throws CoreException {
        Model model;
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(groupId, artifactId, version);
        if (facade != null) {
            model = facade.getMavenProject().getModel();
        } else {
            List repos;
            IMaven maven = MavenPlugin.getMaven();
            Artifact artifact = maven.resolve(groupId, artifactId, version, "pom", null, repos = maven.getArtifactRepositories(), (IProgressMonitor)new NullProgressMonitor());
            File file = artifact.getFile();
            if (file == null) {
                return null;
            }
            model = maven.readModel(file);
        }
        return model;
    }

    public static void updateProject(IProject project) {
        if (project != null && project.isAccessible()) {
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            UpdateMavenProjectJob updateJob = new UpdateMavenProjectJob(project);
            updateJob.schedule();
        }
    }

    public static void fixCompilerPlugin(Element compiler) {
        if (compiler != null) {
            Element source;
            Element configuration = PomEdits.findChild((Element)compiler, (String)"configuration");
            if (configuration == null) {
                configuration = PomEdits.createElement((Element)compiler, (String)"configuration");
            }
            if ((source = PomEdits.findChild((Element)configuration, (String)MAVEN_COMPILER_SOURCE_NODE)) == null) {
                PomEdits.createElementWithText((Element)configuration, (String)MAVEN_COMPILER_SOURCE_NODE, (String)"1.6");
            } else {
                String originalValue = source.getTextContent();
                if (originalValue.compareTo("1.6") < 0) {
                    PomEdits.setText((Element)source, (String)"1.6");
                }
            }
            Element target = PomEdits.findChild((Element)configuration, (String)MAVEN_COMPILER_TARGET_NODE);
            if (target == null) {
                PomEdits.createElementWithText((Element)configuration, (String)MAVEN_COMPILER_TARGET_NODE, (String)"1.6");
            } else {
                String originalValue = target.getTextContent();
                if (originalValue.compareTo("1.6") < 0) {
                    PomEdits.setText((Element)target, (String)"1.6");
                }
            }
            PomEdits.format((Node)configuration);
        }
    }

    private static Element getPomPlugin(IDOMModel model, String groupId, String artifactId) {
        IDOMDocument document;
        Element element;
        Element build;
        if (groupId == null) {
            groupId = MAVEN_GROUP_ID;
        }
        if ((build = PomEdits.findChild((Element)(element = (document = model.getDocument()).getDocumentElement()), (String)"build")) != null) {
            Element pluginsNode = PomEdits.findChild((Element)build, (String)"plugins");
            List plugins = PomEdits.findChilds((Element)pluginsNode, (String)"plugin");
            for (Element plugin : plugins) {
                String gid;
                Element pluginArtifactId = PomEdits.findChild((Element)plugin, (String)"artifactId");
                String aid = PomEdits.getTextValue((Node)pluginArtifactId);
                Element pluginGroupId = PomEdits.findChild((Element)plugin, (String)"groupId");
                String string = gid = pluginGroupId == null ? MAVEN_GROUP_ID : PomEdits.getTextValue((Node)pluginGroupId);
                if (!artifactId.equals(aid) || !groupId.equals(gid)) continue;
                return plugin;
            }
        }
        return null;
    }

    public static Object newInstance(IJavaProject javaProject, String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader loader = ArquillianCoreActivator.getDefault().getClassLoader(javaProject);
        Class<?> clazz = Class.forName(name, true, loader);
        Object object = clazz.newInstance();
        return object;
    }

    public static boolean deleteFile(File path) {
        if (path.exists()) {
            File[] files;
            if (!path.isDirectory()) {
                return path.delete();
            }
            File[] fileArray = files = path.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ArquillianUtility.deleteFile(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return path.delete();
    }

    public static String getPreference(String name) {
        return ArquillianUtility.getPreference(name, null, null);
    }

    public static String getPreference(String name, String defaultValue) {
        return ArquillianUtility.getPreference(name, defaultValue, null);
    }

    public static String getPreference(String name, IProject project) {
        return ArquillianUtility.getPreference(name, null, project);
    }

    public static String getPreference(String name, String defaultValue, IProject project) {
        IEclipsePreferences[] preferencesLookup = project != null ? new IEclipsePreferences[]{new ProjectScope(project).getNode("org.jboss.tools.arquillian.core"), InstanceScope.INSTANCE.getNode("org.jboss.tools.arquillian.core"), DefaultScope.INSTANCE.getNode("org.jboss.tools.arquillian.core")} : new IEclipsePreferences[]{InstanceScope.INSTANCE.getNode("org.jboss.tools.arquillian.core"), DefaultScope.INSTANCE.getNode("org.jboss.tools.arquillian.core")};
        IPreferencesService service = Platform.getPreferencesService();
        String value = service.get(name, defaultValue, (Preferences[])preferencesLookup);
        return value;
    }

    public static boolean validateDeploymentMethod(IProject project) {
        String preference = ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.missingDeploymentMethod", project);
        return !"ignore".equals(preference);
    }

    public static boolean validateArchiveName(IProject project) {
        String preference = ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.invalidArchiveName", project);
        return !"ignore".equals(preference);
    }

    public static boolean validateTestMethod(IProject project) {
        String preference = ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.missingTestMethod", project);
        return !"ignore".equals(preference);
    }

    public static boolean isValidatorEnabled(IProject project) {
        if (!ArquillianUtility.isArquillianProject(project)) {
            return false;
        }
        String preference = ArquillianUtility.getPreference("enableArquillianValidator", project);
        return Boolean.TRUE.toString().equals(preference);
    }

    public static boolean isArquillianProject(IProject project) {
        try {
            return project != null && project.hasNature("org.jboss.tools.arquillian.core.arquillianNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static Integer getSeverity(String preference) {
        if ("warning".equals(preference)) {
            return new Integer(1);
        }
        if ("error".equals(preference)) {
            return new Integer(2);
        }
        return null;
    }

    public static String[] getVersions(String[] defaultVersions) {
        List versions = null;
        try {
            IArtifactResolutionService artifactResolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
            List artifactRepositories = MavenPlugin.getMaven().getArtifactRepositories();
            versions = artifactResolutionService.getAvailableReleasedVersions(ARQUILLIAN_BOM_COORDS, artifactRepositories, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ArquillianCoreActivator.log(e);
        }
        if (versions == null || versions.isEmpty()) {
            return defaultVersions;
        }
        String[] versionsArray = new String[versions.size()];
        versions.toArray(versionsArray);
        return versionsArray;
    }

    public static String getHighestVersion(String coords) {
        try {
            IArtifactResolutionService artifactResolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
            List artifactRepositories = MavenPlugin.getMaven().getArtifactRepositories();
            return artifactResolutionService.getLatestReleasedVersion(coords, artifactRepositories, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ArquillianCoreActivator.log(e);
            return null;
        }
    }

    public static List<String> getProfilesFromPreferences(String preference) {
        String[] profiles;
        ArrayList<String> selectedProfiles = new ArrayList<String>();
        String prefs = ArquillianUtility.getPreference(preference);
        if (prefs == null) {
            return selectedProfiles;
        }
        String[] stringArray = profiles = prefs.split(",");
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            String profile = stringArray[n2];
            if (profile != null && !profile.trim().isEmpty()) {
                selectedProfiles.add(profile.trim());
            }
            ++n2;
        }
        return selectedProfiles;
    }

    public static IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        if (configuration == null) {
            return null;
        }
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        if (projectName == null || projectName.isEmpty()) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return null;
        }
        return JavaCore.create((IProject)project);
    }

    public static void runAction(ILaunchConfiguration configuration, String actionId, boolean select) {
        try {
            IHandlerService handler = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
            if (select) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView("org.eclipse.jdt.ui.PackageExplorer");
                ISelectionProvider provider = page.getActivePart().getSite().getSelectionProvider();
                provider.setSelection((ISelection)new StructuredSelection((Object)ArquillianUtility.getJavaProject(configuration)));
            }
            handler.executeCommand(actionId, null);
        }
        catch (Exception e1) {
            ArquillianCoreActivator.log(e1);
            MessageDialog.openConfirm((Shell)ArquillianUtility.getShell(), (String)"Error", (String)e1.getMessage());
        }
    }

    public static Shell getShell() {
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        return shell;
    }

    public static List<String> getProfiles(IProject project) {
        ArrayList<String> profiles = new ArrayList<String>();
        List<ProfileData> profileStatuses = ArquillianUtility.getProfileStatuses(project);
        if (profileStatuses != null) {
            for (ProfileData profileStatus : profileStatuses) {
                profiles.add(profileStatus.getId());
            }
        }
        return profiles;
    }

    public static List<ProfileData> getProfileStatuses(IProject project) {
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
        List profileStatuses = null;
        try {
            profileStatuses = MavenProfilesCoreActivator.getDefault().getProfileManager().getProfileDatas(facade, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ArquillianCoreActivator.log(e);
        }
        return profileStatuses;
    }

    public static void addArguments(ILaunchConfiguration configuration, String arguments, boolean save) throws CoreException {
        String vmArguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        if (!vmArguments.contains(arguments)) {
            String newArguments = vmArguments.trim().length() > 0 ? String.valueOf(vmArguments) + " " + arguments : arguments;
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, newArguments);
            if (save) {
                wc.doSave();
            }
        }
    }

    public static void addArquillianNature(IProject project) throws CoreException {
        Assert.isNotNull((Object)project);
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = "org.jboss.tools.arquillian.core.arquillianNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        ArquillianUtility.addBuilder(project);
    }

    public static void addBuilder(IProject project) {
        if (project == null) {
            return;
        }
        int javaIndex = -1;
        int arquillianIndex = -1;
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands != null) {
                int i = 0;
                while (i < commands.length) {
                    ICommand command = commands[i];
                    String builderName = command.getBuilderName();
                    if (builderName != null) {
                        if (builderName.equals(ARQUILLIAN_BUILDER_ID)) {
                            arquillianIndex = i;
                        }
                        if (builderName.equals("org.eclipse.jdt.core.javabuilder")) {
                            javaIndex = i;
                        }
                    }
                    ++i;
                }
            }
            if (arquillianIndex > -1 && javaIndex > arquillianIndex) {
                ArquillianUtility.removeBuilder(project);
                arquillianIndex = -1;
                description = project.getDescription();
                commands = description.getBuildSpec();
            }
            if (arquillianIndex == -1) {
                ICommand newCommand = description.newCommand();
                newCommand.setBuilderName(ARQUILLIAN_BUILDER_ID);
                ICommand[] newCommands = null;
                if (commands != null) {
                    newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 0, commands.length);
                    newCommands[commands.length] = newCommand;
                } else {
                    newCommands = new ICommand[]{newCommand};
                }
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public static void removeArquillianSupport(IProject project) throws CoreException {
        if (project == null || !project.hasNature("org.jboss.tools.arquillian.core.arquillianNature")) {
            return;
        }
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length - 1];
        int i = 0;
        String[] stringArray = prevNatures;
        int n = prevNatures.length;
        int n2 = 0;
        while (n2 < n) {
            String prevNature = stringArray[n2];
            if (!"org.jboss.tools.arquillian.core.arquillianNature".equals(prevNature)) {
                newNatures[i] = prevNature;
                ++i;
            }
            ++n2;
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        ArquillianUtility.removeBuilder(project);
    }

    private static void removeBuilder(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands != null) {
                ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
                boolean builderAdded = false;
                int i = 0;
                while (i < commands.length) {
                    ICommand command = commands[i];
                    String builderName = command.getBuilderName();
                    if (builderName.equals(ARQUILLIAN_BUILDER_ID)) {
                        builderAdded = true;
                    } else {
                        newCommands.add(command);
                    }
                    ++i;
                }
                if (builderAdded) {
                    description.setBuildSpec(newCommands.toArray(new ICommand[0]));
                    project.setDescription(description, null);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static boolean exportFile(File file, File destination) {
        ZipFile zipFile = null;
        destination.mkdirs();
        try {
            try {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) {
                        File dir = new File(destination, entry.getName());
                        dir.mkdirs();
                        continue;
                    }
                    File entryFile = new File(destination, entry.getName());
                    entryFile.getParentFile().mkdirs();
                    InputStream in = null;
                    FileOutputStream out = null;
                    try {
                        in = zipFile.getInputStream(entry);
                        out = new FileOutputStream(entryFile);
                        ArquillianUtility.copy(in, out);
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (out != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (out == null) continue;
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException e) {
                ArquillianCoreActivator.log(e);
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[16384];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    public static String getArquillianVersion(MavenProject mavenProject) {
        return ArquillianUtility.getDependencyVersion(mavenProject, ARQUILLIAN_CORE_GROUP_ID, ARQUILLIAN_CORE_API_ARTIFACT_ID);
    }

    private static class UpdateMavenProjectJob
    extends WorkspaceJob {
        private final IProject project;

        public UpdateMavenProjectJob(IProject project) {
            super("Updating Maven Project");
            this.project = project;
            this.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
            boolean autoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
            monitor.beginTask(this.getName(), 1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                MavenUpdateRequest request = new MavenUpdateRequest(this.project, true, false);
                configurationManager.updateProjectConfiguration(request, monitor);
                this.project.build(15, monitor);
                if (autoBuilding) {
                    this.project.build(6, monitor);
                }
            }
            catch (Exception e) {
                Status st = new Status(4, "org.jboss.tools.arquillian.core", e.getLocalizedMessage(), (Throwable)e);
                ArquillianCoreActivator.log(e);
                return st;
            }
            return Status.OK_STATUS;
        }
    }
}

