/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.container;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.osgi.framework.Bundle;

public class ContainerParser {
    private static final String CONTAINERS_JSON = "https://raw.github.com/forge/plugin-arquillian/master/src/main/resources/containers.json";
    private static final String PROTOCOL_FILE = "file";
    private static final String PROTOCOL_PLATFORM = "platform";
    private static List<Container> containers;

    public static void refresh() {
        containers = null;
    }

    public static List<Container> getContainers() {
        if (containers != null) {
            return containers;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        URL url = ContainerParser.getUrl();
        if (url != null) {
            try {
                containers = (List)objectMapper.readValue(url, (TypeReference)new TypeReference<List<Container>>(){});
            }
            catch (Exception e) {
                ArquillianCoreActivator.log(e);
            }
        }
        if (containers == null || containers.size() == 0) {
            try {
                containers = (List)objectMapper.readValue(ContainerParser.getUrlFromBundle(), (TypeReference)new TypeReference<List<Container>>(){});
                return containers;
            }
            catch (Exception e) {
                ArquillianCoreActivator.log(e);
            }
        }
        if (containers == null) {
            return Collections.emptyList();
        }
        return containers;
    }

    private static URL getUrl() {
        try {
            File f = ContainerParser.getFile(new URL(CONTAINERS_JSON), "containers", "json", (IProgressMonitor)new NullProgressMonitor());
            if (f == null || !f.exists()) {
                return ContainerParser.getUrlFromBundle();
            }
            return f.toURI().toURL();
        }
        catch (Exception e) {
            ArquillianCoreActivator.log(e);
            return null;
        }
    }

    private static URL getUrlFromBundle() {
        URL[] urls;
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.arquillian.core");
        if (bundle != null && (urls = FileLocator.findEntries((Bundle)bundle, (IPath)new Path("/containers.json"))) != null && urls.length > 0) {
            try {
                return FileLocator.resolve((URL)urls[0]);
            }
            catch (IOException e) {
                ArquillianCoreActivator.log(e);
            }
        }
        return null;
    }

    private static File getFile(URL url, String prefix, String suffix, IProgressMonitor monitor) {
        File file = null;
        if (PROTOCOL_FILE.equals(url.getProtocol()) || PROTOCOL_PLATFORM.equalsIgnoreCase(url.getProtocol())) {
            try {
                file = new File(new URI(url.toExternalForm()));
            }
            catch (Exception exception) {
                file = new File(url.getFile());
            }
            if (!file.exists()) {
                return null;
            }
        } else {
            long urlModified;
            block18: {
                boolean fileAlreadyExists;
                block17: {
                    long modified;
                    block16: {
                        block15: {
                            try {
                                if (!monitor.isCanceled()) break block15;
                                return null;
                            }
                            catch (FileNotFoundException e) {
                                ArquillianCoreActivator.log(e);
                                return null;
                            }
                        }
                        urlModified = -1L;
                        file = ContainerParser.getFile(url);
                        try {
                            urlModified = new URLTransportUtility().getLastModified(url);
                        }
                        catch (CoreException coreException) {
                            if (!file.exists()) break block16;
                            return file;
                        }
                    }
                    if (file.exists() && (modified = file.lastModified()) > 0L && urlModified == modified) {
                        return file;
                    }
                    fileAlreadyExists = file.exists();
                    file.getParentFile().mkdirs();
                    if (!monitor.isCanceled()) break block17;
                    return null;
                }
                BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(file));
                IStatus result = new URLTransportUtility().download(prefix, url.toExternalForm(), (OutputStream)destination, monitor);
                if (result.isOK()) break block18;
                ArquillianCoreActivator.getDefault().getLog().log(result);
                if (!fileAlreadyExists && file.exists()) {
                    file.delete();
                }
                return null;
            }
            if (file.exists() && urlModified > 0L) {
                file.setLastModified(urlModified);
            }
        }
        return file;
    }

    private static File getFile(URL url) {
        IPath location = ArquillianCoreActivator.getDefault().getStateLocation();
        File root = location.toFile();
        String urlFile = url.getFile();
        File file = new File(root, urlFile);
        return file;
    }
}

