/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.archives;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.archives.ArchiveLocation;
import org.jboss.tools.arquillian.core.internal.archives.Entry;
import org.jboss.tools.arquillian.core.internal.archives.IEntry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Archive
implements IEntry {
    public static final String ARCHIVE_ASSET = "ArchiveAsset";
    public static final String DIRECTORY = "Directory";
    public static final String PATH_SEPARATOR = "/";
    private static SAXParser parser;
    private String description;
    private ArchiveLocation location;
    private Set<IEntry> entries;
    private String name;
    private Set<String> fullyQuallifiedNames = new HashSet<String>();
    private IJavaProject javaProject;

    public Archive(String description, ArchiveLocation location, IJavaProject javaProject) {
        this.description = description;
        this.location = location;
        this.javaProject = javaProject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArchiveLocation getLocation() {
        return this.location;
    }

    public void setLocation(ArchiveLocation location) {
        this.location = location;
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (parser == null) {
            SAXParserFactory parserFactory = ArquillianCoreActivator.getDefault().getFactory();
            if (parserFactory == null) {
                return null;
            }
            parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/validation", false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
        }
        return parser;
    }

    @Override
    public Set<IEntry> getChildren() {
        if (this.entries == null) {
            try {
                this.entries = new LinkedHashSet<IEntry>();
                if (this.description != null && this.getParser() != null) {
                    this.getParser().parse(new InputSource(new StringReader(this.description)), (DefaultHandler)new Handler());
                }
            }
            catch (ParserConfigurationException e) {
                ArquillianCoreActivator.logWarning(e.getLocalizedMessage());
            }
            catch (SAXException e) {
                ArquillianCoreActivator.logWarning(e.getLocalizedMessage());
            }
            catch (IOException e) {
                ArquillianCoreActivator.logWarning(e.getLocalizedMessage());
            }
        }
        return this.entries;
    }

    @Override
    public String getName() {
        return String.valueOf(this.location.getMethodName()) + "(" + this.name + ")";
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IEntry getParent() {
        return null;
    }

    @Override
    public void add(IEntry entry) {
        this.getChildren().add(entry);
    }

    public Set<String> getFullyQuallifiedNames() {
        return this.fullyQuallifiedNames;
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Archive other = (Archive)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return "Archive [location=" + this.location + ", name=" + this.name + ", description=" + this.description + ", fullyQuallifiedNames=" + this.fullyQuallifiedNames + ", entries=" + this.entries + "]";
    }

    private class Handler
    extends DefaultHandler {
        private static final String WEB_INF_CLASSES = ".WEB-INF.classes.";
        private static final String EMPTY_STRING = "";
        private static final String PERIOD = ".";
        private static final String DOT_CLASS = ".class";
        private static final String CLASS_LOADER_ASSET = "ClassLoaderAsset";
        private static final String CLASS_ASSET = "ClassAsset";
        private static final String SOURCE = "source";
        private static final String PATH = "path";
        private static final String TYPE = "type";
        private static final String ASSET = "asset";
        private static final String NAME = "name";
        private static final String DEPLOYMENT = "deployment";
        private IEntry currentEntry;
        private IEntry currentArchive;
        private Map<String, IEntry> entriesByPath = new HashMap<String, IEntry>();
        private Map<String, IEntry> archiveEntriesByPath;
        private boolean inArchive = false;

        private Handler() {
        }

        @Override
        public void startElement(String uri, String elementName, String qualifiedName, Attributes attributes) throws SAXException {
            if (DEPLOYMENT.equals(elementName)) {
                Archive.this.name = attributes.getValue(NAME);
            } else if (ASSET.equals(elementName)) {
                if (this.currentArchive != null) {
                    this.inArchive = true;
                }
                String type = attributes.getValue(TYPE);
                String path = attributes.getValue(PATH);
                if (Archive.DIRECTORY.equals(type) && Archive.PATH_SEPARATOR.equals(path)) {
                    this.currentEntry = null;
                    return;
                }
                String source = attributes.getValue(SOURCE);
                if (path != null) {
                    String fqn = null;
                    if ((CLASS_ASSET.equals(type) || CLASS_LOADER_ASSET.equals(type)) && path.endsWith(DOT_CLASS) && !(fqn = path.replace(Archive.PATH_SEPARATOR, PERIOD)).isEmpty()) {
                        if (fqn.startsWith(WEB_INF_CLASSES)) {
                            fqn = fqn.substring(WEB_INF_CLASSES.length());
                        }
                        if ((fqn = fqn.replace(DOT_CLASS, EMPTY_STRING)).startsWith(PERIOD)) {
                            fqn = fqn.substring(1);
                        }
                        Archive.this.fullyQuallifiedNames.add(fqn);
                    }
                    Path parentPath = new Path(path);
                    parentPath = parentPath.removeLastSegments(1);
                    IEntry parent = this.currentArchive != null ? this.archiveEntriesByPath.get(parentPath.toString()) : this.entriesByPath.get(parentPath.toString());
                    if (parent == null) {
                        ArquillianCoreActivator.logWarning("Invalid parent: path=" + path);
                        parent = Archive.this;
                    }
                    this.currentEntry = new Entry(parent, type, path, source, Archive.this.javaProject, fqn);
                    parent.add(this.currentEntry);
                    if (Archive.ARCHIVE_ASSET.equals(type)) {
                        this.currentArchive = this.currentEntry;
                        this.archiveEntriesByPath = new HashMap<String, IEntry>();
                        this.archiveEntriesByPath.put(Archive.PATH_SEPARATOR, this.currentArchive);
                    }
                    if (Archive.DIRECTORY.equals(type)) {
                        if (this.inArchive) {
                            this.archiveEntriesByPath.put(path, this.currentEntry);
                        } else {
                            this.entriesByPath.put(path, this.currentEntry);
                        }
                    }
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.entriesByPath.put(Archive.PATH_SEPARATOR, Archive.this);
            this.currentArchive = null;
            this.archiveEntriesByPath = null;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ASSET.equals(localName)) {
                if (this.inArchive) {
                    this.inArchive = false;
                } else {
                    this.currentArchive = null;
                    this.archiveEntriesByPath = null;
                }
            }
        }
    }
}

