/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.ValidationResourceRegister;
import org.jboss.tools.common.validation.internal.ELValidatorContext;
import org.jboss.tools.common.validation.internal.LinkCollection;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;

public class ProjectValidationContext
implements IProjectValidationContext {
    private Map<String, LinkCollection> coreLinks = new HashMap<String, LinkCollection>();
    private ELValidatorContext elLinks = new ELValidatorContext("jboss.el");
    private Map<String, Set<String>> oldVariableNamesForELValidation = new HashMap<String, Set<String>>();
    private ValidationResourceRegister validationResourceRegister;

    public LinkCollection getCoreLinks(String validatorId) {
        LinkCollection linkCollection = this.coreLinks.get(validatorId);
        if (linkCollection == null) {
            linkCollection = new LinkCollection(validatorId);
            if (validatorId.equals("jboss.cdi.core")) {
                linkCollection.disableResourcesByVariableName();
            }
            this.coreLinks.put(validatorId, linkCollection);
        }
        return linkCollection;
    }

    private Set<String> getOldVariableNamesForELValidation(String validatorId) {
        Set<String> linkCollection = this.oldVariableNamesForELValidation.get(validatorId);
        if (linkCollection == null) {
            linkCollection = new HashSet<String>();
            this.oldVariableNamesForELValidation.put(validatorId, linkCollection);
        }
        return linkCollection;
    }

    private Set<String> getIds() {
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(this.coreLinks.keySet());
        ids.addAll(this.oldVariableNamesForELValidation.keySet());
        return ids;
    }

    @Override
    public void addLinkedCoreResource(String validatorId, String variableName, IPath linkedResourcePath, boolean declaration) {
        this.getCoreLinks(validatorId).addLinkedResource(variableName, linkedResourcePath, declaration);
    }

    @Override
    public void removeLinkedCoreResource(String validatorId, String name, IPath linkedResourcePath) {
        this.getCoreLinks(validatorId).removeLinkedResource(name, linkedResourcePath);
    }

    @Override
    public void removeLinkedCoreResources(String validatorId, Set<IPath> resources) {
        this.getCoreLinks(validatorId).removeLinkedResources(resources);
    }

    @Override
    public void removeLinkedCoreResource(String validatorId, IPath resource) {
        this.getCoreLinks(validatorId).removeLinkedResource(resource);
    }

    @Override
    public Set<IPath> getCoreResourcesByVariableName(String validatorId, String variableName, boolean declaration) {
        return this.getCoreLinks(validatorId).getResourcesByVariableName(variableName, declaration);
    }

    @Override
    public Set<String> getVariableNamesByCoreResource(String validatorId, IPath fullPath, boolean declaration) {
        return this.getCoreLinks(validatorId).getVariableNamesByResource(fullPath, declaration);
    }

    @Override
    public void addUnnamedCoreResource(String validatorId, IPath fullPath) {
        this.getCoreLinks(validatorId).addUnnamedResource(fullPath);
    }

    @Override
    public Set<IPath> getUnnamedCoreResources(String validatorId) {
        return this.getCoreLinks(validatorId).getUnnamedResources();
    }

    @Override
    public void removeUnnamedCoreResource(String validatorId, IPath fullPath) {
        this.getCoreLinks(validatorId).removeUnnamedResource(fullPath);
    }

    @Override
    public Set<IPath> getUnnamedElResources() {
        return this.elLinks.getUnnamedResources();
    }

    @Override
    public void removeUnnamedElResource(IPath fullPath) {
        this.elLinks.removeUnnamedResource(fullPath);
    }

    @Override
    public void addVariableNameForELValidation(String validatorId, String name) {
        this.getOldVariableNamesForELValidation(validatorId).add(name);
    }

    @Override
    public void removeLinkedEls(Set<IFile> resorces) {
        this.elLinks.removeLinkedEls(resorces);
    }

    @Override
    public Set<ELReference> getElsForValidation(Set<IFile> changedFiles, boolean onlyChangedVariables) {
        HashSet<ELReference> result = new HashSet<ELReference>();
        for (String id : this.getIds()) {
            Set<String> oldVariableNamesForELValidation = this.getOldVariableNamesForELValidation(id);
            for (IResource iResource : changedFiles) {
                Set<ELReference> els;
                Set<String> newNames = this.getVariableNamesByCoreResource(id, iResource.getFullPath(), true);
                if (newNames != null) {
                    for (String newName : newNames) {
                        Set<ELReference> els2;
                        if (onlyChangedVariables && (oldVariableNamesForELValidation == null || oldVariableNamesForELValidation.contains(newName)) || (els2 = this.elLinks.getElsByVariableName(newName)) == null) continue;
                        result.addAll(els2);
                    }
                }
                if ((els = this.elLinks.getElsByVariableName(iResource.getFullPath().toString())) != null) {
                    result.addAll(els);
                }
                if (oldVariableNamesForELValidation == null) continue;
                for (String oldName : oldVariableNamesForELValidation) {
                    if (onlyChangedVariables && newNames != null && newNames.contains(oldName) || (els = this.elLinks.getElsByVariableName(oldName)) == null) continue;
                    result.addAll(els);
                }
            }
        }
        return result;
    }

    @Override
    public void clearAll() {
        for (LinkCollection links : this.coreLinks.values()) {
            links.clearAll();
        }
        this.coreLinks.clear();
        this.elLinks.clearAll();
        this.oldVariableNamesForELValidation.clear();
    }

    @Override
    public void clearOldVariableNameForElValidation() {
        this.oldVariableNamesForELValidation.clear();
    }

    @Override
    public void addLinkedEl(String variableName, ELReference el) {
        this.elLinks.addLinkedEl(variableName, el);
    }

    @Override
    public void removeLinkedEl(String name, ELReference el) {
        this.elLinks.removeLinkedEl(name, el);
    }

    @Override
    public void removeLinkedEl(ELReference el) {
        this.elLinks.removeLinkedEl(el);
    }

    @Override
    public Set<ELReference> getElsByVariableName(String variableName) {
        return this.elLinks.getElsByVariableName(variableName);
    }

    @Override
    public void store(Element root) {
        HashMap<String, String> pathAliases = new HashMap<String, String>();
        Element validation = XMLUtilities.createElement((Element)root, (String)"validation");
        for (LinkCollection links : this.coreLinks.values()) {
            Element core = XMLUtilities.createElement((Element)validation, (String)"core");
            core.setAttribute("validator-id", links.getId());
            links.store(core, pathAliases);
        }
        Element el = XMLUtilities.createElement((Element)validation, (String)"el");
        this.elLinks.store(el, pathAliases);
        Element aliases = XMLUtilities.createElement((Element)root, (String)"aliases");
        for (String path : pathAliases.keySet()) {
            String value = (String)pathAliases.get(path);
            Element alias = XMLUtilities.createElement((Element)aliases, (String)"alias");
            alias.setAttribute("path", path);
            alias.setAttribute("value", value);
        }
    }

    @Override
    public void load(Element root) {
        Element[] els;
        Element[] cores;
        Element validation;
        int n;
        HashMap<String, String> pathAliases = new HashMap<String, String>();
        Element aliases = XMLUtilities.getUniqueChild((Element)root, (String)"aliases");
        if (aliases != null) {
            Element[] aliasArray;
            Element[] elementArray = aliasArray = XMLUtilities.getChildren((Element)aliases, (String)"alias");
            n = aliasArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element alias = elementArray[n2];
                String path = alias.getAttribute("path");
                String value = alias.getAttribute("value");
                pathAliases.put(value, path);
                ++n2;
            }
        }
        if ((validation = XMLUtilities.getUniqueChild((Element)root, (String)"validation")) == null) {
            return;
        }
        Element[] elementArray = cores = XMLUtilities.getChildren((Element)validation, (String)"core");
        int n3 = cores.length;
        n = 0;
        while (n < n3) {
            Element core = elementArray[n];
            String id = core.getAttribute("validator-id");
            if (id != null && id.trim().length() > 0) {
                this.getCoreLinks(id).load(core, pathAliases);
            }
            ++n;
        }
        Element[] elementArray2 = els = XMLUtilities.getChildren((Element)validation, (String)"el");
        int n4 = els.length;
        n3 = 0;
        while (n3 < n4) {
            Element el = elementArray2[n3];
            this.elLinks.load(el, pathAliases);
            ++n3;
        }
    }

    public int getModificationsSinceLastStore() {
        int result = 0;
        for (LinkCollection links : this.coreLinks.values()) {
            result += links.getModificationsSinceLastStore();
        }
        return result += this.elLinks.getModificationsSinceLastStore();
    }

    @Override
    public void setValidationResourceRegister(ValidationResourceRegister validationResourceRegister) {
        this.validationResourceRegister = validationResourceRegister;
    }

    @Override
    public ValidationResourceRegister getValidationResourceRegister() {
        return this.validationResourceRegister;
    }
}

