/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.DialogDef;
import org.eclipse.sapphire.ui.forms.DialogPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SapphireDialog
extends Dialog {
    private Element element;
    private DefinitionLoader.Reference<DialogDef> definition;
    private DialogPart part;
    private Button okButton;

    public SapphireDialog(Shell shell, Element element, DefinitionLoader.Reference<DialogDef> definition) {
        super(shell);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.definition = definition;
        this.part = new DialogPart();
        this.part.init(null, this.element, this.definition.resolve(), Collections.<String, String>emptyMap());
        this.part.initialize();
    }

    public final Element element() {
        return this.element;
    }

    public final DialogDef definition() {
        return this.definition.resolve();
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(this.part.getLabel());
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        final FormComponentPresentation presentation = this.part.createPresentation(null, innerComposite);
        presentation.render();
        String initialFocusProperty = (String)this.part.definition().getInitialFocus().content();
        if (initialFocusProperty != null) {
            this.part.setFocus(initialFocusProperty);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                presentation.dispose();
                SapphireDialog.this.element = null;
                SapphireDialog.this.part.dispose();
                SapphireDialog.this.part = null;
                SapphireDialog.this.definition.dispose();
                SapphireDialog.this.definition = null;
            }
        });
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        composite.setBackground(this.part.getSwtResourceCache().color(this.part.getBackgroundColor()));
        composite.setBackgroundMode(1);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.part.attach((Listener)new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                SapphireDialog.this.updateOkButtonEnablement();
            }
        });
        this.updateOkButtonEnablement();
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected final void okPressed() {
        DelayedTasksExecutor.sweep();
        if (this.part.validation().severity() == Status.Severity.ERROR) {
            return;
        }
        if (this.performOkOperation()) {
            super.okPressed();
        }
    }

    protected boolean performOkOperation() {
        return true;
    }

    private void updateOkButtonEnablement() {
        boolean actual;
        boolean expected;
        if (!this.okButton.isDisposed() && (expected = this.part.validation().severity() != Status.Severity.ERROR) != (actual = this.okButton.isEnabled())) {
            this.okButton.setEnabled(expected);
        }
    }
}

