/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import tern.ITernFileSynchronizer;
import tern.ITernProject;
import tern.TernException;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.ITernServerRequestProcessor;
import tern.server.SynchronousRequestProcessor;
import tern.server.TernServerAdapter;
import tern.server.protocol.ITernResultsCollector;
import tern.server.protocol.TernDoc;

public abstract class AbstractTernServer
implements ITernServer {
    private final ITernProject project;
    private final List<ITernServerListener> listeners;
    private boolean dataAsJsonString;
    private boolean dispose;
    private boolean loadingLocalPlugins;
    private ITernServerRequestProcessor reqProcessor;
    private ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();

    public AbstractTernServer(ITernProject project) {
        this.project = project;
        this.listeners = new ArrayList<ITernServerListener>();
        final ITernFileSynchronizer fileSynchronizer = this.getFileSynchronizer();
        if (fileSynchronizer != null) {
            this.addServerListener(new TernServerAdapter(){

                @Override
                public void onStop(ITernServer server) {
                    fileSynchronizer.cleanIndexedFiles();
                }
            });
        }
    }

    protected void beginReadState() {
        this.stateLock.readLock().lock();
    }

    protected void endReadState() {
        this.stateLock.readLock().unlock();
    }

    protected void beginWriteState() {
        this.stateLock.writeLock().lock();
    }

    protected void endWriteState() {
        this.stateLock.writeLock().unlock();
    }

    @Override
    public boolean isDataAsJsonString() {
        return this.dataAsJsonString;
    }

    @Override
    public void setDataAsJsonString(boolean dataAsJsonString) {
        this.dataAsJsonString = dataAsJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStartServer() {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            for (ITernServerListener listener : this.listeners) {
                listener.onStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndServer() {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            for (ITernServerListener listener : this.listeners) {
                listener.onStop(this);
            }
        }
    }

    @Override
    public final void dispose() {
        this.beginWriteState();
        try {
            if (!this.isDisposed()) {
                this.dispose = true;
                this.doDispose();
            }
        }
        finally {
            this.endWriteState();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.dispose;
    }

    protected abstract void doDispose();

    @Override
    public ITernFileSynchronizer getFileSynchronizer() {
        if (this.project != null) {
            return this.project.getFileSynchronizer();
        }
        return null;
    }

    public ITernProject getProject() {
        return this.project;
    }

    @Override
    public void addFile(String name, String text) {
        this.addFile(name, text, null);
    }

    @Override
    public void setLoadingLocalPlugins(boolean loadingLocalPlugins) {
        this.loadingLocalPlugins = loadingLocalPlugins;
    }

    @Override
    public boolean isLoadingLocalPlugins() {
        return this.loadingLocalPlugins;
    }

    @Override
    public void request(TernDoc doc, ITernResultsCollector collector) throws TernException {
        try {
            if (this.reqProcessor == null) {
                this.reqProcessor = new SynchronousRequestProcessor(this);
            }
            this.reqProcessor.processRequest(doc, collector);
        }
        catch (Exception e) {
            this.getFileSynchronizer().uploadFailed(doc);
            if (e instanceof TernException) {
                throw (TernException)e;
            }
            throw new TernException(e);
        }
    }

    @Override
    public ITernServerRequestProcessor getRequestProcessor() {
        return this.reqProcessor;
    }

    @Override
    public void setRequestProcessor(ITernServerRequestProcessor reqProcessor) {
        this.reqProcessor = reqProcessor;
    }
}

