/*
 * Decompiled with CFR 0.152.
 */
package tern.repository;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import tern.TernException;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.utils.TernModuleHelper;

public class TernRepository
implements ITernRepository {
    private static final String DEFS_FOLDER = "defs";
    private static final String PLUGIN_FOLDER = "plugin";
    private static final String NODE_MODULES_FOLDER = "node_modules";
    private final String name;
    private File ternBaseDir;
    private final boolean defaultRepository;
    private Map<String, ITernModule> modules;

    public TernRepository(String name, File ternBaseDir) {
        this(name, ternBaseDir, false);
    }

    public TernRepository(String name, File ternFile, boolean defaultRepository) {
        this.name = name;
        this.ternBaseDir = ternFile;
        this.defaultRepository = defaultRepository;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITernModule[] getModules() throws TernException {
        this.intializeIfNeeded();
        return this.modules.values().toArray(ITernModule.EMPTY_MODULE);
    }

    @Override
    public ITernModule getModule(String name) {
        try {
            this.intializeIfNeeded();
            return this.modules.get(name);
        }
        catch (TernException ternException) {
            return null;
        }
    }

    private void intializeIfNeeded() throws TernException {
        if (this.modules == null) {
            this.modules = this.loadModules();
        }
    }

    private Map<String, ITernModule> loadModules() throws TernException {
        HashMap<String, ITernModule> modules = new HashMap<String, ITernModule>();
        this.loadModules(modules, DEFS_FOLDER);
        this.loadModules(modules, PLUGIN_FOLDER);
        this.loadModules(modules, NODE_MODULES_FOLDER);
        return modules;
    }

    private void loadModules(Map<String, ITernModule> modules, String dir) throws TernException {
        File baseDir = new File(this.getTernBaseDir(), dir);
        if (baseDir.exists()) {
            File[] files = baseDir.listFiles();
            File file = null;
            ITernModule module = null;
            int i = 0;
            while (i < files.length) {
                file = files[i];
                module = TernModuleHelper.getModule(file.getName());
                if (module != null) {
                    modules.put(module.getName(), module);
                }
                ++i;
            }
        }
    }

    @Override
    public void refresh() {
        this.modules = null;
    }

    @Override
    public File getTernBaseDir() {
        return this.ternBaseDir;
    }

    @Override
    public String getTernBaseDirAsString() {
        return TernModuleHelper.getPath(this.getTernBaseDir());
    }

    @Override
    public void setTernBaseDir(File ternBaseDir) {
        this.ternBaseDir = ternBaseDir;
    }

    @Override
    public boolean isDefault() {
        return this.defaultRepository;
    }

    @Override
    public File getFile(ITernModule module) {
        String fileName = TernModuleHelper.getFileName(module);
        File moduleFile = null;
        switch (module.getModuleType()) {
            case Plugin: 
            case Configurable: {
                moduleFile = new File(this.ternBaseDir, PLUGIN_FOLDER + '/' + fileName);
                break;
            }
            case Def: {
                moduleFile = new File(this.ternBaseDir, DEFS_FOLDER + '/' + fileName);
            }
        }
        if (moduleFile.exists()) {
            return moduleFile;
        }
        moduleFile = new File(this.ternBaseDir, NODE_MODULES_FOLDER + '/' + "tern-" + module.getName() + '/' + fileName);
        if (moduleFile.exists()) {
            return moduleFile;
        }
        return null;
    }
}

