/*
 * Decompiled with CFR 0.152.
 */
package tern.metadata;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import tern.metadata.TernModuleMetadataOption;
import tern.server.TernModuleInfo;
import tern.server.protocol.JsonHelper;
import tern.utils.StringUtils;

public class TernModuleMetadata {
    public static String ANY_VERSION = "?";
    private static final String NAME_FIELD = "name";
    private static final String LABEL_FIELD = "label";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String HOMEPAGE_FIELD = "homepage";
    private static final String AUTHOR_FIELD = "author";
    private static final String REPOSITORY_FIELD = "repository";
    private static final String BUGS_FIELD = "bugs";
    private static final String HELP_FIELD = "help";
    private static final String URL_FIELD = "url";
    private static final String DEPENDENCIES_FIELD = "dependencies";
    private static final String OPTIONS_FIELD = "options";
    private final String name;
    private final String label;
    private final String description;
    private final String homepage;
    private final String author;
    private final String repositoryURL;
    private final String bugsURL;
    private final String helpURL;
    private final Map<String, Collection<String>> dependencies;
    private final Map<String, Collection<String>> requiredDependencies;
    private final Collection<TernModuleMetadataOption> options;

    public TernModuleMetadata(JsonObject json) {
        this.name = JsonHelper.getString(json, NAME_FIELD);
        this.label = JsonHelper.getString(json, LABEL_FIELD);
        this.description = JsonHelper.getString(json, DESCRIPTION_FIELD);
        this.homepage = JsonHelper.getString(json, HOMEPAGE_FIELD);
        this.author = JsonHelper.getString(json, AUTHOR_FIELD);
        this.repositoryURL = this.getURL(json, REPOSITORY_FIELD);
        this.bugsURL = this.getURL(json, BUGS_FIELD);
        this.helpURL = this.getURL(json, HELP_FIELD);
        JsonValue dependencies = json.get(DEPENDENCIES_FIELD);
        this.dependencies = dependencies != null ? this.parseDependencies(dependencies) : Collections.emptyMap();
        this.requiredDependencies = this.getRequiredDependencies();
        JsonValue options = json.get(OPTIONS_FIELD);
        this.options = options != null && options instanceof JsonArray ? this.parseOptions((JsonArray)options) : Collections.emptyList();
    }

    private Map<String, Collection<String>> getRequiredDependencies() {
        HashMap<String, Collection<String>> requiredDependenciesMap = new HashMap<String, Collection<String>>();
        ArrayList<String> requiredDependencies = null;
        String version = null;
        Collection<String> dependencies = null;
        TernModuleInfo info = null;
        for (Map.Entry<String, Collection<String>> entry : this.dependencies.entrySet()) {
            version = entry.getKey();
            dependencies = entry.getValue();
            for (String dependency : dependencies) {
                info = new TernModuleInfo(dependency);
                if (!info.getType().equals(this.getName())) continue;
                requiredDependencies = (ArrayList<String>)requiredDependenciesMap.get(version);
                if (requiredDependencies == null) {
                    requiredDependencies = new ArrayList<String>();
                    requiredDependenciesMap.put(version, requiredDependencies);
                }
                requiredDependencies.add(dependency);
            }
        }
        return requiredDependenciesMap;
    }

    public String getURL(JsonObject json, String name) {
        JsonValue value = json.get(name);
        if (value != null) {
            return JsonHelper.getString((JsonObject)value, URL_FIELD);
        }
        return null;
    }

    private Map<String, Collection<String>> parseDependencies(JsonValue jsonDependencies) {
        if (jsonDependencies instanceof JsonArray) {
            return this.parseDependencies((JsonArray)jsonDependencies);
        }
        if (jsonDependencies instanceof JsonObject) {
            return this.parseDependencies((JsonObject)jsonDependencies);
        }
        return Collections.emptyMap();
    }

    private Map<String, Collection<String>> parseDependencies(JsonArray jsonDependencies) {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (JsonValue jsonDependency : jsonDependencies) {
            dependencies.add(JsonHelper.getString(jsonDependency));
        }
        HashMap<String, Collection<String>> dependenciesMap = new HashMap<String, Collection<String>>();
        this.parseDependencies(jsonDependencies, ANY_VERSION, dependenciesMap);
        return dependenciesMap;
    }

    private void parseDependencies(JsonArray jsonDependencies, String version, Map<String, Collection<String>> dependenciesMap) {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (JsonValue jsonDependency : jsonDependencies) {
            dependencies.add(JsonHelper.getString(jsonDependency));
        }
        dependenciesMap.put(version, dependencies);
    }

    private Map<String, Collection<String>> parseDependencies(JsonObject jsonDependencies) {
        HashMap<String, Collection<String>> dependenciesMap = new HashMap<String, Collection<String>>();
        for (JsonObject.Member member : jsonDependencies) {
            Collection commons;
            String version = member.getName();
            if (member.getValue() instanceof JsonArray) {
                this.parseDependencies((JsonArray)member.getValue(), version, dependenciesMap);
            }
            if (StringUtils.isEmpty(version) || ANY_VERSION.equals(version) || (commons = (Collection)dependenciesMap.get(ANY_VERSION)) == null) continue;
            ((Collection)dependenciesMap.get(version)).addAll(commons);
        }
        return dependenciesMap;
    }

    private Collection<TernModuleMetadataOption> parseOptions(JsonArray jsonOptions) {
        ArrayList<TernModuleMetadataOption> options = new ArrayList<TernModuleMetadataOption>();
        for (JsonValue jsonOption : jsonOptions) {
            options.add(new TernModuleMetadataOption((JsonObject)jsonOption));
        }
        return options;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomePage() {
        return this.homepage;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public String getBugsURL() {
        return this.bugsURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public Collection<TernModuleMetadataOption> getOptions() {
        return this.options;
    }

    public Collection<String> getDependencies(String version) {
        Collection<String> deps = this.dependencies.get(StringUtils.isEmpty(version) ? ANY_VERSION : version);
        if (deps == null) {
            deps = this.dependencies.get(ANY_VERSION);
        }
        return deps != null ? deps : Collections.emptyList();
    }

    public Collection<String> getRequiredDependencies(String version) {
        Collection<String> deps = this.requiredDependencies.get(StringUtils.isEmpty(version) ? ANY_VERSION : version);
        if (deps == null) {
            deps = this.requiredDependencies.get(ANY_VERSION);
        }
        return deps != null ? deps : Collections.emptyList();
    }
}

