/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.ArrayList;
import java.util.List;
import tern.angular.modules.IDirectiveSyntax;

public class DirectiveHelper {
    public static final String ANY_TAG = "any";
    public static final List<String> STARTS_WITH = new ArrayList<String>();
    public static final List<Character> DELIMITERS;

    static {
        STARTS_WITH.add("");
        STARTS_WITH.add("x-");
        STARTS_WITH.add("data-");
        DELIMITERS = new ArrayList<Character>();
        DELIMITERS.add(Character.valueOf(':'));
        DELIMITERS.add(Character.valueOf('-'));
        DELIMITERS.add(Character.valueOf('_'));
    }

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        int startIndex = 0;
        char[] chs = name.toCharArray();
        int length = chs.length;
        if (length >= 2) {
            if (chs[0] == 'x' && chs[1] == '-') {
                startIndex = 2;
            } else if (length >= 5 && chs[0] == 'd' && chs[1] == 'a' && chs[2] == 't' && chs[3] == 'a' && chs[4] == '-') {
                startIndex = 5;
            }
        }
        StringBuilder normalizedName = new StringBuilder();
        boolean delimiterFound = false;
        char c = '\u0000';
        int i = startIndex;
        while (i < chs.length) {
            c = chs[i];
            if (delimiterFound) {
                normalizedName.append(Character.toUpperCase(c));
                delimiterFound = false;
            } else if (DELIMITERS.contains(Character.valueOf(c))) {
                delimiterFound = true;
            } else {
                normalizedName.append(c);
            }
            ++i;
        }
        return normalizedName.toString();
    }

    public static List<String> getDirectiveNames(String name) {
        List<String> tokensName = DirectiveHelper.buildTokensName(name);
        ArrayList<String> names = new ArrayList<String>();
        names.add(name);
        StringBuilder s = null;
        for (Character delimiter : DELIMITERS) {
            for (String startsWith : STARTS_WITH) {
                s = new StringBuilder(startsWith);
                int i = 0;
                while (i < tokensName.size()) {
                    if (i > 0) {
                        s.append(delimiter);
                    }
                    s.append(tokensName.get(i));
                    ++i;
                }
                names.add(s.toString());
            }
        }
        return names;
    }

    private static List<String> buildTokensName(String name) {
        char[] chars = name.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        char c = '\u0000';
        int i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (!Character.isUpperCase(c)) {
                current.append(c);
            } else {
                tokens.add(current.toString());
                current.setLength(0);
                current.append(Character.toLowerCase(c));
            }
            ++i;
        }
        if (current.length() > 0) {
            tokens.add(current.toString());
        }
        return tokens;
    }

    public static boolean isSupport(IDirectiveSyntax syntax, int i) {
        if (syntax == null) {
            return true;
        }
        switch (i) {
            case 0: {
                return syntax.isUseOriginalName();
            }
            case 1: {
                return syntax.isColonDelimiter() && syntax.isStartsWithNothing();
            }
            case 2: {
                return syntax.isColonDelimiter() && syntax.isStartsWithX();
            }
            case 3: {
                return syntax.isColonDelimiter() && syntax.isStartsWithData();
            }
            case 4: {
                return syntax.isMinusDelimiter() && syntax.isStartsWithNothing();
            }
            case 5: {
                return syntax.isMinusDelimiter() && syntax.isStartsWithX();
            }
            case 6: {
                return syntax.isMinusDelimiter() && syntax.isStartsWithData();
            }
            case 7: {
                return syntax.isUnderscoreDelimiter() && syntax.isStartsWithNothing();
            }
            case 8: {
                return syntax.isUnderscoreDelimiter() && syntax.isStartsWithX();
            }
            case 9: {
                return syntax.isUnderscoreDelimiter() && syntax.isStartsWithData();
            }
        }
        return false;
    }
}

