/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.jsdt.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import tern.ITernFile;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.jsdt.internal.Trace;
import tern.eclipse.ide.jsdt.internal.utils.DOMUtils;
import tern.eclipse.ide.ui.contentassist.JSTernCompletionCollector;
import tern.eclipse.ide.ui.contentassist.TernCompletionsQueryFactory;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.completions.TernCompletionsQuery;

public class TernContentAssistProcessor
extends AbstractContentAssistProcessor
implements ICompletionProposalComputer {
    private IContextInformationValidator fValidator;

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        IProject project;
        ArrayList proposals = new ArrayList();
        IFile file = DOMUtils.getFile(context.getDocument());
        if (file != null && TernCorePlugin.hasTernNature((IProject)(project = file.getProject()))) {
            IDocument document = context.getDocument();
            try {
                IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
                TernDocumentFile tf = new TernDocumentFile(file, document);
                int startOffset = context.getInvocationOffset();
                String filename = tf.getFullName((ITernProject)ternProject);
                TernCompletionsQuery query = TernCompletionsQueryFactory.createQuery((IProject)project, (String)filename, (int)startOffset);
                ternProject.request((TernQuery)query, (ITernFile)tf, (ITernCompletionCollector)new JSTernCompletionCollector(proposals, startOffset, (ITernFile)tf, ternProject));
                return proposals;
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error while JSDT Tern completion.", e);
            }
        }
        return proposals;
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Arrays.asList(this.computeContextInformation(context.getViewer(), context.getInvocationOffset()));
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }
}

