/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Preferences;
import tern.eclipse.ide.core.ITernServerType;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.preferences.PreferencesSupport;
import tern.utils.StringUtils;

public class TernCorePreferencesSupport {
    private static final String NODES_QUALIFIER = "tern.eclipse.ide.core";
    private static final Preferences store = TernCorePlugin.getDefault().getPluginPreferences();
    private PreferencesSupport preferencesSupport = new PreferencesSupport("tern.eclipse.ide.core", store);
    private static TernCorePreferencesSupport instance = null;

    private TernCorePreferencesSupport() {
    }

    public static TernCorePreferencesSupport getInstance() {
        if (instance == null) {
            instance = new TernCorePreferencesSupport();
        }
        return instance;
    }

    public ITernServerType getServerType() {
        String id = this.preferencesSupport.getWorkspacePreferencesValue("ternServerType");
        return TernCorePlugin.getTernServerTypeManager().findTernServerType(id);
    }

    public boolean isTraceOnConsole(IProject project) {
        String result = this.preferencesSupport.getPreferencesValue("traceOnConsole", null, project);
        return StringUtils.asBoolean((String)result, (boolean)false);
    }

    public boolean isLoadingLocalPlugins(IProject project) {
        String result = this.preferencesSupport.getPreferencesValue("loadingLocalPlugin", null, project);
        return StringUtils.asBoolean((String)result, (boolean)false);
    }

    public boolean isDisableAsynchronousReques(IProject project) {
        String result = this.preferencesSupport.getPreferencesValue("disableAsyncRequests", null, project);
        return StringUtils.asBoolean((String)result, (boolean)false);
    }

    public String getUsedTernRepositoryName(IProject project) {
        return this.preferencesSupport.getPreferencesValue("used-repository-name", null, project);
    }

    public boolean isAvailableTernBuilder(IProject project) {
        String result = this.preferencesSupport.getPreferencesValue("availableTernBuilder", null, project);
        return StringUtils.asBoolean((String)result, (boolean)false);
    }
}

