/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.builder;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import tern.TernException;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.core.preferences.TernCorePreferencesSupport;
import tern.server.ITernPlugin;
import tern.server.TernPlugin;
import tern.server.protocol.TernQuery;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.lint.TernLintQuery;

public class TernBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "tern.eclipse.ide.core.ternBuilder";
    private static final IProject[] EMPTY_PROJECT = new IProject[0];
    private static final String JAVASCRIPT_MODEL_PROBLEM_MARKER = "tern.eclipse.ide.core.problem";
    public static final String[] JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "severity", "charStart", "charEnd", "lineNumber"};
    public static final Integer S_ERROR = new Integer(2);
    public static final Integer S_WARNING = new Integer(1);

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !TernCorePlugin.hasTernNature(currentProject)) {
            return EMPTY_PROJECT;
        }
        if (!TernCorePreferencesSupport.getInstance().isAvailableTernBuilder(currentProject)) {
            return EMPTY_PROJECT;
        }
        final IIDETernProject ternProject = TernCorePlugin.getTernProject(currentProject);
        if (ternProject.hasPlugin((ITernPlugin)TernPlugin.lint)) {
            TernLintQuery query = new TernLintQuery(true);
            ITernLintCollector collector = new ITernLintCollector(){
                IResource resource = null;

                public void startLint(String file) {
                    this.resource = (IResource)ternProject.getFile(file).getAdapter(IFile.class);
                    TernBuilder.removeProblemsFor(this.resource);
                }

                public void addMessage(String message, Long start, Long end, String severity, String file) {
                    if (this.resource != null) {
                        try {
                            IMarker marker = this.resource.createMarker(TernBuilder.JAVASCRIPT_MODEL_PROBLEM_MARKER);
                            String[] attributeNames = JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES;
                            int cfr_ignored_0 = attributeNames.length;
                            String[] allNames = attributeNames;
                            Object[] allValues = new Object[allNames.length];
                            int index = 0;
                            allValues[index++] = message;
                            allValues[index++] = "error".equals(severity) ? S_ERROR : S_WARNING;
                            allValues[index++] = start.intValue();
                            allValues[index++] = end.intValue();
                            marker.setAttributes(allNames, allValues);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void endLint(String file) {
                    this.resource = null;
                }
            };
            try {
                ternProject.request((TernQuery)query, collector);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TernException e) {
                e.printStackTrace();
            }
        }
        return EMPTY_PROJECT;
    }

    protected IProject[] buildOLD(int kind, Map args, IProgressMonitor monitor) {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) {
        System.out.println("incremental build on " + delta);
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    System.out.println("changed: " + delta.getResource().getRawLocation());
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
    }

    private void fullBuild(IProgressMonitor monitor) {
        System.out.println("full build");
    }

    public static void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers(JAVASCRIPT_MODEL_PROBLEM_MARKER, false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void addTernBuilder(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = desc.newCommand();
            command.setBuilderName(BUILDER_ID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
        }
    }
}

