/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.properties.AbstractTernPropertyPage;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.controls.TernModulesBlock;
import tern.metadata.TernModuleMetadata;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.utils.TernModuleHelper;

public class TernModulesPropertyPage
extends AbstractTernPropertyPage
implements IWorkbenchPreferencePage {
    private TernModulesBlock modulesBlock;

    public TernModulesPropertyPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(TernUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        IResource resource = this.getResource();
        this.modulesBlock = new TernModulesBlock(resource != null ? resource.getProject() : null, TernUIMessages.TernModulesPropertyPage_desc);
        Control control = this.modulesBlock.createControl(parent);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.modulesBlock.loadModules();
        this.applyDialogFont(parent);
        return parent;
    }

    public boolean performOk() {
        this.modulesBlock.saveColumnSettings();
        Object[] checkedModules = this.modulesBlock.getCheckedModules();
        try {
            IIDETernProject ternProject = this.getTernProject();
            ITernRepository repository = ternProject.getRepository();
            ternProject.clearPlugins();
            ternProject.clearLibs();
            ITernModule module = null;
            Collection requiredDependencies = null;
            ITernModule dependencyModule = null;
            ArrayList<ITernModule> sortedModules = new ArrayList<ITernModule>();
            Object[] objectArray = checkedModules;
            int n = checkedModules.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                module = (ITernModule)object;
                TernModuleMetadata metadata = module.getMetadata();
                if (metadata != null) {
                    requiredDependencies = metadata.getRequiredDependencies(module.getVersion());
                    for (String dependency : requiredDependencies) {
                        dependencyModule = repository.getModule(dependency);
                        if (dependencyModule == null || sortedModules.contains(dependencyModule)) continue;
                        sortedModules.add(dependencyModule);
                    }
                }
                if (module != null && !sortedModules.contains(module)) {
                    sortedModules.add(module);
                }
                ++n2;
            }
            TernModuleHelper.sort(sortedModules);
            for (ITernModule iTernModule : sortedModules) {
                TernModuleHelper.update((ITernModule)iTernModule, (ITernProject)ternProject);
            }
            ternProject.save();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while saving tern project", e);
        }
        return super.performOk();
    }
}

