/* Generated By:JJTree: Do not edit this line. Insert.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=true,VISITOR=true,TRACK_TOKENS=false,NODE_PREFIX=,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.teiid.query.sql.lang;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.designer.query.sql.lang.IInsert;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;

/**
 *
 */
public class Insert extends ProcedureContainer
    implements TargetedCommand, IInsert<ElementSymbol, Expression, GroupSymbol, QueryCommand, LanguageVisitor> {

    /** Identifies the group to be updated. */
    private GroupSymbol group;

    private List<ElementSymbol> variables = new LinkedList<ElementSymbol>();

    private List<Expression> values = new LinkedList<Expression>();
    
    private QueryCommand queryExpression;

    private Criteria constraint;
    
    private boolean merge;

    /**
     * @param p
     * @param id
     */
    public Insert(TeiidParser p, int id) {
        super(p, id);
    }

    /**
     * Return type of command.
     * @return TYPE_INSERT
     */
    @Override
    public int getType() {
        return TYPE_INSERT;
    }

    /**
     * Returns the group being inserted into
     * @return Group being inserted into
     */
    @Override
    public GroupSymbol getGroup() {
        return group;
    }

    /**
     * Set the group for this insert statement
     * @param group Group to be inserted into
     */
    @Override
    public void setGroup(GroupSymbol group) {
        this.group = group;
    }
    
    /**
     * Return an ordered List of variables, may be null if no columns were specified
     * @return List of {@link ElementSymbol}
     */
    @Override
    public List<ElementSymbol> getVariables() {
        return variables;
    }

    /**
     * Add a variable to end of list
     * @param var Variable to add to the list
     */
    @Override
    public void addVariable(ElementSymbol var) {
        variables.add(var);
    }

    /**
     * Add a collection of variables to end of list
     * @param vars Variables to add to the list - collection of ElementSymbol
     */
    @Override
    public void addVariables(Collection<ElementSymbol> vars) {
        variables.addAll(vars);
    }

    /**
     * Set a collection of variables that replace the existing variables
     * @param vars Variables to be set on this object (ElementSymbols)
     */
    @Override
    public void setVariables(Collection<ElementSymbol> vars) {
        this.variables.clear();        
        this.variables.addAll(vars);
    }

    /**
     * Returns a list of values to insert
     * to be inserted.
     * @return List of {@link Expression}s
     */
    @Override
    public List<Expression> getValues() {
        return this.values;
    }

    /**
     * Sets the values to be inserted.
     * @param values List of {@link Expression}s
     */
    @Override
    public void setValues(List<? extends Expression> values) {
        this.values.clear();
        this.values.addAll(values);
    }
    

    /**
     * Adds a value to the list of values
     * @param value Expression to be added to the list of values
     */
    public void addValue(Expression value) {
        values.add(value);
    }

    @Override
    public QueryCommand getQueryExpression() {
        return this.queryExpression;        
    }

    /**
     * @param query
     */
    public void setQueryExpression( QueryCommand query ) {
        if (isTeiid8OrGreater() && query instanceof Query) {
            /*
             * Modified in Teiid 8.6 due to TEIID-2698.
             * This moves the addition of values from the parser to here
             * and is backward compatible with all previous version 8+ parsers.
             * However, the Teiid 7 parser will continue to do its own thing
             * so should not come through here.
             */
            Query expr = (Query)query;
            //a singl row constructor query is the same as values 
            if (expr.isRowConstructor()) {
                this.values.clear();
                this.queryExpression = null;
                for (Expression ex : expr.getSelect().getSymbols()) {
                    addValue(SymbolMap.getExpression(ex));
                }
                if (expr.getOption() != null && this.getOption() == null) {
                    //this isn't ideal, parsing associates the option with values
                    this.setOption(expr.getOption());
                }
                return;
            }
        }

        this.queryExpression = query;        
    }

    /**
     * @return constraint
     */
    public Criteria getConstraint() {
        return constraint;
    }
    
    /**
     * @param constraint
     */
    public void setConstraint(Criteria constraint) {
        this.constraint = constraint;
    }
    
    /**
     * @return merge flag
     */
    public boolean isMerge() {
        return merge;
    }
    
    /**
     * @param merge
     */
    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    /**
     * Get the ordered list of all elements returned by this query.  These elements
     * may be ElementSymbols or ExpressionSymbols but in all cases each represents a 
     * single column.
     * @return Ordered list of SingleElementSymbol
     */
    @Override
    public List<Expression> getProjectedSymbols(){
        return getUpdateCommandSymbol();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = super.hashCode();
        result = prime * result + ((this.constraint == null) ? 0 : this.constraint.hashCode());
        result = prime * result + ((this.group == null) ? 0 : this.group.hashCode());
        result = prime * result + (this.merge ? 1231 : 1237);
        result = prime * result + ((this.queryExpression == null) ? 0 : this.queryExpression.hashCode());
        result = prime * result + ((this.values == null) ? 0 : this.values.hashCode());
        result = prime * result + ((this.variables == null) ? 0 : this.variables.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!super.equals(obj)) return false;
        if (getClass() != obj.getClass()) return false;
        Insert other = (Insert)obj;
        if (this.constraint == null) {
            if (other.constraint != null) return false;
        } else if (!this.constraint.equals(other.constraint)) return false;
        if (this.group == null) {
            if (other.group != null) return false;
        } else if (!this.group.equals(other.group)) return false;
        if (this.merge != other.merge) return false;
        if (this.queryExpression == null) {
            if (other.queryExpression != null) return false;
        } else if (!this.queryExpression.equals(other.queryExpression)) return false;
        if (this.values == null) {
            if (other.values != null) return false;
        } else if (!this.values.equals(other.values)) return false;
        if (this.variables == null) {
            if (other.variables != null) return false;
        } else if (!this.variables.equals(other.variables)) return false;
        return true;
    }

    /** Accept the visitor. **/
    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Insert clone() {
        Insert clone = new Insert(this.parser, this.id);

        if(getGroup() != null)
            clone.setGroup(getGroup().clone());
        if(getVariables() != null)
            clone.setVariables(cloneList(getVariables()));
        if(getValues() != null)
            clone.setValues(cloneList(getValues()));
        if(getQueryExpression() != null)
            clone.setQueryExpression(getQueryExpression().clone());
        if(getConstraint() != null)
            clone.setConstraint(getConstraint().clone());
        clone.setMerge(isMerge());
        if(getSourceHint() != null)
            clone.setSourceHint(getSourceHint());
        if(getOption() != null)
            clone.setOption(getOption().clone());

        copyMetadataState(clone);
        return clone;
    }

}
/* JavaCC - OriginalChecksum=3a8a1c21abb5c92a3cb53631c04d20bb (do not edit this line) */
