/*******************************************************************************
 * Copyright (c) 2006 University College London Software Systems Engineering
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	Bruno Wassermann - initial API and implementation
 *******************************************************************************/
package org.jboss.tools.bpel.runtimes.module;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.jboss.tools.bpel.runtimes.IBPELModuleFacetConstants;

/**
 * Utility to adapt an object (in this case an <code>IProject</code< or an 
 * <code>IFile</code>) toa <code>BPELModuleArtifact</code>.
 *
 * @author Bruno Wassermann, written Aug 14, 2006
 */
public class BPELDeployableArtifactUtil {

	public BPELDeployableArtifactUtil() {
		super();
	}
	
	/**
	 * Adapt an object to an <code>IModuleArtifact</code>
	 * 
	 * @param obj
	 * @return <code>IModuleArtifact</code>
	 */
	public static IModuleArtifact getModuleObject(Object obj) {
		if (obj instanceof IProject) {
			return getModuleObject((IProject) obj);
		}
			
		if (obj instanceof IFile) {
			return getModuleObject((IFile) obj);
		}
			
		return null;
	}
	
	protected static IModuleArtifact getModuleObject(IProject project) {
		return null;
	}
	
	protected static IModuleArtifact getModuleObject(IFile file) {
		// TODO implement;  last impl was totally wrong
//		BPELModuleDelegate moduleDelegate = new BPELModuleDelegate(file.getProject(), file);
//		IStatus fileStatus = moduleDelegate.validate();
//		
//		if (IStatus.OK != fileStatus.getCode()) return null; // not a valid BPEL file
//		
//		IModule[] modules = ServerUtil.getModules(IBPELModuleFacetConstants.JBT_BPEL_MODULE_TYPE);
//		
//		for (int i=0; i<modules.length; i++) {
//			
//			if (modules[i].getProject().equals(file.getProject()) 
//					&& modules[i].getName().equals(file.getName())) 
//			{
//				return new BPELModuleArtifact(modules[i], file);
//			}
//		}
		return null;
	}
	
	/*
	 * TODO in case fixed BPEL facet is not set anymore, may be able to set
	 * the facet programmatically as a fix for the time being
	 * 
	 * TODO figure out new plugin.xml syntax for fixed facet from dynamic web
	 * project
	 * 
	 * TODO this is a duplicate method (BPELModuleFactory.getVersion()). 
	 * Replace this with a utility method somewhere. 
	 */
	private static String getVersion(IProject project) {
		IFacetedProject facetedProject = null;
		try {
			facetedProject = ProjectFacetsManager.create(project);
			if (facetedProject != null 
					&& ProjectFacetsManager.isProjectFacetDefined(IBPELModuleFacetConstants.BPEL_PROJECT_FACET)) 
			{
				IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet(IBPELModuleFacetConstants.BPEL_PROJECT_FACET);
				
				return facetedProject.getInstalledVersion(projectFacet).getVersionString();
			}
			// https://issues.jboss.org/browse/JBIDE-8533
			// Added to support deprecated jbt.bpel.facet.core
			if (facetedProject != null 
					&& ProjectFacetsManager.isProjectFacetDefined(IBPELModuleFacetConstants.JBT_BPEL_PROJECT_FACET)) 
			{
				IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet(IBPELModuleFacetConstants.JBT_BPEL_PROJECT_FACET);
				
				return facetedProject.getInstalledVersion(projectFacet).getVersionString();
			}
		} catch (Exception e) {
			Logger.getLogger().write(e);
		}
		return IBPELModuleFacetConstants.BPEL20_VERSION;
	}
}
