/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.validator;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ResourceValidator;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationRule;
import org.teiid.designer.core.validation.ValidationRuleSet;
import org.teiid.designer.core.validation.ValidationRuleSetImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.metamodels.xsd.XsdPlugin;
import org.teiid.designer.metamodels.xsd.validator.XsdResourceValidationRule;

public class SimpleXsdResourceValidator
implements ResourceValidator {
    private static final ValidationRuleSet RULE_SET = new ValidationRuleSetImpl();

    static {
        RULE_SET.addRule((ValidationRule)new XsdResourceValidationRule());
    }

    public boolean isValidatorForObject(Object obj) {
        if (obj instanceof IResource) {
            return ModelUtil.isXsdFile((IResource)((IResource)obj));
        }
        return obj instanceof XSDResourceImpl;
    }

    public void validate(IProgressMonitor theMonitor, Object obj, ValidationContext context) throws ModelerCoreException {
        XSDResourceImpl eResource;
        IProgressMonitor monitor;
        if (!this.isValidatorForObject(obj)) {
            Object[] params = new Object[]{this.getClass().getName(), obj != null ? obj.getClass().getName() : null};
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.validator_cannot_be_used_to_validate_the_object", params);
            throw new ModelerCoreException(msg);
        }
        Object object = monitor = theMonitor != null ? theMonitor : new NullProgressMonitor();
        if (obj instanceof IResource) {
            IResource iResource = (IResource)obj;
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            ModelResource mResource = workspace.findModelResource(iResource);
            if (mResource != null) {
                Resource eResource2 = mResource.getEmfResource();
                this.validate(monitor, eResource2, iResource, context);
            } else {
                String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.Could_not_find_model_resource", (Object)iResource.getName());
                XsdPlugin.Util.log(2, msg);
            }
        } else if (obj instanceof XSDResourceImpl && (eResource = (XSDResourceImpl)obj).isLoaded()) {
            try {
                this.validateResource(monitor, eResource, context);
            }
            catch (Throwable e) {
                String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.Error_validating_resource", (Object)eResource.getURI().lastSegment());
                XsdPlugin.Util.log(4, e, msg);
            }
        }
    }

    public void validate(IProgressMonitor theMonitor, Resource resource, IResource iResource, ValidationContext context) throws ModelerCoreException {
        IProgressMonitor monitor;
        Object object = monitor = theMonitor != null ? theMonitor : new NullProgressMonitor();
        if (!(resource instanceof EmfResource)) {
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.SimpleXsdResourceValidator_may_only_be_used_to_validate_instances_of_EmfResource_1", new Object[0]);
            throw new ModelerCoreException(msg);
        }
        if (iResource == null) {
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.IResource_may_not_be_null_during_validation_2", new Object[0]);
            throw new ModelerCoreException(msg);
        }
        if (!this.isValidatorForResource(iResource)) {
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.Unexpected_IResource_type_encountered_during_EMF_Resource_Validation_1", new Object[0]);
            throw new ModelerCoreException(msg);
        }
        XSDResourceImpl eResource = (XSDResourceImpl)resource;
        if (eResource.isLoaded()) {
            try {
                this.validateResource(monitor, eResource, context);
            }
            catch (Throwable e) {
                String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.Error_validating_resource", (Object)eResource.getURI().lastSegment());
                XsdPlugin.Util.log(4, e, msg);
            }
        }
    }

    public void addMarkers(ValidationContext context, IResource iResource) throws ModelerCoreException {
        if (context != null && context.hasResults()) {
            List results = context.getValidationResults();
            try {
                for (ValidationResult result : results) {
                    if (result == null || !result.hasProblems()) continue;
                    ValidationProblem[] problems = result.getProblems();
                    String locationPath = result.getLocationPath();
                    String locationUri = result.getLocationUri();
                    String targetUri = result.getTargetUri();
                    int probCnt = 0;
                    while (probCnt < problems.length) {
                        this.createProblemMarker(locationPath, locationUri, targetUri, problems[probCnt], iResource);
                        ++probCnt;
                    }
                    if (!result.isFatalResource()) continue;
                    return;
                }
            }
            catch (CoreException err) {
                throw new ModelerCoreException(err);
            }
        }
    }

    public boolean isValidatorForResource(IResource iResource) {
        return this.isValidatorForObject(iResource);
    }

    public void validationStarted(Collection resources, ValidationContext context) {
    }

    public void validationEnded(ValidationContext context) {
    }

    private void createProblemMarker(String locationPath, String locationUri, String targetUri, ValidationProblem problem, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("location", (Object)locationPath);
        marker.setAttribute("org.teiid.designer.core.markerURI", (Object)locationUri);
        marker.setAttribute("org.teiid.designer.core.targetMarkerURI", (Object)targetUri);
        marker.setAttribute("message", (Object)problem.getMessage());
        this.setMarkerSeverity(marker, problem);
    }

    private void setMarkerSeverity(IMarker marker, ValidationProblem problem) throws CoreException {
        switch (problem.getSeverity()) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void validateResource(IProgressMonitor monitor, XSDResourceImpl eResource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)eResource);
        CoreArgCheck.isNotNull((Object)context);
        context.clearResults();
        RULE_SET.validate(monitor, (Object)eResource, context);
    }
}

