/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.wizards;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerProperties;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.ui.viewsupport.SingleProjectFilter;
import org.teiid.designer.vdb.VdbConstants;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public class DefineVdbDialog
extends TitleAreaDialog
implements IChangeListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DefineVdbDialog.class);
    private IResource selectedVdb;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private Button newVdbButton;
    private Button browseVdbsButton;
    private Text selectedVdbText;
    DesignerProperties designerProperties;

    static String getString(String key) {
        return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + key, new Object[0]);
    }

    public DefineVdbDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DefineVdbDialog(Shell parentShell, Properties properties) {
        this(parentShell);
        this.designerProperties = (DesignerProperties)properties;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DefineVdbDialog.getString("title"));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(DefineVdbDialog.getString("subTitle"));
        this.setMessage(DefineVdbDialog.getString("initialMessage"));
        Label label = WidgetFactory.createLabel((Composite)panel, (String)DefineVdbDialog.getString("vdbName"));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedVdbText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedVdbText.setToolTipText(DefineVdbDialog.getString("vdbNameTooltip"));
        this.selectedVdbText.setEditable(false);
        this.selectedVdbText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedVdbText.setForeground(Display.getCurrent().getSystemColor(10));
        this.newVdbButton = WidgetFactory.createButton((Composite)panel, (String)DefineVdbDialog.getString("newVdbButton"));
        this.newVdbButton.setToolTipText(DefineVdbDialog.getString("newVdbButtonTooltip"));
        this.newVdbButton.setEnabled(true);
        this.newVdbButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.newVdbButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineVdbDialog.this.handleNewVdbPressed();
            }
        });
        this.browseVdbsButton = WidgetFactory.createButton((Composite)panel, (String)DefineVdbDialog.getString("browseVdbsButton"));
        this.browseVdbsButton.setToolTipText(DefineVdbDialog.getString("browseVdbsButtonTooltip"));
        this.browseVdbsButton.setEnabled(true);
        this.browseVdbsButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseVdbsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineVdbDialog.this.handleBrowseWorkspaceForVdbPressed();
            }
        });
        return panel;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.designerProperties != null) {
            this.selectedVdb = this.designerProperties.getVDB();
            if (this.selectedVdb != null) {
                this.selectedVdbText.setText(this.selectedVdb.getName());
            }
            this.updateState();
        }
        return control;
    }

    public IResource getVdb() {
        return this.selectedVdb;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        IStatus status = Status.OK_STATUS;
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(DefineVdbDialog.getString("okMsg"));
        }
    }

    void handleNewVdbPressed() {
        ModelerUiViewUtils.launchWizard((String)"newVdbWizard", (IStructuredSelection)new StructuredSelection(), (Properties)this.designerProperties, (boolean)true);
        if (this.selectedVdb == null || this.designerProperties.isViewModelDifferent((IFile)this.selectedVdb)) {
            this.selectedVdb = this.designerProperties.getVDB();
            if (this.selectedVdb != null) {
                this.selectedVdbText.setText(this.selectedVdb.getName());
            }
        }
    }

    void handleBrowseWorkspaceForVdbPressed() {
        ModelWorkspaceDialog sdDialog = this.createVdbSelector();
        sdDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        sdDialog.addFilter((ViewerFilter)new SingleProjectFilter((Properties)this.designerProperties));
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            this.selectedVdb = (IResource)selections[0];
            this.designerProperties.setVdbName(this.selectedVdb.getName());
            this.selectedVdbText.setText(this.selectedVdb.getName());
            try {
                IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
                IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)this.selectedVdb));
            }
            catch (PartInitException partInitException) {}
            this.updateState();
        }
    }

    public ModelWorkspaceDialog createVdbSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = DefineVdbDialog.getString("vdb.selectionDialog.title");
        String message = DefineVdbDialog.getString("vdb.selectionDialog.message");
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput((Object)ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                boolean ok = false;
                if (selection != null && selection.length == 1 && selection[0] instanceof IResource) {
                    IResource res = (IResource)selection[0];
                    ok = ModelUtil.isVdbArchiveFile((IResource)res);
                }
                if (!ok) {
                    String msg = DefineVdbDialog.getString("vdb.selectionDialog.invalidSelection");
                    return new StatusInfo(VdbConstants.PLUGIN_ID, 4, msg);
                }
                return new StatusInfo(VdbConstants.PLUGIN_ID);
            }
        });
        return result;
    }
}

