/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.translators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.TranslatorOverridePropertyEditingSupport;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.connections.SourceHandler;
import org.teiid.designer.vdb.connections.SourceHandlerExtensionManager;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;
import org.teiid.designer.vdb.ui.editor.ConfirmationDialog;
import org.teiid.designer.vdb.ui.translators.AddPropertyDialog;
import org.teiid.designer.vdb.ui.translators.AddTranslatorOverrideDialog;
import org.teiid.designer.vdb.ui.translators.EditTranslatorOverrideDialog;

public final class TranslatorOverridesPanel
extends Composite {
    static final String PREFIX = I18nUtil.getPropertyPrefix(TranslatorOverridesPanel.class);
    static final String CONFIRM_REMOVE_MESSAGE = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "confirmRemoveMessage", new Object[0]);
    Button addPropertyButton;
    Button deletePropertyButton;
    Button editPropertyButton;
    Button addTranslatorButton;
    Button deleteTranslatorButton;
    Button editTranslatorButton;
    private final TableViewer propertiesViewer;
    private final TableViewer translatorsViewer;
    private final Text txtDescription;
    private final Vdb vdb;

    public TranslatorOverridesPanel(Composite parent, Vdb vdb) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.vdb = vdb;
        SashForm splitter = new SashForm((Composite)this, 256);
        splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite pnlTranslators = new Composite((Composite)splitter, 2048);
        pnlTranslators.setLayout((Layout)new GridLayout());
        pnlTranslators.setLayoutData((Object)new GridData(4, 4, true, true));
        this.translatorsViewer = new TableViewer(pnlTranslators, 68352);
        this.translatorsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return TranslatorOverridesPanel.this.getTranslatorOverrides().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.translatorsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object t1, Object t2) {
                TranslatorOverride translator1 = (TranslatorOverride)t1;
                TranslatorOverride translator2 = (TranslatorOverride)t2;
                return super.compare(viewer, (Object)translator1.getName(), (Object)translator2.getName());
            }
        });
        this.translatorsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TranslatorOverridesPanel.this.handleTranslatorSelected(event);
            }
        });
        final Table table = this.translatorsViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        final TableViewerColumn column = new TableViewerColumn(this.translatorsViewer, 16384);
        column.getColumn().setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "translatorColumn.text", new Object[0]));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TranslatorOverride translator = (TranslatorOverride)element;
                return translator.getName();
            }
        });
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                column.getColumn().setWidth(table.getSize().x);
            }
        });
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)pnlTranslators, (int)0, (int)2, (int)1, (int)3);
        this.addTranslatorButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addTranslatorButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/add-translator.png"));
        this.addTranslatorButton.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "addTranslatorAction.toolTip", new Object[0]));
        this.addTranslatorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorOverridesPanel.this.handleAddTranslatorOverride();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editTranslatorButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.editTranslatorButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/edit-translator.png"));
        this.editTranslatorButton.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "editTranslatorAction.toolTip", new Object[0]));
        this.editTranslatorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorOverridesPanel.this.handleEditTranslatorOverride();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editTranslatorButton.setEnabled(false);
        this.deleteTranslatorButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.deleteTranslatorButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/remove-translator.png"));
        this.deleteTranslatorButton.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "removeTranslatorAction.toolTip", new Object[0]));
        this.deleteTranslatorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfirmationDialog.confirm(CONFIRM_REMOVE_MESSAGE)) {
                    TranslatorOverridesPanel.this.handleTranslatorRemoved();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deleteTranslatorButton.setEnabled(false);
        this.translatorsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TranslatorOverridesPanel.this.handleEditTranslatorOverride();
            }
        });
        Composite pnlOverrides = new Composite((Composite)splitter, 2048);
        pnlOverrides.setLayout((Layout)new GridLayout(2, false));
        pnlOverrides.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblDescription = new Label(pnlOverrides, 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblDescription.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "lblTranslatorDescription", new Object[0]));
        this.txtDescription = new Text(pnlOverrides, 2626);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.txtDescription.getLayoutData()).heightHint = 35;
        ((GridData)this.txtDescription.getLayoutData()).horizontalSpan = 2;
        this.txtDescription.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "txtTranslatorDescription.toolTip", new Object[0]));
        this.txtDescription.setEnabled(false);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorOverridesPanel.this.handleDescriptionChanged();
            }
        });
        this.propertiesViewer = new TableViewer(pnlOverrides, 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewer);
        this.propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                TranslatorOverride translator = TranslatorOverridesPanel.this.getSelectedTranslator();
                if (translator == null) {
                    return new Object[0];
                }
                return translator.getOverrideProperties();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertiesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TranslatorOverrideProperty prop1 = (TranslatorOverrideProperty)e1;
                TranslatorOverrideProperty prop2 = (TranslatorOverrideProperty)e2;
                return super.compare(viewer, (Object)prop1.getDefinition().getDisplayName(), (Object)prop2.getDefinition().getDisplayName());
            }
        });
        Table table2 = this.propertiesViewer.getTable();
        table2.setHeaderVisible(true);
        table2.setLinesVisible(true);
        table2.setLayout((Layout)new TableLayout());
        table2.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)table2.getLayoutData()).horizontalSpan = 2;
        TableViewerColumn column2 = new TableViewerColumn(this.propertiesViewer, 16384);
        column2.getColumn().setText(String.valueOf(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "propertyColumn.text", new Object[0])) + "        ");
        column2.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(true));
        column2 = new TableViewerColumn(this.propertiesViewer, 16384);
        column2.getColumn().setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "valueColumn.text", new Object[0]));
        column2.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(false));
        column2.setEditingSupport((EditingSupport)new TranslatorOverridePropertyEditingSupport((ColumnViewer)this.propertiesViewer, (IResource)this.vdb.getSourceFile()));
        this.propertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TranslatorOverridesPanel.this.handlePropertySelected(event);
            }
        });
        Composite toolbarPanel2 = WidgetFactory.createPanel((Composite)pnlOverrides, (int)0, (int)2, (int)1, (int)4);
        this.addPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel2, (int)4);
        this.addPropertyButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/add.png"));
        this.addPropertyButton.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "addPropertyAction.toolTip", new Object[0]));
        this.addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorOverridesPanel.this.handleAddProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addPropertyButton.setEnabled(false);
        this.editPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel2, (int)4);
        this.editPropertyButton.setEnabled(false);
        this.editPropertyButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/edit.png"));
        this.editPropertyButton.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "editPropertyAction.toolTip", new Object[0]));
        this.editPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorOverridesPanel.this.handleEditProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deletePropertyButton = WidgetFactory.createButton((Composite)toolbarPanel2, (int)4);
        this.deletePropertyButton.setEnabled(false);
        this.deletePropertyButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/remove.png"));
        this.deletePropertyButton.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "removePropertyAction.toolTip", new Object[0]));
        this.deletePropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorOverridesPanel.this.handlePropertyRemoved();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        org.teiid.designer.ui.common.widget.Label noteLabel = WidgetFactory.createLabel((Composite)toolbarPanel2, (String)VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "overridePropertiesNoteLabel", new Object[0]));
        noteLabel.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)noteLabel);
        noteLabel.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "overridePropertiesNoteTooltip", new Object[0]));
        splitter.setWeights(new int[]{25, 75});
        this.translatorsViewer.setInput((Object)this);
        this.propertiesViewer.setInput((Object)this);
    }

    private TranslatorOverrideProperty getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertiesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (TranslatorOverrideProperty)selection.getFirstElement();
    }

    TranslatorOverride getSelectedTranslator() {
        ISelection selection = this.translatorsViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (TranslatorOverride)((IStructuredSelection)selection).getFirstElement();
    }

    Collection<TranslatorOverride> getTranslatorOverrides() {
        return this.vdb.getTranslators();
    }

    private List<String> getTranslatorOverrideNames() {
        ArrayList<String> names = new ArrayList<String>(this.vdb.getTranslators().size());
        for (TranslatorOverride translator : this.vdb.getTranslators()) {
            names.add(translator.getName());
        }
        return names;
    }

    private String[] getTranslatorTypes() {
        SourceHandler handler = SourceHandlerExtensionManager.getVdbConnectionFinder();
        return handler.getTranslatorTypes();
    }

    void handleAddProperty() {
        assert (!this.translatorsViewer.getSelection().isEmpty());
        AddPropertyDialog dialog = new AddPropertyDialog(this.getShell(), VdbUiConstants.Util.getString("AddPropertyDialog.addTitle", new Object[0]), this.getSelectedTranslator().getPropertyNames(), null);
        if (dialog.open() == 0) {
            TranslatorOverride translator = this.getSelectedTranslator();
            TranslatorOverrideProperty property = dialog.getProperty();
            translator.addProperty(property);
            this.propertiesViewer.refresh();
            TranslatorPropertyDefinition propDefn = property.getDefinition();
            TranslatorOverrideProperty[] translatorOverridePropertyArray = translator.getOverrideProperties();
            int n = translatorOverridePropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                TranslatorOverrideProperty prop = translatorOverridePropertyArray[n2];
                if (prop.getDefinition().equals((Object)propDefn)) {
                    this.propertiesViewer.setSelection((ISelection)new StructuredSelection((Object)prop), true);
                    break;
                }
                ++n2;
            }
        }
    }

    void handleEditProperty() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        IStructuredSelection ssel = (IStructuredSelection)this.propertiesViewer.getSelection();
        ssel.isEmpty();
        TranslatorOverrideProperty overrideProp = (TranslatorOverrideProperty)ssel.getFirstElement();
        AddPropertyDialog dialog = new AddPropertyDialog(this.getShell(), VdbUiConstants.Util.getString("AddPropertyDialog.editTitle", new Object[0]), this.getSelectedTranslator().getPropertyNames(), overrideProp);
        if (dialog.open() == 0) {
            TranslatorOverride translator = this.getSelectedTranslator();
            TranslatorOverrideProperty property = dialog.getProperty();
            translator.removeProperty(overrideProp.getDefinition().getId());
            translator.addProperty(property);
            this.propertiesViewer.refresh();
            TranslatorPropertyDefinition propDefn = property.getDefinition();
            TranslatorOverrideProperty[] translatorOverridePropertyArray = translator.getOverrideProperties();
            int n = translatorOverridePropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                TranslatorOverrideProperty prop = translatorOverridePropertyArray[n2];
                if (prop.getDefinition().equals((Object)propDefn)) {
                    this.propertiesViewer.setSelection((ISelection)new StructuredSelection((Object)prop), true);
                    break;
                }
                ++n2;
            }
        }
    }

    void handleAddTranslatorOverride() {
        TranslatorOverride translatorOverride = null;
        String[] translatorTypes = this.getTranslatorTypes();
        if (translatorTypes == null) {
            AddTranslatorOverrideDialog dialog = new AddTranslatorOverrideDialog(this.getShell(), this.getTranslatorOverrideNames());
            if (dialog.open() == 0) {
                translatorOverride = new TranslatorOverride(this.vdb, dialog.getName(), dialog.getType(), null);
            }
        } else {
            EditTranslatorOverrideDialog dialog = new EditTranslatorOverrideDialog(this.getShell(), translatorTypes, this.vdb.getTranslators());
            if (dialog.open() == 0) {
                translatorOverride = new TranslatorOverride(this.vdb, dialog.getName(), dialog.getType(), null);
            }
        }
        if (translatorOverride != null) {
            this.vdb.addTranslator(translatorOverride);
            this.translatorsViewer.refresh();
            this.translatorsViewer.setSelection((ISelection)new StructuredSelection((Object)translatorOverride), true);
        }
    }

    void handleDescriptionChanged() {
        if (!this.translatorsViewer.getSelection().isEmpty()) {
            TranslatorOverride translator = this.getSelectedTranslator();
            translator.setDescription(this.txtDescription.getText());
        }
    }

    void handleEditTranslatorOverride() {
        assert (!this.translatorsViewer.getSelection().isEmpty());
        TranslatorOverride translatorOverride = this.getSelectedTranslator();
        String[] translatorTypes = this.getTranslatorTypes();
        EditTranslatorOverrideDialog dialog = new EditTranslatorOverrideDialog(this.getShell(), translatorOverride, translatorTypes, this.vdb.getTranslators());
        if (dialog.open() == 0) {
            this.translatorsViewer.refresh((Object)translatorOverride);
        }
    }

    void handlePropertyRemoved() {
        TranslatorOverrideProperty selectedProperty = this.getSelectedProperty();
        assert (selectedProperty != null);
        TranslatorOverride translator = this.getSelectedTranslator();
        translator.removeProperty(selectedProperty.getDefinition().getId());
        this.propertiesViewer.refresh();
    }

    void handlePropertySelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            if (this.deletePropertyButton.isEnabled()) {
                this.deletePropertyButton.setEnabled(false);
            }
            if (this.editPropertyButton.isEnabled()) {
                this.editPropertyButton.setEnabled(false);
            }
        } else {
            TranslatorOverrideProperty prop = (TranslatorOverrideProperty)selection.getFirstElement();
            boolean enable = prop.isCustom();
            if (this.deletePropertyButton.isEnabled() != enable) {
                this.deletePropertyButton.setEnabled(enable);
            }
            enable = prop.hasOverridenValue();
            if (this.editPropertyButton.isEnabled() != enable) {
                this.editPropertyButton.setEnabled(enable);
            }
        }
    }

    void handleRestorePropertyDefaultValue() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        TranslatorOverrideProperty prop = this.getSelectedProperty();
        prop.setValue(null);
        this.propertiesViewer.refresh((Object)prop);
        this.editPropertyButton.setEnabled(false);
    }

    void handleTranslatorRemoved() {
        assert (!this.translatorsViewer.getSelection().isEmpty());
        TranslatorOverride translatorOverride = this.getSelectedTranslator();
        if (this.vdb.removeTranslator(translatorOverride)) {
            this.translatorsViewer.remove((Object)translatorOverride);
        }
    }

    void handleTranslatorSelected(SelectionChangedEvent event) {
        ISelection selection = this.translatorsViewer.getSelection();
        if (selection.isEmpty()) {
            this.txtDescription.setText("");
            if (this.txtDescription.isEnabled()) {
                this.txtDescription.setEnabled(false);
            }
            if (this.editTranslatorButton.isEnabled()) {
                this.editTranslatorButton.setEnabled(false);
            }
            if (this.deleteTranslatorButton.isEnabled()) {
                this.deleteTranslatorButton.setEnabled(false);
            }
            if (this.addPropertyButton.isEnabled()) {
                this.addPropertyButton.setEnabled(false);
            }
        } else {
            if (!this.txtDescription.isEnabled()) {
                this.txtDescription.setEnabled(true);
            }
            if (!this.editTranslatorButton.isEnabled()) {
                this.editTranslatorButton.setEnabled(true);
            }
            if (!this.deleteTranslatorButton.isEnabled()) {
                this.deleteTranslatorButton.setEnabled(true);
            }
            if (!this.addPropertyButton.isEnabled()) {
                this.addPropertyButton.setEnabled(true);
            }
            TranslatorOverride translator = this.getSelectedTranslator();
            assert (translator != null);
            SourceHandler handler = SourceHandlerExtensionManager.getVdbConnectionFinder();
            PropertyDefinition[] propertyDefinitionsFromServer = handler.getTranslatorDefinitions(translator.getType());
            TranslatorOverrideProperty[] currentProps = translator.getOverrideProperties();
            ArrayList<Object> propsToRemove = new ArrayList<Object>();
            if (propertyDefinitionsFromServer != null) {
                ArrayList<PropertyDefinition> arrayList = new ArrayList<PropertyDefinition>();
                PropertyDefinition[] propertyDefinitionArray = propertyDefinitionsFromServer;
                int n = propertyDefinitionsFromServer.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDefinition propDefn = propertyDefinitionArray[n2];
                    arrayList.add(propDefn);
                    ++n2;
                }
                if (currentProps.length != 0) {
                    propertyDefinitionArray = currentProps;
                    n = currentProps.length;
                    n2 = 0;
                    while (n2 < n) {
                        PropertyDefinition property = propertyDefinitionArray[n2];
                        PropertyDefinition serverPropDefn = null;
                        PropertyDefinition[] propertyDefinitionArray2 = propertyDefinitionsFromServer;
                        int n3 = propertyDefinitionsFromServer.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PropertyDefinition propDefn = propertyDefinitionArray2[n4];
                            if (property.getDefinition().getId().equals(propDefn.getId())) {
                                serverPropDefn = propDefn;
                                arrayList.remove(propDefn);
                                break;
                            }
                            ++n4;
                        }
                        if (serverPropDefn != null) {
                            translator.updatePropertyDefinition(property.getDefinition().getId(), serverPropDefn, false);
                        } else if (property.hasOverridenValue()) {
                            translator.markAsUserDefined((TranslatorOverrideProperty)property);
                        } else {
                            propsToRemove.add(property);
                        }
                        ++n2;
                    }
                }
                if (!arrayList.isEmpty()) {
                    for (PropertyDefinition delegate : arrayList) {
                        TranslatorOverrideProperty newProp = new TranslatorOverrideProperty(new TranslatorPropertyDefinition(delegate), null);
                        translator.addProperty(newProp, false);
                    }
                }
            } else if (currentProps.length != 0) {
                TranslatorOverrideProperty[] translatorOverridePropertyArray = currentProps;
                int n = currentProps.length;
                int n5 = 0;
                while (n5 < n) {
                    TranslatorOverrideProperty translatorOverrideProperty = translatorOverridePropertyArray[n5];
                    if (!translatorOverrideProperty.hasOverridenValue()) {
                        propsToRemove.add(translatorOverrideProperty);
                    }
                    ++n5;
                }
            }
            if (!propsToRemove.isEmpty()) {
                for (TranslatorOverrideProperty translatorOverrideProperty : propsToRemove) {
                    translator.removeOverrideProperty(translatorOverrideProperty.getDefinition().getId(), false);
                }
            }
            this.txtDescription.setText(translator.getDescription());
        }
        this.propertiesViewer.refresh();
        WidgetUtil.pack((TableViewer)this.propertiesViewer);
    }

    public void refresh() {
        this.translatorsViewer.setInput((Object)this);
        this.translatorsViewer.refresh();
        this.propertiesViewer.setInput((Object)this);
        this.propertiesViewer.refresh();
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final boolean nameColumn;

        public PropertyLabelProvider(boolean nameColumn) {
            this.nameColumn = nameColumn;
        }

        public Image getImage(Object element) {
            TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
            String overridenValue = property.getOverriddenValue();
            Image image = null;
            if (!this.nameColumn) {
                if (property.getDefinition().isValidValue(overridenValue) == null) {
                    if (!(!property.hasOverridenValue() || property.isCustom() && property.getDefinition().getDefaultValue().equals(overridenValue))) {
                        image = VdbUiPlugin.singleton.getImage("icons/full/ctool16/restore-default-value.png");
                    }
                } else {
                    image = UiPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
            }
            return image;
        }

        public String getText(Object element) {
            TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
            if (this.nameColumn) {
                return property.getDefinition().getDisplayName();
            }
            boolean masked = property.getDefinition().isMasked();
            if (property.hasOverridenValue()) {
                return masked ? "*****" : property.getOverriddenValue();
            }
            return masked ? "*****" : property.getDefinition().getDefaultValue();
        }

        public String getToolTipText(Object element) {
            TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
            if (this.nameColumn) {
                return property.getDefinition().getDescription();
            }
            if (!(!property.hasOverridenValue() || property.isCustom() && property.getDefinition().getDefaultValue().equals(property.getOverriddenValue()))) {
                return property.getDefinition().isValidValue(property.getOverriddenValue());
            }
            return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "usingPropertyDefaultValue", new Object[0]);
        }
    }
}

