/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.translators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public final class EditTranslatorOverrideDialog
extends MessageDialog {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(EditTranslatorOverrideDialog.class);
    private Button btnOk;
    private List<String> existingNames;
    private String name;
    private String[] translatorTypes;
    private String type;
    private TableViewer viewer;
    private TranslatorOverride translatorBeingEdited;

    private EditTranslatorOverrideDialog(Shell parentShell, String title, String message, String[] translatorTypes, Collection<TranslatorOverride> existingTranslators) {
        super(parentShell, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] stringArray = this.translatorTypes = translatorTypes == null ? new String[]{} : translatorTypes;
        if (existingTranslators == null || existingTranslators.isEmpty()) {
            this.existingNames = Collections.emptyList();
        } else {
            this.existingNames = new ArrayList<String>(existingTranslators.size());
            for (TranslatorOverride translator : existingTranslators) {
                this.existingNames.add(translator.getName());
            }
        }
    }

    public EditTranslatorOverrideDialog(Shell parentShell, String[] translatorTypes, Collection<TranslatorOverride> existingTranslators) {
        this(parentShell, VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "newTranslatorTitle", new Object[0]), VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "newTranslatorInitialMessage", new Object[0]), translatorTypes, existingTranslators);
    }

    public EditTranslatorOverrideDialog(Shell parentShell, TranslatorOverride translator, String[] translatorTypes, Collection<TranslatorOverride> existingTranslators) {
        this(parentShell, VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "editTranslatorTitle", new Object[0]), VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "editTranslatorInitialMessage", new Object[0]), translatorTypes, existingTranslators);
        CoreArgCheck.isNotNull((Object)translator, (String)"translator is null");
        this.translatorBeingEdited = translator;
        this.name = this.translatorBeingEdited.getName();
        this.type = this.translatorBeingEdited.getType();
        this.existingNames.remove(this.name);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected Control createCustomArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblName = new Label(pnl, 0);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblName.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "lblName.text", new Object[0]));
        Text txtName = new Text(pnl, 2048);
        txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtName.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "txtName.toolTip", new Object[0]));
        if (this.isEditMode()) {
            txtName.setText(this.translatorBeingEdited.getName());
        }
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTranslatorOverrideDialog.this.handleNameChanged(((Text)e.widget).getText());
            }
        });
        Label lblType = new Label(pnl, 0);
        lblType.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "lblType.text", new Object[0]));
        if (this.isEditMode()) {
            Label lbl = new Label(pnl, 0);
            lbl.setText(this.type);
        } else {
            lblType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            ((GridData)lblType.getLayoutData()).horizontalSpan = 2;
            this.viewer = new TableViewer(pnl, 2820);
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return EditTranslatorOverrideDialog.this.getTranslatorTypes();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            if (!this.isEditMode()) {
                this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent e) {
                        EditTranslatorOverrideDialog.this.handleTypeChanged();
                    }
                });
            }
            this.viewer.setSorter(new ViewerSorter(){

                public void sort(Viewer viewer, Object[] elements) {
                    Arrays.sort(elements);
                }
            });
            Table table = this.viewer.getTable();
            table.setFont(parent.getFont());
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = table.getItemHeight() * 8;
            gd.minimumHeight = table.getItemHeight() * 2;
            gd.horizontalSpan = 2;
            table.setLayoutData((Object)gd);
            if (this.isEditMode()) {
                table.setEnabled(false);
            }
            this.viewer.setInput((Object)this);
            if (this.isEditMode()) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.translatorBeingEdited.getType()), true);
            }
        }
        return pnl;
    }

    public String getName() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.name;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    String[] getTranslatorTypes() {
        assert (this.translatorTypes != null) : "translatorTypes is null";
        return this.translatorTypes;
    }

    public String getType() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.type;
    }

    void handleNameChanged(String newName) {
        this.name = newName;
        this.updateState();
    }

    private boolean isEditMode() {
        return this.translatorBeingEdited != null;
    }

    void handleTypeChanged() {
        assert (!this.isEditMode()) : "Type shouldn't be changed when editing an existing translator";
        this.type = (String)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        this.updateState();
    }

    protected void setReturnCode(int code) {
        super.setReturnCode(code);
        if (code == 0 && this.isEditMode()) {
            this.translatorBeingEdited.setName(this.name);
        }
    }

    private void updateState() {
        String msg = this.validate();
        if (this.imageLabel.getImage() != null) {
            this.imageLabel.setImage(null);
        }
        if (StringUtilities.isEmpty((String)msg)) {
            if (this.isEditMode() && this.translatorBeingEdited.getName().equals(this.name)) {
                if (this.btnOk.isEnabled()) {
                    this.btnOk.setEnabled(false);
                }
                msg = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "editTranslatorInitialMessage", new Object[0]);
            } else if (!this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(true);
            }
            this.imageLabel.setImage(this.getInfoImage());
            if (CoreStringUtil.isEmpty((String)msg)) {
                msg = this.isEditMode() ? VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "editTranslatorOkMessage", new Object[]{this.translatorBeingEdited.getName(), this.name}) : VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "newTranslatorOkMessage", new Object[]{this.name, this.type});
            }
        } else {
            if (this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(false);
            }
            this.imageLabel.setImage(this.getErrorImage());
        }
        this.messageLabel.setText(msg);
        this.messageLabel.pack();
    }

    private String validate() {
        if (StringUtilities.isEmpty((String)this.name)) {
            return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "emptyTranslatorOverrideName", new Object[0]);
        }
        char[] cArray = this.name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_') {
                return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "invalidTranslatorOverrideName", new Object[0]);
            }
            ++n2;
        }
        for (String existingName : this.existingNames) {
            if (!existingName.equals(this.name)) continue;
            return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "translatorOverrideAlreadyExists", new Object[0]);
        }
        if (CoreStringUtil.isEmpty((String)this.type)) {
            return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "translatorOverrideTypeMissing", (Object)this.name);
        }
        if (this.name.equalsIgnoreCase(this.type)) {
            return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "translatorOverrideNameMatchesTranslatorType", new Object[0]);
        }
        return null;
    }
}

