/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.editor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbImportVdbEntry;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class ShowImportVdbsDialog
extends Dialog {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ShowImportVdbsDialog.class);
    private static final String TITLE = ShowImportVdbsDialog.getString("title");
    private Vdb vdb;
    TableViewer importVdbViewer;

    private static String getString(String id) {
        return VdbUiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ShowImportVdbsDialog(Shell parent, Vdb vdb) {
        super(parent, TITLE);
        this.vdb = vdb;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainPanel = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        mainPanel.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        Group theGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)ShowImportVdbsDialog.getString("vdbNames"), (int)0, (int)1, (int)4);
        GridData groupGD = new GridData(1808);
        groupGD.heightHint = 200;
        groupGD.widthHint = 400;
        theGroup.setLayoutData((Object)groupGD);
        this.importVdbViewer = new TableViewer((Composite)theGroup, 2816);
        this.importVdbViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (element instanceof VdbImportVdbEntry) {
                    return ((VdbImportVdbEntry)element).getName();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof VdbImportVdbEntry) {
                    return VdbUiPlugin.singleton.getImage("icons/full/obj16/VDB.gif");
                }
                return null;
            }
        });
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.importVdbViewer.getControl().setFont(JFaceResources.getTextFont());
        this.importVdbViewer.getControl().setLayoutData((Object)data);
        if (this.vdb != null) {
            for (VdbImportVdbEntry row : this.vdb.getImports()) {
                if (row == null) continue;
                this.importVdbViewer.add((Object)row);
            }
        }
        return mainPanel;
    }
}

